<?php
if(php_sapi_name() !== 'cli' and php_sapi_name() !== 'cgi' and php_sapi_name() !== 'cgi-fcgi'){
	die('unauthorized call');
}
include('includes/cron_application_top.php');
if(MODULE_OTHER_YES_HITMEISTER_API_STATUS != 'True'){
    die('Kaufland module inactive');
}
require_once(DIR_WS_CLASSES.'yes_hitmeister.php');
require_once(DIR_WS_CLASSES.'product.php');
require_once(DIR_WS_CLASSES.'simple_lock.php');
require_once(DIR_WS_CLASSES.'customer.php');
require_once(DIR_WS_CLASSES.'order.php');
require_once(DIR_FS_INC.'xtc_oe_get_price_o_tax.inc.php');
require_once(DIR_FS_INC.'xtc_oe_customer_infos.inc.php');
require_once(DIR_FS_INC.'yes_get_sha1_from_string.inc.php');
require_once(DIR_FS_CATALOG.'includes/classes/xtcPrice.php');
require_once(DIR_FS_INC.'yes_end_auction_add.inc.php');
require_once(DIR_FS_INC.'xtc_get_orders_ebay_seller.inc.php');
require_once(DIR_FS_INC . 'xtc_format_price_order.inc.php');
require_once(DIR_FS_INC . 'xtc_generate_packingslip_barcode.inc.php');

// NUR BEI CRONJOBS
//require_once(DIR_FS_CATALOG.'lang/german/admin/german.php');
require_once(DIR_FS_INC.'xtc_get_order_html_for_pdf.inc.php');

define('MODULE_OTHER_YES_HITMEISTER_HANDLING_TIME',3);

require_once(DIR_WS_CLASSES.'class.basics.php');
require_once(DIR_FS_CATALOG.DIR_WS_CLASSES.'class.phpmailer.php');
require_once(DIR_WS_CLASSES . 'currencies.php');
require_once('includes/classes/class.ebaymail.php');
require_once(DIR_FS_INC .'yes_write_notice.inc.php');
//require(DIR_FS_CATALOG.'lang/german/admin/orders.php');
$recipients = main::get_notice_recipients('orders');
$lock = new simple_lock(\main::get_exportdata_path().basename($argv[0]).'.LOCK');
$lock->lock();
try{
    $YH = new yes_hitmeister();
}catch(Exception $ex){
    $lock->destroy();
    die($ex->getMessage());
}

// TICKET BENACHRICHTIGUNGEN LOESCHEN DIE AELTER SIND ALS EIN TAG
xtc_db_query(sprintf(
        "DELETE FROM hitmeister_tickets WHERE date_added < '%s'",
        date('Y-m-d H:i:s',(time()-(60*60*24) ))
));

$client = $YH->client;
//ALT
//$seller_orders = $client->orders()->find();
$res = json_decode($YH->get_order());
$seller_orders = $res->data;

//ALT
//$tickets = $client->tickets()->seller('opened');
$res = json_decode($YH->get_tickets(Null, 'opened'));
$tickets = $res->data;



$notify_tickets = array();
foreach($tickets as $t){
    $messages = array();
    // ALT
    // $ticket = $client->tickets()->get($t->id_ticket,array('messages','item'));
    $res = json_decode($YH->get_tickets($t->id_ticket));
    $ticket = $res->data;
    if($ticket->is_seller_responsible != 1){
        continue;
    }
    $query = xtc_db_query(sprintf(
            "SELECT hitmeister_tickets_id FROM hitmeister_tickets WHERE id_ticket='%s' AND id_buyer='%s'",
            $t->id_ticket, $t->id_buyer
    ));
    if(xtc_db_num_rows($query)){
        continue;
    }
    foreach($ticket->messages as $msg){
        $messages[] = '['.$msg->author->role.'] '.$msg->text;
    }
    $notify_tickets[] = sprintf(
            "Ticket vom: %s\r\n".
            "Grund: %s\r\n".
            "Tel: %s\r\n".
            "Item: %s\r\n".
            "Message(s):\r\n\r\n%s",
            xtc_date_short($ticket->ts_created),
            $ticket->open_reason,
            $ticket->callback_phone,
            $ticket->item->title,
            implode("\r\n\r\n",$messages)
    );
    $insert_sql_array = array(
        'id_ticket'=>$t->id_ticket,
        'id_buyer'=>$t->id_buyer,
        'date_added'=>'now()'
    );
    xtc_db_perform('hitmeister_tickets',$insert_sql_array);
}
if(sizeOf($notify_tickets)){
    $tickets_link = '<a href="hitmeister.php" target="_blank"><u>Kaufland Auftr&auml;ge</u></a>';
    yes_write_notice(sizeOf($notify_tickets).' offene Kaufland Tickets', $tickets_link."\r\n".implode("\r\n",$notify_tickets) , 0, $recipients);
}
foreach($seller_orders as $so){
    $io = $YH->import_order($so->id_order);
    if($io['orders_id'] < 1){
        printf("Kaufland Order %s Import Error: %s\r\n",$so->id_order,$io['error']);
    }else{
        printf("Kaufland Order %s Import as oID %d\r\n",$so->id_order,$io['orders_id']);
    }
}

$query = xtc_db_query(
        "SELECT * FROM hitmeister_orders WHERE invoice_upload='0'"
);

error_reporting(E_ERROR); // besonders fuer smarty
while( $record = xtc_db_fetch_array($query)){
		$id_order  = $record['hitmeister_id_order'];
		$orders_id = $record['orders_id'];
                printf("\r\ngetting data for id_order %s, orders_id %d\r\n",$id_order, $orders_id);

		if(empty($id_order) or empty($orders_id)){
                        printf('Fehlender Wert. id_order: %s, orders_id: %d',
                                $id_order, $orders_id
                        );
                        continue;
		}
		$order = new order($orders_id);
                if( gettype($order->info) == 'NULL' ){
                    printf("Importfehler: YES Auftrag %d zum Kaufland Auftrag %s existiert nicht\r\n",
                                $orders_id, $id_order
                    );
                    continue;
                }
                if(!in_array($order->info['orders_status'],[ORDERS_STATUS_ABGESCHLOSSEN])){
                    printf("Auftrag oID %d (Kaufland Order %s) hat Status %s und muss noch warten.\r\n",
                                $orders_id, $id_order,$order->info['orders_status_name']
                    );
                    continue;
                }
		$xtPrice = new xtcPrice($order->info['currency'],$order->info['status']);
		$pdf_smarty = new yesSmarty;
		$pdf_order_html=xtc_get_order_html_for_pdf($order,$pdf_smarty,CURRENT_TEMPLATE . '/admin/mail/german/pdf_order.html');
		// FUEGE ORDER AN GESAMTPDF AN
		$pdf_file = \main::get_exportdata_path().'HITMEISTER_INVOICE_ORDER_'.$orders_id.'_'.$id_order.'.pdf';
		if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
		    $headerandfooter=(strstr(HTTP_SERVER,'localhost')) ? true : false;
		    $pdf = new yes_pdf($headerandfooter);
		    if(DOMPDF_ORDER_LANDSCAPE == 'True'){
			$pdf->set_landscape();
		    }
		    $pdf->set_html($pdf_order_html);
		    $pdf->save($pdf_file);
		}else{
		    $order_pdf=new HTML2FPDF();
		    $order_pdf->AddPage();
		    $order_pdf->WriteHTML($pdf_order_html);
		    $order_pdf->Output($pdf_file,'F'); //Read the FPDF.org manual to know the other options
		}
		$PDF_BIN = file_get_contents($pdf_file);
		unlink($pdf_file);
		$basics = new basics;
		$parts = parse_url(HTTP_SERVER);
		$fn = $basics->get_valid_filename_from_string($parts['host'].'_'.TEXT_ORDER.'_'.$orders_id).'.pdf';
                $response = json_decode($YH->order_invoice_upload($id_order,$fn,base64_encode($PDF_BIN)));
                $msg = 'Error, cant upload PDF';
		if(isset($response->data->id_invoice)){
			$update_sql_array = array(
				'invoice_upload'=>1
			);
			xtc_db_perform('hitmeister_orders',$update_sql_array,'update',"orders_id='".$orders_id."' and hitmeister_id_order='".$id_order."'");
                        $msg = 'Order Invoice '.$response->data->id_invoice.' created.';
                        $order->add_history($order->info['orders_status'], false, 'Autom. Kaufland Rechnungsupload.');
		}else{
                    $msg = "\r\nFEHLER BEIM PDF UPLOAD CALL".print_r($response,true);
                    yes_mail_debug($msg);
                }
                echo $msg."\r\n";
                
}
$lock->destroy();


