<?php
// ITEMS = REAL KATALOG
// PRODUCTS = ZUGEWIESENE ITEMS ZU EINEM SELLER (MIT PREIS ETC)
// item = IM KATALOG VON REAL
// unit = EINEM SELLER ZUGEWIESEN

// Es wird ein Logfile in secure_path/ORDER_IMPORT_STATUS_LOGFILE_NAME erstellt

include('includes/cron_application_top.php');
if(!defined('MODULE_OTHER_YES_HITMEISTER_API_STATUS') or MODULE_OTHER_YES_HITMEISTER_API_STATUS != 'True'){
    die("Hitmeister/Real not active");
}
$_SESSION['languages_id'] = 2;
$_SESSION['language'] = 'german';
error_reporting(E_ERROR);
@set_time_limit(0);
ini_set('memory_limit','512M');
require_once(DIR_WS_CLASSES.'simple_lock.php');
$lock = new simple_lock(\main::get_exportdata_path().basename(__FILE__).'.lock',true);
$lock->lock();

require_once(DIR_WS_CLASSES.'yes_hitmeister.php');
require_once(DIR_WS_CLASSES.'product.php');
require_once(DIR_WS_CLASSES.'customer.php');
require_once(DIR_WS_CLASSES.'order.php');
require_once(DIR_WS_CLASSES.'class.basics.php');
require_once(DIR_FS_CATALOG.DIR_WS_CLASSES.'class.phpmailer.php');
require_once('includes/classes/class.ebaymail.php');
require_once(DIR_FS_INC.'xtc_oe_get_price_o_tax.inc.php');
require_once(DIR_FS_INC.'xtc_oe_customer_infos.inc.php');
require_once(DIR_FS_INC.'yes_end_auction_add.inc.php');
require_once(DIR_WS_CLASSES . 'currencies.php');
require_once(DIR_FS_INC.'yes_get_sha1_from_string.inc.php');
require_once(DIR_FS_CATALOG.'includes/classes/xtcPrice.php');
require_once(DIR_WS_CLASSES.'split_page_results_array.php');
require_once(DIR_FS_INC.'xtc_oe_get_price_o_tax.inc.php');
require_once(DIR_FS_INC.'xtc_oe_customer_infos.inc.php');
require_once(DIR_FS_INC.'yes_end_auction_add.inc.php');
// HISTORY_ORDER_EMAIL, TEXT_ORDER_EMAIL_SUBJECT
require_once(DIR_FS_CATALOG.'lang/german/admin/orders.php');
require_once(DIR_FS_INC.'xtc_get_orders_ebay_seller.inc.php');
require_once(DIR_FS_INC . 'xtc_format_price_order.inc.php');
require_once(DIR_FS_INC . 'xtc_generate_packingslip_barcode.inc.php');

require_once(DIR_FS_INC.'xtc_get_order_html_for_pdf.inc.php');

$YH = new yes_hitmeister();
$status_logfile = main::get_secure_path().yes_hitmeister::ORDER_IMPORT_STATUS_LOGFILE_NAME;
if(file_exists($status_logfile)){
    unlink($status_logfile);
}
$client = $YH->client;
$smarty = new yesSmarty;
$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
define('HITMEISTER_ATTRIBUTES_TEXTAREA_ROWS',3);
define('HITMEISTER_ATTRIBUTES_TEXTAREA_COLS',40);
define('HITMEISTER_ATTRIBUTES_SHORTTEXT_MAXLENGTH',512);
define('HITMEISTER_ATTRIBUTES_SMALLTEXT_MAXLENGTH',1024);
define('HITMEISTER_ATTRIBUTES_PICTURE_INPUT_SIZE', 60);
define('HITMEISTER_ATTRIBUTES_TINYTEXT_SIZE',40);
define('HITMEISTER_ATTRIBUTES_TINYTEXT_MAXLENGTH',255);
define('HITMEISTER_ATTRIBUTES_SI_SIZE',16);
define('HITMEISTER_ATTRIBUTES_SI_MAXLENGTH',16);
// DEFAULT
define('HITMEISTER_ATTRIBUTES_TEXT_INPUT_SIZE',16);
define('HITMEISTER_ATTRIBUTES_TEXT_INPUT_MAXLENGTH',16);

/*

// ARTIKEL MIT HITMEISTER ZUWEISUNG ABER OHNE id_unit
// ES KANN TROTZDEM VORKOMMEN DASS ARTIKEL KEINE id_unit HABEN, ABER DANN DUERFTEN
// SIE THEORETISCH AUCH KEINE VERKAEUFE HABEN

$q = xtc_db_query(
	"SELECT * FROM hitmeister_products WHERE id_unit=''"
);
$succfail = ['s'=>0,'f'=>0];
while($r = xtc_db_fetch_array($q)){
	$res = json_decode($YH->get_products($r['hitmeister_id_item'],['units']));
	$u = current( $res->data->units );
	if( (int) $u->id_unit < 1 ){
		echo $r['products_id'].' hat keine units Daten'."\r\n";
		$succfail['f']++;
		continue;
	}
	$update_sql_array = [
		'id_unit'=>$u->id_unit,
		'quantity'=>$u->amount
	];
	xtc_db_perform('hitmeister_products',$update_sql_array,'update',"hitmeister_products_id='".$r['hitmeister_products_id']."'");
	echo $r['products_id'].' hinterlegt mit '.$u->id_unit."\r\n";
	$succfail['s']++;
}
print_r($succfail);
$lock->destroy();die('mario testet');
*/


function hitmeister_order_import_crawler( yes_hitmeister $YH,Hitmeister\Component\Api\Client $client, int $offset=0){
    global $logfile_contents;
    $limit= 100;
    $createdFrom = date('c',time()-(60*60*24*3));
    printf("\r\nfind(%s, %d, %d) logfile_content size %d\r\n",$createdFrom, $limit, $offset,
            sizeOf($logfile_contents)
    );
    $res = json_decode( $YH->get_orders($createdFrom, $limit, $offset) );
    $pagination = $res->pagination;
    $seller_orders = $res->data;
    // ALT
    // $seller_orders = $client->orders()->find($createdFrom, Null, $limit, $offset);
    foreach($seller_orders as $so){
        $import_status = $YH->import_order($so->id_order);
        
        if(isset($import_status['error']) and $import_status['error'] != ''){
            if(strpos($import_status['error'],'always imported')){
                continue;
            }
            $logfile_contents[] = $import_status['error'];
        }
    }
    if($pagination->total > ($offset+$limit)){
        hitmeister_order_import_crawler( $YH,$client, ($offset+$limit));
    }
}
$logfile_contents = array();
$num = 0;
hitmeister_order_import_crawler( $YH,$client);
if(sizeOf($logfile_contents)){
    file_put_contents($status_logfile,implode(PHP_EOL,$logfile_contents));
    printf("\r\nLogfile %s mit %d Order Lines erzeugt\r\n",
            basename($status_logfile),
            sizeOf($logfile_contents)
    );
}
$lock->destroy();
die("\r\nDone\r\n");
