<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                              Author M. ASPELEITER <dazze@gmx.de
                                             Copyright (c) 2004 mario aspeleiter
					     



   ---------------------------------------------------------------------------*/
require_once('includes/classes/class.csv.php');
require_once(DIR_FS_CATALOG.'lang/german/admin/module_export.php');
define('TABLE_PERSONAL_OFFERS_BY','personal_offers_by_customers_status_');
$step = 1;
$target_path = \main::get_exportdata_path().'0000IMPORTCSPI.csv';
$basics = new basics;

require_once(DIR_WS_CLASSES.'class.products_export.php');
require_once(DIR_WS_MODULES.'export/customers_status_prices.php');
$cspi = new customers_status_prices;
function clean_csv_tag($str){
	if($str[0] == '"')
		$str = substr($str,1,strlen($str));
	if($str[ (strlen($str)-1) ] == '"')
		$str = substr($str,0,(strlen($str)-1));
	return str_replace('""','"',$str);
}

function display_import_field($key,$value) {
	switch($key){
		case 'products_name':
			$value = strip_tags($value);
			if(strlen($value)>40){
				$value = substr($value,0,40).'...';
			}
			break;
	}
	return $value;
}
$COMMENT_STRING = 'KDG Preis CSV IMPORT'; // Artikelhistorie
$no_import_config = false;
//$header = $cspi->get_header();
$csID = (isset($_REQUEST['customers_status'])) ? (int)xtc_db_input($_REQUEST['customers_status']) : false;
if($csID !== false and $csID < 1){
    $csID = false;
}
if($csID !== false){
    $importheader = $cspi->get_schema();
}
if(isset($_GET['mode'])){
    switch($_GET['mode']){
	case 'save':
            $table = sprintf('%s%s',TABLE_PERSONAL_OFFERS_BY,$csID);
	    $CSV = new CSVfile($target_path);
	    $CSV->delimiter = "\t";
	    $CSV->open('r');
	    $row = 0;
            \YES4Trade\Model\group_prices::truncate_table( $csID );
            $current_products_id = 0;
	    while($line = $CSV->readRow()){
		if($row < 1){
		    $row++;
		    continue;
		}
                $pID = (int)$line[0];
                if(!product::exists($pID)){
                    continue;
                }
                $qty = (int)$line[1];
                $personal_offer = (float)str_replace(',','.',$line[2]);
		if($qty < 1 or $personal_offer === 0){
			continue;
		}
                
                if($current_products_id === 0){
                    $current_products_id = $pID;
                }else{
                    if($current_products_id != $pID){
                        product::add_history_static($current_products_id, $COMMENT_STRING);
                        $current_products_id = $pID;
                    }
                }
                $GPI = new \YES4Trade\Model\group_prices_item([
                    'products_id'=>$pID,
                    'quantity'=>(int)$line[1],
                    'personal_offer'=>$personal_offer
                ]);
                $GPI->create($csID);
	    } // end while line
            // DEN LETZTEN KOMMENTAR SCHREIBEN
            if($current_products_id > 0){
                product::add_history_static($current_products_id, $COMMENT_STRING);
            }
            
	    unlink($target_path);
	    $messageStack->add_session(MSG_IMPORT_SUCCESS,'success');
	    xtc_redirect(xtc_href_link('categories.php'));
	    break;
	default:
	    if(file_exists($target_path)){
                unlink($target_path);
            }
	    $messageStack->add_session(MSG_IMPORT_CANCELLED,'error');
	    xtc_redirect(xtc_href_link('categories.php','action=customers_status_prices_import'));
	    break;
	}
}
if (isset($_FILES['importfile'])){
	if ($_FILES["importfile"]["error"] > 0){
            $messageStack->add_session(MSG_ERROR_IMPORT_DEFECT,'error');
            xtc_redirect(xtc_href_link('categories.php?action=yes_import2'));
	}
	if(file_exists($target_path)){
            unlink($target_path);
        }
	if (move_uploaded_file($_FILES['importfile']['tmp_name'], $target_path)) {
            $step = 2;
	}else{
            $messageStack->add_session(MSG_ERROR_IMPORT_NOT_WRITABLE,'error');
            xtc_redirect(xtc_href_link('categories.php?action=yes_import2'));
	}
} 

$smarty = new yesSmarty;
yes_draw_pre_header();
yes_draw_header(TITLE);
$buttons = array();
$smarty->assign(array(
    'HEADING_TITLE'=>HEADING_TITLE_CUSTOMERS_STATUS_PRICES_IMPORT,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
    'language_path'=>DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
    'STEP'=>$step,
    'FORM_END'=>'</form>',
    'TEXT_IMPORT'=>BUTTON_IMPORT,
    'TEXT_CUSTOMERS_STATUS_DETECTED'=>TEXT_CUSTOMERS_STATUS_DETECTED,
    'TEXT_SELECT_CUSTOMERS_STATUS'=>TEXT_SELECT_CUSTOMERS_STATUS
));
switch($step){
	case 1:
	    $smarty->assign(array(
		'INTRO'=>TEXT_IMPORT_STEP1_INTRO,
		'FORM'=>  xtc_draw_form('import_csv_form', FILENAME_CATEGORIES, 'action=customers_status_prices_import', 'POST', 'enctype="multipart/form-data"'),
		'TEXT_IMPORT_USE_CUSTOMERS_STATUS'=>TEXT_IMPORT_USE_CUSTOMERS_STATUS,
		'INPUT_CUSTOMERS_STATUS'=>xtc_draw_pull_down_menu('customers_status',$cspi->get_cs_array(),$csID),
	    ));
	    break;
	case 2:
	    $CSV = new CSVfile($target_path);
	    $CSV->delimiter = "\t";
	    $CSV->open('r');
	    $row = 0;
	    $csv_data = array();
	    while($line = $CSV->readRow()){
		    if($row == 0){
			$row++;
			continue;
		    }
		    $row_cols = array();
		    foreach($line as $k=>$v){
			if(isset($importheader[$k][0])){
			    $row_cols[] = display_import_field($importheader[$k][0],$v);
                        }
		    }
		    $csv_data[] = $line;
		    $row++;
	    }
	    $smarty->assign(array(
		'INTRO'=>sprintf(TEXT_IMPORT_STEP2_INTRO,sizeOf($csv_data)),
		'HINT'=>TEXT_IMPORT_CUSTOMERS_STATUS_PRICES_STEP2_HINT,
		'IMAGE_CANCEL'=>IMAGE_CANCEL,
		'IMAGE_SAVE'=>IMAGE_SAVE,
		'SUBMIT_LINK'=>xtc_href_link(FILENAME_CATEGORIES,'action=customers_status_prices_import&mode=save'.((isset($_REQUEST['customers_status'])) ? '&customers_status='.$_REQUEST['customers_status'] : '')),
		'importheader'=>$importheader,
		'CSV_DATA'=>$csv_data
	    ));
	    break;
}
$smarty->display('customers_status_prices_import.tpl');
require(DIR_WS_INCLUDES . 'footer.php'); 
require(DIR_WS_INCLUDES . 'application_bottom.php'); 
