<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                             Author M. ASPELEITER <dazze@gmx.de>
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/

require('includes/application_top.php');
$languages = xtc_get_languages();
$musthaves = [
    'DISTRIBUTOR_ORDERS_STATUS_OFFEN'=>false,
    'DISTRIBUTOR_ORDERS_STATUS_BESTELLT'=>false,
    'DISTRIBUTOR_ORDERS_STATUS_EINGETROFFEN'=>false,
    'DISTRIBUTOR_ORDERS_STATUS_STORNIERT'=>false
];
$action = (isset($_GET['action'])) ? $_GET['action'] : '';
switch ($action) {
    case 'create_musthaves':
        foreach($musthaves as $m=>$egal){
            \YES4Trade\Model\distributor_orders_status::delete( constant($m) );
            foreach($languages as $l){
                $new = new \YES4Trade\Model\distributor_orders_status([
                    'orders_status_id' => (int)constant($m),
                    'language_id'=>$l['id'],
                    'orders_status_name'=>constant($m.'_TITLE')
                ]);
                $new->create();
            }
        }
        $messageStack->add_session(MSG_SUCCESS_MUSTHAVES_CREATED,'success');
        xtc_redirect(xtc_href_link(basename(__FILE__)));
        break;
    case 'new':
    case 'edit':
        $orders_status_inputs = [];
        for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
            if($action == 'edit'){
                $item = \YES4Trade\Model\distributor_orders_status::get_by_orders_status_id_and_language_id((int)xtc_db_input($_GET['dosID']),$languages[$i]['id']);
            }else{
                $item = null;
            }
            if($item !== null){
                $title = $item->orders_status_name;
            }else{
                $title = '';
            }
            $orders_status_inputs[] = xtc_image(DIR_WS_LANGUAGES.$languages[$i]['directory'].'/admin/images/'.$languages[$i]['image']) 
                . '&nbsp;' 
                . xtc_draw_input_field('orders_status_name[' . $languages[$i]['id'] . ']', 
                      $title  
                );
        }
        if($action == 'edit'){
            echo xtc_draw_form('dos_edit_form',basename(__FILE__),xtc_get_all_get_params(['action']).'action=save','POST');
            printf('<b>%s: %d</b>',DISTRIBUTOR_ORDERS_STATUS_ID,$_GET['dosID']);
        }else{
            echo xtc_draw_form('dos_insert_form',basename(__FILE__),xtc_get_all_get_params(['action']).'action=insert','POST');
        }
        printf('<p>%s</p>',DISTRIBUTOR_ORDERS_STATUS_NAME);
        echo implode('<br />',$orders_status_inputs);
        if($action == 'edit'){
            printf('<br /><br />%s %s',
                  xtc_draw_checkbox_field('default','1',(DEFAULT_DISTRIBUTOR_ORDERS_STATUS_ID == $oInfo->orders_status_id)),
                  TEXT_SET_DEFAULT
            );
        }else{
            printf('<br /><br />%s %s',
                  xtc_draw_checkbox_field('default','1',false),
                  TEXT_SET_DEFAULT
            );
        }
        printf('<br /><input type="submit" value="%s" class="ui-button ui-corner-all ui-state-default" /></form>', IMAGE_SAVE);
        exit;
        break;
    case 'insert':
    case 'save':
        if(isset($_GET['dosID'])){
            $orders_status_id = (int)xtc_db_prepare_input( $_GET['dosID'] );
        }else{
            $next_id_query = xtc_db_query("SHOW TABLE STATUS LIKE 'distributor_orders_status'");
            $next_id = xtc_db_fetch_array($next_id_query);
            $orders_status_id = (int)$next_id['Auto_increment'] + 1;
        }
        $orders_status_name_array = $_POST['orders_status_name'];
        for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
            $language_id = (int)$languages[$i]['id'];
            $name = xtc_db_prepare_input($orders_status_name_array[$language_id]);
            if ($_GET['action'] == 'insert') {
                $new = new \YES4Trade\Model\distributor_orders_status([
                    'orders_status_id'=>$orders_status_id,
                    'language_id'=>$language_id,
                    'orders_status_name'=>$name
                ]);
                $new->create();
            } elseif ($_GET['action'] == 'save') {
                $update = new \YES4Trade\Model\distributor_orders_status([
                    'orders_status_id'=>$orders_status_id,
                    'language_id'=>$language_id,
                    'orders_status_name'=>$name
                ]);
                $update->update();
            }
        }
        if ( isset($_POST['default']) and $_POST['default'] == '1' ) {
            main::update_configuration_value('DEFAULT_DISTRIBUTOR_ORDERS_STATUS_ID', xtc_db_input($orders_status_id));
        }
        $messageStack->add_session(MSG_SUCCESS_DOS_SAVED);
        xtc_redirect(xtc_href_link('distributor_orders_status.php'));
        break;
    case 'deleteconfirm':
        $doID = (int)xtc_db_prepare_input($_GET['dosID']);
        $os = (int)main::get_configuration_value('DEFAULT_DISTRIBUTOR_ORDERS_STATUS_ID');
        if ($os == $doID) {
            main::update_configuration_value('DEFAULT_DISTRIBUTOR_ORDERS_STATUS_ID', '');
        }
        \YES4Trade\Model\distributor_orders_status::delete($doID);
        xtc_redirect(xtc_href_link('distributor_orders_status.php'));
        break;
    case 'delete':
        $doID = xtc_db_prepare_input($_GET['dosID']);
        $status_query = xtc_db_query("select count(*) as count from distributor_orders where orders_status = '" . xtc_db_input($doID) . "'");
        $status = xtc_db_fetch_array($status_query);
        $error_msg = '';
        $remove_status = true;
        if ($doID == DEFAULT_DISTRIBUTOR_ORDERS_STATUS_ID) {
            $remove_status = false;
            $error_msg = ERROR_REMOVE_DEFAULT_ORDER_STATUS;
        } elseif ($status['count'] > 0) {
            $remove_status = false;
            $error_msg = ERROR_STATUS_USED_IN_ORDERS;
        } else {
            $history_query = xtc_db_query("select count(*) as count from distributor_orders_status_history where orders_status_id = '" . xtc_db_input($doID) . "'");
            $history = xtc_db_fetch_array($history_query);
            if ($history['count'] > 0) {
                $remove_status = false;
                $error_msg = ERROR_STATUS_USED_IN_HISTORY;
            }
        }
        if(!$remove_status){
            die($error_msg);
        }
        printf('<p>%s</p><a href="%s"><button class="ui-button ui-corner-all ui-state-error" type="button">%s</button></a>',
            REALLY_DELETE_DOS,
            xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['action']).'action=deleteconfirm'),
            IMAGE_DELETE
        );
        exit;
        break;
}
yes_draw_pre_header();
yes_draw_header(TITLE);
$smarty = new yesSmarty;
$smarty->assign('language_path',DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
$buttons = array();
$buttons[] = array('text'=>IMAGE_INSERT,
    'link'=>xtc_href_link('distributor_orders_status.php', 'action=new'),
    'lbOn'=>true,
    'auth'=>true
);

$table = new tableBlock();
$table->table_parameters = 'class="yesListTable_minimal" style="width: auto;"';
$contents = [[
    ['text'=>'ID','th'=>true],
    ['text'=>'Status','th'=>true],
    ['text'=>'Aktion','th'=>true],
]];
$items = \YES4Trade\Model\distributor_orders_status::get_by_language_id((int)$_SESSION['languages_id']);
$mharr = [];
foreach($musthaves as $m=>$egal){
    $mharr[] = constant($m.'_TITLE').' ID '.constant($m);
}
$musthaves_str = '<b>Systemeinträge:</b> '.implode(', ',$mharr);
foreach($items as $it){
    foreach($musthaves as $key=>$exists){
        if(constant($key) == $it->orders_status_id){
            $musthaves[ $key ] = true;
        }
    }
    $links = [
        sprintf('<a title="%s" class="dos_edit" href="javascript:;" data-ordersstatusid="%d">%s</a>',
            IMAGE_EDIT,
            $it->orders_status_id,
            smarty_function_icon(['type'=>'edit','title'=>IMAGE_EDIT], $smarty)
        ),
        sprintf('<a title="%s" class="dos_delete" href="javascript:;" data-ordersstatusid="%d">%s</a>',
            IMAGE_DELETE,
            $it->orders_status_id,
            smarty_function_icon(['type'=>'delete','title'=>IMAGE_DELETE], $smarty)
        ),
    ];
    $contents[] = [
        ['text'=>$it->orders_status_id],
        ['text'=>$it->orders_status_name],
        ['text'=>implode('&nbsp;',$links)],
    ];
}
$smarty->assign(array(
    'HEADING_TITLE'=>HEADING_TITLE,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
    'TABLE'=>$table->tableBlock_draw($contents),
    'DISTRIBUTOR_ORDERS_STATUS_MUSTHAVES_TEXT'=>sprintf(DISTRIBUTOR_ORDERS_STATUS_MUSTHAVES_TEXT,
        sizeOf($musthaves),
        sprintf('<a href="%s">[%s]</a>',
                xtc_href_link(basename(__FILE__),'action=create_musthaves'),
                DISTRIBUTOR_ORDERS_STATUS_MUSTHAVES_LINK_TEXT
        )
    ),
    'MUSTHAVES'=>$musthaves_str
));
$smarty->display('distributor_orders_status.html');
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');