<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                             Author M. ASPELEITER <dazze@gmx.de>
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/
set_time_limit(0);
require('includes/config.ebayapi.inc.php');

if(defined('NO_CRONJOBS'))
	die('No cronjob!');

require('includes/cron_application_top.php');
require('includes/classes/class.ebay.php');
require('includes/classes/class.storagequantity.php');
require(DIR_FS_INC.'xtc_get_products_stock.inc.php');
require(DIR_FS_INC.'xtc_get_tax_class_id.inc.php');
require_once(DIR_FS_INC.'yes_write_notice.inc.php');

require_once(DIR_FS_ADMIN.DIR_WS_CLASSES.'class.group_handler.php');
require_once(DIR_FS_INC.'xtc_productgroups.inc.php');
require(DIR_FS_INC.'xtc_get_site_country_id.inc.php');
require(DIR_FS_INC.'xtc_is_language_installed.inc.php');


require_once ABS_PATH_TO_PHPAPI.'ebat/EbatNs_ServiceProxy.php';
require_once ABS_PATH_TO_PHPAPI.'ebat/EbatNs_Logger.php';
require_once ABS_PATH_TO_PHPAPI.'ebat/AddItemRequestType.php';
require_once ABS_PATH_TO_PHPAPI.'ebat/AddFixedPriceItemRequestType.php';
require_once ABS_PATH_TO_PHPAPI.'ebat/RelistItemRequestType.php';

$notice_users = array();
$userquery = yes_db_query("select customers_id from admin_access WHERE ebayapi_cart=1 and customers_id != 1",true);
if($userquery){
	foreach($userquery as $user){
		$notice_users[] = $user['customers_id'];
	}
}
$notice_sender = 0;

$lock_query = xtc_db_query("SELECT status,last_lock FROM table_lock WHERE action_key='addtimer'");
$lock_res = xtc_db_fetch_array($lock_query);
$lock = $lock_res['status'];
if($lock == 'locked'){
	if( strtotime( $lock_res['last_lock'] )+ ( 60*20 ) <= time() ){
		xtc_db_query("UPDATE table_lock SET last_lock=now() WHERE action_key='addtimer'");
	}else{
		$subject = 'Ebayserver durch Timings ueberlastet';
		$message = 'Es wurde eben, um '.date('d.m.Y H:i:s').', versucht per Timing Auktionen bei Ebay zu listen. Dabei wurde versucht, zu viele Timings in einer zu knappen Zeitspanne, an Ebay zu senden. Definieren Sie Ihre Zeitsteuerungen/Automatics so, dass Sie zeitlich moeglichst weit auseinanderliegen um eine Ueberlastung zu verhindern.';
		$sender = 0;
		//yes_write_notice($subject,$message,$notice_sender,$notice_users);
		die('Locked: noch '.strftime("%M:%S",( (20*60)-(time()-strtotime( $lock_res['last_lock'] ) ) ) ) .' Min. (last: '.$lock_res['last_lock'].')'."\r\n");
		exit;
	}
}else{
	xtc_db_query("UPDATE table_lock SET status='locked',last_lock=now() WHERE action_key='addtimer'");
}
$EBAYAPI = new ebayAPI;

function calcElapsedTime($time)
{
       // calculate elapsed time (in seconds!)
       $diff = time()-$time;
       $daysDiff = 0; $hrsDiff = 0; $minsDiff = 0; $secsDiff = 0;

       $sec_in_a_day = 60*60*24;
       while($diff >= $sec_in_a_day){$daysDiff++; $diff -= $sec_in_a_day;}
       $sec_in_an_hour = 60*60;
       while($diff >= $sec_in_an_hour){$hrsDiff++; $diff -= $sec_in_an_hour;}
       $sec_in_a_min = 60;
       while($diff >= $sec_in_a_min){$minsDiff++; $diff -= $sec_in_a_min;}
       $secsDiff = $diff;

       return $daysDiff+$hrsDiff+$minsDiff+$secsDiff;
}

$auktionen_array = array();
$auction_query = xtc_db_query("SELECT e.id,e.products_id,e.quantity,e.select_set_multiple FROM ebay_auctions e WHERE e.status=1 and e.cronstart<now() and e.not_valid=0 and e.locked=0 LIMIT 40");
while($auction = xtc_db_fetch_array($auction_query)) {
	$auktionen_array[] = $auction;
}
if(!sizeOf($auktionen_array)){
	die('Nothing to do.');
}
foreach($auktionen_array as $auktionen){
    $ea = new ebay_auction($auktionen['id']);
    $data = $ea->getSQLArray();
    $okay = true;
	$locked_error = false;

	$einstellmenge = $auktionen['quantity'];
	if($auktionen['select_set_multiple']>0)
		$einstellmenge = $einstellmenge*$auktionen['select_set_multiple'];
		
	$variations_products = $EBAYAPI->get_auction_variationset_products($auktionen['id']);

	if(EBAY_LIST_ONLY_ACTIVE_PRODUCTS == 'true'){
		$delete_auction = false;
		if(sizeOf($variations_products)){
			for($vpi=0;$vpi<sizeOf($variations_products);$vpi++){
				if($EBAYAPI->get_products_status($prod['products_id']) == 0){
					$delete_auction = true;
				}
			}
		}else{
			if($EBAYAPI->get_products_status($auktionen['products_id']) == 0){
					$delete_auction = true;
			}
		}
		if($delete_auction){
			$ea->delete();
			if(EBAY_PRODUCTS_HISTORY == 1){
				$EBAYAPI->save_history($ea->getEbayProductsId(),sprintf(TEXT_HISTORY_DELETED_INACTIVE,$auktionen['products_id']),0);	
			}
			if(PRODUCTS_QUANTITY_LOG_MODE == 1){
				$SQ->update_log('in_timing', -$einstellmenge);
			}
			$subject = sprintf(NOTICE_SUBJECT_INACTIVE_ERROR,$data['ebay_products_id']);
			$message = sprintf(NOTICE_BODY_INACTIVE_ERROR,$data['ebay_products_id'],$auktionen['products_id']);
			$sender = 0;
			yes_write_notice($subject,$message,$sender,$notice_users);
			continue;
		}
	}

	$ebay_products_lock_query = xtc_db_query(sprintf(
			"SELECT locked FROM ebay_products WHERE id=%s",
			$data['ebay_products_id']
	));
	$ebay_products_lock = xtc_db_fetch_array($ebay_products_lock_query);
	if($ebay_products_lock['locked'] == 1){
		$okay = false;
		$locked_error = true;
		$message = sprintf("Ein Timing aus Sammlerprodukt Nr %s - %s (pID: %s) wurde geloescht da das Sammlerprodukt gesperrt ist.",
			$data['ebay_products_id'],$ea->getTitle(),$auktionen['products_id']
		);
		yes_write_notice("Timing Lock ".$ea->getTitle(),$message,$notice_sender,$notice_users);
		$ea->delete();
		continue;
	}

    // BESTANDSPRUEFUNG
    if(STOCK_CHECK == 'true' && $okay){
		if(sizeOf($variations_products)){
			for($vpi=0;$vpi<sizeOf($variations_products);$vpi++){
				$prod = $variations_products[$vpi];
				$SQ = new products_quantity($prod['products_id']);
				$products_stock = $SQ->get_available1_qty();
				if( $products_stock <  $prod['quantity']){
						$okay = false;
				}
			}
		}else{
			$SQ = new products_quantity($auktionen['products_id']);
			$products_stock = $SQ->get_available1_qty();
			if( $products_stock < $einstellmenge ){
					$okay = false;
			}
		}
    }
    if(!$okay){
		xtc_db_query("UPDATE ebay_auctions SET not_valid='1' WHERE id='".$auktionen['id']."'");

		if(PRODUCTS_QUANTITY_LOG_MODE == 1){
			$SQ->update_log('in_timing', -$einstellmenge);
		}

		$message = 'Das Sammlerprodukt '.$data['ebay_products_id'].' konnte nicht eingestellt werden, da der Bestand der pID '.$auktionen['products_id'].' nur '.$products_stock.' betraegt und '.$einstellmenge.' eingestellt werden sollten';
		$subject = "Sammlerprodukt ".$data['ebay_products_id']." nicht eingestellt, Bestandsfehler";
		yes_write_notice($subject,$message,$notice_sender,$notice_users);
    }else{
	$session = new EbatNs_Session(ABS_PATH_TO_PHPAPI.'config/ebay.config.php');
	$session->setRequestToken( $EBAYAPI->getToken($ea->getUser()) );

	$site_id = $EBAYAPI->get_site_id_from_name($data['site']);
	$session->setSiteID($site_id);
	
	$cs = new EbatNs_ServiceProxy($session);
	$preisbindung_ok = true;
	$unique_check_ok = true;
	//$cs->attachLogger(new EbatNs_Logger(false),'stdin');
	if($data['relist'] < 1){
		$req = $EBAYAPI->itemAddProcess($auktionen['id'],$mode = 'timer');
		if( $req->Item->Preisbindung_valid and $req->Item->getIsUnique() ){
			if($ea->getUUID() != '')
				$req->Item->setUUID($ea->getUUID());
			$res = $cs->AddItem($req);
		}else{
			if(!$req->Item->getIsUnique()){
				$unique_check_ok = false;
			}
			if(!$req->Item->Preisbindung_valid)
				$preisbindung_ok = false;
		}
	}else{

		$unique_check_ok = true;
		if(defined('EBAY_LIST_ONLY_UNIQUE_PRODUCTS') and EBAY_LIST_ONLY_UNIQUE_PRODUCTS == 'True'){
			$unique_check_query = xtc_db_query(sprintf(
				"SELECT ebay_id FROM ebay_auctions WHERE products_id='%s' and status=0",
				$auktionen['products_id']
			));
			if(xtc_db_num_rows($unique_check_query)){
				$unique_check_ok = false;
			}
		}
		if($unique_check_ok){
			$item = new ItemType();
			$item->setItemID($data['ebay_id']);
			$req = new RelistItemRequestType();
			$req->setItem($item);
			$res = $cs->RelistItem($req);
		}
	}
	if ($unique_check_ok and $preisbindung_ok and $cs->isGood($res)) {
		if($data['relist'] < 1){
			$relist = '';
			$fees_type = $res->getFees();
			$fees = $fees_type->getFee();
			$fee_val = 0;
			foreach($fees as $k=>$fee ){
				if(is_object($fee)){
					$amount = $fee->getFee();
					if($fee->getName() == 'ListingFee')
						$fee_val = $amount->value;
				}
			}
			
			$update_sql_array = array(
					'start_time'=>$res->getStartTime(),
					'end_time'=>$res->getEndTime(), 
					'ebay_id'=>$res->getItemID(),
					'auction_fees'=>$fee_val,
					'description'=>'',
					'relist'=>'0',
					'status'=>'0'
			);
			xtc_db_perform('ebay_auctions',$update_sql_array,'update','id='.$data['id']);
		}else{
			$relist = 'Relist-';
			$fees_type = $res->getFees();
			$fees = $fees_type->getFee();
			$fee_val = 0;
			foreach($fees as $k=>$fee ){
				if(is_object($fee)){
					$amount = $fee->getFee();
					if($fee->getName() == 'ListingFee')
						$fee_val = $amount->value;
				}
			}
			// VARIATIONS
			$use_variations = false;
			$variations_set_query = xtc_db_query(sprintf(
				"SELECT ebay_variations_sets_id FROM ebay_variations_sets WHERE ebay_products_id='%s'",
				$data['ebay_products_id']
			));
			if(xtc_db_num_rows($variations_set_query)){
				$use_variations = true;
			}
				
			$insert_sql_array = $data;
			unset($insert_sql_array['id']);
// WARUM HATTE ICH DAS MAL EINGEBAUT?!
//			$insert_sql_array['products_id'] = 0;
			$insert_sql_array['start_time'] = $res->getStartTime();
			$insert_sql_array['end_time'] = $res->getEndTime();
			$insert_sql_array['ebay_id'] = $res->getItemID();
			$insert_sql_array['auction_fees'] = $fee_val;
			$insert_sql_array['description'] = '';
			$insert_sql_array['relist_id'] = '1';
			$insert_sql_array['relist'] = '0';
			$insert_sql_array['status'] = '0';

			xtc_db_perform('ebay_auctions',$insert_sql_array);
			$insert_id = xtc_db_insert_id();

			if($use_variations){
				$variations_set = xtc_db_fetch_array($variations_set_query);
				$variations_query = xtc_db_query(sprintf(
					"SELECT quantity,sku,products_id,startprice FROM ebay_variations WHERE ebay_variations_sets_id='%s'",
					$variations_set['ebay_variations_sets_id']
				));
				while($record = xtc_db_fetch_array($variations_query)){
					$insert_sql_array = $record;
					$insert_sql_array['price'] = $record['startprice'];
					unset($insert_sql_array['startprice']);
					$insert_sql_array['ebay_auctions_id'] = $insert_id;
					xtc_db_perform('ebay_auctions_variations',$insert_sql_array);
				}
			}

			
			// orig auktion updaten -> markiert als "relisted"
			xtc_db_query("UPDATE ".TABLE_EBAY_AUCTIONS." SET relist_id='".$res->getItemID()."',status=2,relist='1' WHERE id='".$data['id']."'");
					
			$payments = $EBAYAPI->get_payments('ebay_auctions_payments','ebay_auctions_id',$data['id']);
			// payments kopieren
			if(is_array($payments) and sizeOf($payments)>0){
				foreach($payments as $k=>$v){
					xtc_db_query("INSERT INTO ebay_auctions_payments SET ebay_auctions_id='".$insert_id."',payment='".$v."'");
				}
			}

			/**
			 * 24.11.09
			 * DIE ebay_auctions_itemspecifics SIND NUR FUER TIMER NOTWENDIG

			$item_specifics = array();
			$EBAYAPI->get_itemspecifics('auction', $data['id'], $item_specifics);
			if(is_array($item_specifics) and sizeOf($item_specifics)>0){
				foreach($item_specifics as $k=>$v){
					$insert_sql_array = array(
						'is_name'=>$v['name'],
						'is_value'=>$v['value'],
						'ebay_auctions_id'=>$insert_id
					);
					xtc_db_perform('ebay_auctions_itemspecifics',$insert_sql_array);
				}
			}
			*/

			$item_shippingcosts = array();
			$EBAYAPI->get_shippingcosts_value('auction',$item_shippingcosts,$data['id']);
			if(sizeOf($item_shippingcosts)>0)
				$EBAYAPI->save_ebayshipping_values($item_shippingcosts,'auction',$insert_id);


			/**
			 * 24.11.09
			 * DIE ebay_auctions_characteristics SIND NUR FUER TIMER NOTWENDIG

			// characteristics kopieren
			$characteristics = $EBAYAPI->get_characteristics($source = 'ebay_auctions_characteristics',$index = 'ebay_auctions_id',$source_id = $data['id'] );
			$EBAYAPI->copy_characteristics($characteristics,$target = 'ebay_auctions_characteristics',$index = 'ebay_auctions_id',$target_id = $insert_id);
			 */
		}
		// itemspecifics + characteristics koennen nun geloescht werden
		xtc_db_query(sprintf("DELETE FROM ebay_auctions_itemspecifics WHERE ebay_auctions_id='%s'",$data['id']));
		xtc_db_query(sprintf("DELETE FROM ebay_auctions_characteristics WHERE ebay_auctions_id='%s'",$data['id']));
		
		if(sizeOf($variations_products)){
			for($vpi=0;$vpi<sizeOf($variations_products);$vpi++){
				$prod = $variations_products[$vpi];
				yes_update_products_in_auction_quantity($prod['products_id'], 
						$prod['quantity'], 
						$relist.sprintf(TEXT_SQ_TIMER_AUCTION_ADDED,$res->getItemID(),$prod['quantity'])
				);
			}
		}else{
			$einstellmenge = $data['quantity'];
			if($data['select_set_multiple']>0)
				$einstellmenge = $einstellmenge*$data['select_set_multiple'];
				yes_update_products_in_auction_quantity($data['products_id'],
						$einstellmenge, 
						$relist.sprintf(TEXT_SQ_TIMER_AUCTION_ADDED,$res->getItemID(),$einstellmenge)
				);
		}

	}else{
		xtc_db_query("UPDATE ebay_auctions SET not_valid='1' WHERE id=".$data['id']);
		if(defined('EBAY_ADDTIMER_ERROR_NOTICE') and EBAY_ADDTIMER_ERROR_NOTICE == 'True'){

			$string = sprintf(TEXT_MESSAGE_TIMINGERROR_NOTICE,date('d.m.Y H:i:s'),$data['ebay_products_id'],$data['title'],$data['products_id'])."\r\n\r\n";
			if( ($req->Item->Preisbindung_valid and $unique_check_ok) or $data['relist'] > 0){
				$string .= '<p>'.$cs->getErrorsToString($res).'</p>';
			}else{
				if(!$req->Item->Preisbindung_valid)
					$string .= sprintf('<p>'.TEXT_MESSAGE_PRICE_FIXING_ERROR.'</p>',number_format($req->Item->Preisbindung_value,2,',','.'));
				if(!$unique_check_ok)
					$string .= '<p>'.TEXT_MESSAGE_UNIQUE_ERROR.'</p>';
			}
			$string .= '<br /><br />'.TEXT_MESSAGE_TIMINGERROR_NOTICE2.'<br /><br />';
			$string .= "\r\n\r\n".HTTP_SERVER;
	
			$subject = TEXT_MESSAGE_NOTICE_TIMINGERROR_TITLE;
			$message = $string;
			yes_write_notice($subject,$message,$notice_sender,$notice_users);
		}
	}
   } // end if okay
}
xtc_db_query("UPDATE table_lock SET status='open' WHERE action_key='addtimer'");
