<?php
/* --------------------------------------------------------------------
/* LIZENZ DES SCRIPTS
 * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE
 * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE
 * ZWECKE, VERWENDET WERDEN.

 */
function _allocate_minute_to_quarter($minute){
	if($minute >= 45){
		return 45;
	}else if($minute >= 30){
		return 30;
	}else if($minute >= 15){
		return 15;
	}else{
		return '00';
	}
}
$page = 'ebayapi_automatic.php';
$hours_per_page = 6;
$from_hour = (isset($_GET['from_hour']) and is_numeric($_GET['from_hour'])) ? (int)$_GET['from_hour'] : 12;
$selected_day = (isset($_POST['day']) and is_numeric($_POST['day'])) ? (int)$_POST['day'] : 0;
if($from_hour < 0 || $from_hour > 18) $from_hour = 12;
$left_link = -1;
$right_link = -1;
if($from_hour > 0){
	$left_link = $from_hour-$hours_per_page;
}
if($from_hour < 18){
	$right_link = $from_hour+$hours_per_page;
}
$smarty = new smarty;
$smarty->cache_dir = DIR_FS_CATALOG.'cache/';
$smarty->compile_dir = DIR_FS_CATALOG.'templates_c/';
$smarty->template_dir = DIR_FS_ADMIN.'templates/';
$smarty->plugins_dir[] = DIR_FS_CATALOG.'includes/smarty_plugins';

if($left_link >= 0)
	$smarty->assign('left_link', xtc_href_link($page,xtc_get_all_get_params(array('from_hour')).'from_hour='.$left_link) );
if($right_link >= 0)
	$smarty->assign('right_link', xtc_href_link($page,xtc_get_all_get_params(array('from_hour')).'from_hour='.$right_link) );

// STUNDENANZEIGE
$hour_array = array();
for($h=$from_hour;$h<$from_hour+$hours_per_page;$h++){
	$border_style = '';
	if($h < ($from_hour+$hours_per_page-1))
		$border_style = "border-bottom:1px solid #888888;border-left:1px solid #888888;";
	else
		$border_style = "border-bottom:1px solid #888888;border-left:1px solid #888888;border-right:1px solid	 #888888;";
	$hour_array[] = array(
		'border_style' => $border_style,
		'value' => $h
	);
}
$smarty->assign('hours',$hour_array);

$saved_automatics = array();
// MINUTENANZEIGE
$minutes_array = array();
for($h=$from_hour;$h<$from_hour+$hours_per_page;$h++){
	$border_style = "border-left:1px solid #888888;";
	for($m=0;$m<60;$m+=15){
		$mstr = (strlen($m) == 1) ? '0'.$m : $m;
		if($m % 4 != 0){
			if($h == $from_hour+$hours_per_page - 1 && $m % 4 == 1)
				$border_style = "border-left:1px dashed #888888; border-right:1px solid #888888;";
			else
				$border_style = "border-left:1px dashed #888888;";
		}
		$minutes_array[] = array(
			'border_style'=>$border_style,
			'value' => $mstr,
			'hour' => $h,
		);
		for($d=0;$d<7;$d++){
			$saved_automatics[$d][$h][$mstr] = array('value'=>0);
		}
	}
}
$query_raw = sprintf("SELECT daily_key,CONCAT(time_hour,':',time_minute) as zeit,count(*) as anz FROM ebay_automatics_daily WHERE time_hour >= '%s' AND time_hour <= '%s' GROUP BY zeit",$from_hour,$from_hour+$hours_per_page);
$query = xtc_db_query($query_raw);
while($row = xtc_db_fetch_array($query)){
	$zeit = split(':',$row['zeit']);
	$saved_automatics[ (int)$row['daily_key'] ][ $zeit[0] ][_allocate_minute_to_quarter($zeit[1])]['value'] += $row['anz'];
}
$smarty->assign('automatics',$saved_automatics);

$smarty->assign('minutes',$minutes_array);
$days_array = array(
	0=>array('id'=>0,'text'=>'Mo'),
	1=>array('id'=>1,'text'=>'Di'),
	2=>array('id'=>2,'text'=>'Mi'),
	3=>array('id'=>3,'text'=>'Do'),
	4=>array('id'=>4,'text'=>'Fr'),
	5=>array('id'=>5,'text'=>'Sa'),
	6=>array('id'=>6,'text'=>'So')
);
$smarty->assign('day_array',$days_array);
$smarty->assign(array(
    'HEADING_TITLE'=>HEADING_TITLE_OVERVIEW,
    'PAGE_HEADING_MENU_BUTTONS'=>array(
	array('text'=>IMAGE_BACK,
	    'link'=>xtc_href_link('ebayapi_automatic.php',xtc_get_all_get_params(array('action'))),
	    'lbOn'=>false,
	    'auth'=>true
	)
    )
));
$html = $smarty->fetch(DIR_FS_ADMIN.'templates/ebayapi_automatic_overview.html');
echo $html;
?>
</body>
</html>
<?php include('includes/application_bottom.php');
exit;
