<?php
include('includes/application_top.php');
include('includes/classes/class.textitems.php');
require(DIR_FS_INC.'xtc_get_product_path.inc.php');
require(DIR_FS_INC.'xtc_get_parent_categories.inc.php');
$MAX_READ_MSG = 200; // max. inputvalues

ini_set('memory_limit','1200M');
set_time_limit(0);

include('includes/classes/class.ebay.php');
$EBAYAPI = new ebayApi();

require(DIR_FS_INC.'xtc_get_ebay_link.inc.php');
require(DIR_FS_INC.'xtc_get_auction_site.inc.php');

$smarty = new yesSmarty;
$action = $_REQUEST['action']??'summary';   
$ebay_user = $_GET['ebay_user']??constant('EBAY_USER');

if(ebayApi::oauth2_refreshtoken_exists($ebay_user)){
        if(!ebayApi::oauth2_usertoken_exists($ebay_user) or ebayApi::get_oauth2_usertoken_lifetime($ebay_user) < 1){
            try{
                ebayApi::refresh_oauth2_usertoken($ebay_user);
            }catch(Exception $e){
                $api_error = 'refresh_oauth2_usertoken() for seller '.$ebay_user.'  '.$e->getMessage();
            }
        }
}

$request = array();
$error_reporting = yes_getErrorReporting();
switch($action){
	case 'send':
		error_reporting(0);
		$offers = array();
		if(is_countable($_POST['bID'])){
			foreach($_POST['bID'] as $ebay_id => $bIDarray){
				foreach($bIDarray as $k=>$bID){
					$counterprice = (float)$_POST['counterprice'][$ebay_id][$bID];
					$quantity = (int)$_POST['quantity'][$ebay_id][$bID];
					$offers[] = array('counterprice'=>$counterprice,
						'quantity'=>$quantity,
						'bID'=>$bID,
						'ebay_id'=>$ebay_id
					);
				}
			}
		}else{
			$offers[] = array('counterprice'=>$_POST['counterprice'],
				'quantity'=>$_GET['qty'],
				'bID'=>$_GET['bID'],
				'ebay_id'=>$_GET['ebay_id']
			);
		}
		foreach($offers as $k=>$offer){
			$error = false;
			if( $offer['counterprice'] < 0.01 and $_POST['answer'] == 'counter'){
				$messageStack->add_session('Es wurde kein g&uuml;ltiges Gegenangebot &uuml;bergeben: ebayID: '.$offer['ebay_id'].'.','error');
				continue;
			}
			$req = new \stdClass();
			$req->ItemID = (string)$offer['ebay_id'];
			$req->BestOfferID = [$offer['bID']];
			switch($_POST['answer']){
				case 'counter':
					$req->Action = 'Counter';
					$req->CounterOfferQuantity = (int)$offer['quantity'];
					$req->CounterOfferPrice = (float)$offer['counterprice'];
					break;
				case 'accept':
					$req->Action = 'Accept';
					break;
				case 'decline':
					$req->Action = 'Decline';
					break;
			}
			$ebaycalls = new \YES4Trade\Model\ebaycalls();
			$res = $ebaycalls->tradingQuery($ebay_user, 
				'RespondToBestOffer',
				$EBAYAPI->get_site_id_from_name(EBAY_SITE),
				(array)$req
			);
			if($EBAYAPI->isGood($res)){
				$messageStack->add_session( 'Die Antwort wurde gesendet.', 'success' );
			}else{
				$messageStack->add_session( 'Die Antwort wurde nicht gesendet: '.implode('<br />',$EBAYAPI->getResponseErrors($res)), 'error' );
			}
			xtc_redirect(xtc_href_link('ebayapi_bestoffers.php',xtc_get_all_get_params(array('action','bID','ebay_id'))));
		}
		xtc_redirect(xtc_href_link('ebayapi_bestoffers.php',xtc_get_all_get_params(array('action')).'action=view_item'));
		break;
	case 'view_item':
		$active_item = \YES4Trade\Model\ebay_auctions::get_by_ebay_id_and_user($_GET['ebay_id'],$ebay_user,[
			'site','ebay_id','title','products_id','auctionprice'
		]);
		$actives = array();
		$active = $active_item->toArray();
		$ebaycaller = new \YES4Trade\Model\ebaycalls();
		$res = $ebaycaller->tradingQuery($ebay_user, 
			'GetBestOffers',
			$EBAYAPI->get_site_id_from_name(constant('EBAY_SITE')),
			[
				'ItemID'=>$active['ebay_id']
			]
		);

        $bo_array = $res->BestOfferArray->BestOffer ?? [];
        if(!is_array($bo_array)){
            $bo_array = [$bo_array];
        }

		$active_data = array();
		if(is_countable($bo_array) and sizeOf($bo_array)>0){
			$active_data['ebay_id'] = $active['ebay_id'];
			foreach($bo_array as $k=>$bestoffer){
				$buyer = $bestoffer->Buyer;
				$price = $bestoffer->Price;
				if($_GET['bID'] == $bestoffer->BestOfferID){
					$expdate_obj = new \DateTime($bestoffer->ExpirationTime);
					$data_array = array(
						'ebay_title'=>xtc_db_prepare_input($active['title']),
						'site'=>$active['site'],
						'products_id'=>$active['products_id'],
						'auctionprice'=>$active['auctionprice'],
						'bestofferid'=>$bestoffer->BestOfferID,
						'expirationtime'=>$expdate_obj->format('Y-m-d H:i:s'),
						'buyer'=>$buyer->UserID,
						'currency'=>DEFAULT_CURRENCY,
						'price'=>$price,
						'status'=>$bestoffer->Status,
						'quantity'=>$bestoffer->Quantity,
						'bestoffercodetype'=>$bestoffer->BestOfferCodeType
					);
				}
				$active_data['offer'] = $data_array;
			}
			$actives[] = $active_data;
		}
		break;
	case 'summary':  // default
		$active_query_raw = sprintf("select site,ebay_id,title,products_id,auctionprice from ebay_auctions where bestoffer='1' and status=0 and user='%s'", // split page results
			$ebay_user
		);
		$active_split = new splitPageResults( $_GET['page'], MAX_DISPLAY_SEARCH_RESULTS, $active_query_raw, $active_query_numrows);
		$active_query = xtc_db_query($active_query_raw);
		
		$actives = array();
		$recs = [];
		while($active = xtc_db_fetch_array($active_query)){
			$recs[] = $active;
		}
		foreach($recs as $active){
			$ebaycaller = new \YES4Trade\Model\ebaycalls();
			$res = $ebaycaller->tradingQuery($ebay_user, 
				'GetBestOffers',
				$EBAYAPI->get_site_id_from_name(constant('EBAY_SITE')),
				[
					'ItemID'=>$active['ebay_id']
				]
			);
			$bo_array = $res->BestOfferArray->BestOffer ?? [];
			if(!is_array($bo_array)){
				$bo_array = [$bo_array];
			}
			
			$active_data = array();
			if(sizeOf($bo_array)>0){
				$active_data['ebay_id'] = $active['ebay_id'];
				foreach($bo_array as $k=>$bestoffer){
					$buyer = $bestoffer->Buyer;
					$price = $bestoffer->Price;
					$expdate_obj = new \DateTime($bestoffer->ExpirationTime);
					$data_array = array(
						'ebay_title'=>xtc_db_prepare_input($active['title']),
						'site'=>$active['site'],
						'products_id'=>$active['products_id'],
						'auctionprice'=>$active['auctionprice'],
						'bestofferid'=>$bestoffer->BestOfferID,
						'expirationtime'=>$expdate_obj->format('Y-m-d H:i:s'),
						'buyer'=>$buyer->UserID,
						'currency'=>DEFAULT_CURRENCY,
						'price'=>$price->value,
						'status'=>$bestoffer->Status,
						'quantity'=>$bestoffer->Quantity,
						'bestoffercodetype'=>$bestoffer->BestOfferCodeType
					);
					$active_data['offer'] = $data_array;
				}
				$actives[] = $active_data;
			}
		}
		break;
}
yes_draw_pre_header();
yes_draw_header(TITLE);
$buttons = array();
$smarty->assign(array(
    'HEADING_TITLE'=>HEADING_TITLE,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons
));
$smarty->display('ebayapi_bestoffers.html');
?>
<table border="0" width="100%" cellspacing="2" cellpadding="2">
<tr>
	<td>
		<table border="0" cellpadding="0" cellspacing="0">
		<?php echo xtc_draw_form('ebayuserselect','ebayapi_bestoffers.php','','get'); ?>
		<tr>
			<td class="main">Ebay User</td>
			<td class="main"><?php echo xtc_draw_pull_down_menu('ebay_user',xtc_get_ebay_users(),$ebay_user); ?></td>
			<td class="main"><input border="0" type="image" src="images/icon_save.gif" alt="Ebay User" title="Ebay User"></td>
		</tr>
		</form>
		</table>
	</td>
</tr>
<tr>
	<td class="main" width="100%" valign="top">
<?php
	switch($action){
		case 'view_item':
			$active = $actives[0];
			$automatic_offer_price = '0';
			$products_id_link = "<a href='#' onClick='window.open(\"".xtc_href_link('categories.php','action=new_product&pID='.$active['offer']['products_id'].'&cPath='.xtc_get_product_path($active['offer']['products_id']))."\",\"popup\",\"width=".EXT_POPUP_WIDTH.",height=".EXT_POPUP_WIDTH.",resizable=yes,scrollbars=yes\");'><u>".$active['offer']['products_id']."</u></a>";
			$automatic = $EBAYAPI->get_bestoffer_accept_check($active['ebay_id'],$active['offer']['quantity'],$active['offer']['price']);
			if(!$automatic)
				$automatic_offer_price = $EBAYAPI->get_bestoffer_proposal($active['ebay_id'],$active['offer']['quantity']);
					
			$matrix_array = $EBAYAPI->get_bestoffer_matrix($active['ebay_id']);
			$matrix_string = '';
			if(sizeOf($matrix_array)>0){
				$matrix_string .= 'Matrix der Mindestpreise'."\\r\\n";
				foreach($matrix_array as $k=>$matrix){
					$matrix_string .= 'ab '.$matrix['quantity'].' Stk: '.number_format($matrix['minimumprice'],2,',','')."\\r\\n";
				}
			}
?>
			<p><a href="<?php echo xtc_href_link('ebayapi_bestoffers.php',xtc_get_all_get_params(array('ebay_id','bID','action','qty'))); ?>"><u>Zur&uuml;ck zur &Uuml;bersicht</u></a></p>
			<table border="0">
			<tr class="dataTableHeadingRow">
				<td class="dataTableHeadingContent"><?php echo $active['offer']['ebay_title']; ?></td>
			</tr>
			
			<?php 
			echo xtc_draw_form('best','ebayapi_bestoffers.php',xtc_get_all_get_params(array('action','bID','ebay_id','qty')).'action=send&bID='.$active['offer']['bestofferid'].'&ebay_id='.$active['ebay_id'].'&qty='.$active['offer']['quantity']); ?>
			
			<tr>
				<td class="main">
				<table border="0" cellspacing="1" cellpadding="2">
				<tr>
					<td class="main"><b>EbayID</b></td>
					<td class="main"><b>pID</b></td>
					<td class="main"><b>Verf&auml;llt</b></td>
					<td class="main"><b>User</b></td>
					<td class="main"><b>Anzahl</b></td>
					<td class="main"><b>Auktionspreis</b></td>
					<td class="main"><b>Vorschlag</b></td>
					<td class="main"><b>Status</b></td>
					<td class="main"><b>Check</b></td>
					<td class="main">&nbsp;</td>
					<td class="main">&nbsp;</td>
				</tr>
				<tr class="dataTableRow">
					<td class="main"><a target="_blank" href="<?php echo xtc_get_ebay_link(xtc_get_auction_site($active['ebay_id'])).$active['ebay_id']; ?>"><u><?php echo $active['ebay_id']; ?></u></a></td>
					<td class="main"><?php echo $products_id_link; ?></td>
					<td class="main"><?php echo yes_strftime('%d.%m.%y %H:%I',strtotime($active['offer']['expirationtime'])); ?></td>
					<td class="main"><?php echo $active['offer']['buyer']; ?></td>
					<td class="main"><?php echo $active['offer']['quantity']; ?> Stk.</td>
					<td class="main" align="right"><?php echo number_format($active['offer']['auctionprice'],2,',','.'); ?> <?php echo $EBAYAPI->get_site_currency($EBAYAPI->get_site_id_from_name($active['offer']['site'])); ?></td>
					<td class="main" align="right"><?php echo number_format($active['offer']['price'],2,',','.'); ?> <?php echo $EBAYAPI->get_site_currency($EBAYAPI->get_site_id_from_name($active['offer']['site'])); ?></td>
					<td class="main"><?php echo $active['offer']['status']; ?></td>
					<td class="main"><?php if(strlen($matrix_string)>0) { ?><a href="javascript:alert('<?php echo $matrix_string; ?>');"><?php } ?><u><?php echo ($automatic) ? 'Mindestpreis OK' : 'Unter Mindestpreis'; ?></u></a></td>
					<td class="main">
					<?php
					echo xtc_draw_pull_down_menu('answer',array(
						0=>array('id'=>'accept','text'=>'Annehmen'),
						1=>array('id'=>'counter','text'=>'Gegenvorschlag'),
						2=>array('id'=>'decline','text'=>'Preisvorschlag ablehnen')
					));
					?>
					&nbsp;
					*Gegenangebot: <?php echo xtc_draw_input_field('counterprice',number_format($automatic_offer_price,2,'.',''),'size="4"'); ?>
					</td>
					<td class="main"><input type="submit" value="Senden"></td>
				</tr>
				</form>
				</table>
				</td>
			</tr>
			<tr>
				<td><?php echo xtc_draw_separator('pixel_black.gif'); ?></td>
			</tr>
			</table>
<?php
			break;
		case 'summary':
?>

<script type="text/javascript">
<!--
function selectall_array(formname,elementname,mymodus) {
	el = document.forms[""+formname].length;
	for(i = 0; i<el; i++) {
		myel = document.forms[""+formname].elements[i];
		myname = document.forms[""+formname].elements[i].name;
		my_split_name = myname.split('[');
		myname = my_split_name[0];
		if(myname == elementname){
			document.forms[formname].elements[i].checked = mymodus;
		}
	}
}
//-->			
</script>
			<table border="0">
<?php
			echo xtc_draw_form('best','ebayapi_bestoffers.php',xtc_get_all_get_params(array('action')).'action=send');
			foreach($actives as $k=>$active){
				$products_id_link = "<a href='#' onClick='window.open(\"".xtc_href_link('categories.php','action=new_product&pID='.$active['offer']['products_id'].'&cPath='.xtc_get_product_path($active['offer']['products_id']))."\",\"popup\",\"width=".EXT_POPUP_WIDTH.",height=".EXT_POPUP_WIDTH.",resizable=yes,scrollbars=yes\");'><u>".$active['offer']['products_id']."</u></a>";
				$automatic = $EBAYAPI->get_bestoffer_accept_check($active['ebay_id'],$active['offer']['quantity'],$active['offer']['price']);
				if(!$automatic)
					$automatic_offer_price = $EBAYAPI->get_bestoffer_proposal($active['ebay_id'],$active['offer']['quantity']);
					
				$matrix_array = $EBAYAPI->get_bestoffer_matrix($active['ebay_id']);
				$matrix_string = '';
				if(sizeOf($matrix_array)>0){
					$matrix_string .= 'Matrix der Mindestpreise'."\\r\\n";
					foreach($matrix_array as $k=>$matrix){
						$matrix_string .= 'ab '.$matrix['quantity'].' Stk: '.number_format($matrix['minimumprice'],2,',','')."\\r\\n";
					}
				}
?>
			<tr class="dataTableHeadingRow">
				<td class="dataTableHeadingContent"><?php echo $active['offer']['ebay_title']; ?></td>
			</tr>
			
			<tr>
				<td class="main">
				<table border="0" cellspacing="1" cellpadding="2">
				<tr>
					<td class="main"><b>&nbsp;</b></td>
					<td class="main"><b>EbayID</b></td>
					<td class="main"><b>pID</b></td>
					<td class="main"><b>Verf&auml;llt</b></td>
					<td class="main"><b>User</b></td>
					<td class="main"><b>Anzahl</b></td>
					<td class="main"><b>Auktionspreis</b></td>
					<td class="main"><b>Vorschlag</b></td>
					<td class="main"><b>Status</b></td>
					<td class="main"><b>Check</b></td>
					<td class="main"><b>Gegenvorschlag</b></td>
					<td class="main">&nbsp;</td>
				</tr>
				<?php if($active['offer']['bestoffercodetype'] == 'SellerCounterOffer'){?>
				<tr class="dataTableRowOver">
				<?php }else{ ?>
				<tr class="dataTableRow">
				<?php } ?>
					<td class="main"><?php echo xtc_draw_checkbox_field('bID['.$active['ebay_id'].'][]',$active['offer']['bestofferid'],$automatic); ?></td>
					<td class="main"><a target="_blank" href="<?php echo xtc_get_ebay_link(xtc_get_auction_site($active['ebay_id'])).$active['ebay_id']; ?>"><u><?php echo $active['ebay_id']; ?></u></a></td>
					<td class="main"><?php echo $products_id_link; ?></td>
					<td class="main"><?php echo yes_strftime('%d.%m.%y %H:%I',strtotime($active['offer']['expirationtime'])); ?></td>
					<td class="main"><?php echo $active['offer']['buyer']; ?></td>
					<td class="main"><?php echo $active['offer']['quantity']; ?> Stk.</td>
					<td class="main" align="right"><?php echo number_format($active['offer']['auctionprice'],2,',','.'); ?> <?php echo $EBAYAPI->get_site_currency($EBAYAPI->get_site_id_from_name($active['offer']['site'])); ?></td>
					<td class="main" align="right"><?php echo number_format($active['offer']['price'],2,',','.'); ?> <?php echo $EBAYAPI->get_site_currency($EBAYAPI->get_site_id_from_name($active['offer']['site'])); ?></td>
					<td class="main"><?php echo $active['offer']['status']; ?></td>
					<td class="main"><?php if(strlen($matrix_string)>0) { ?><a href="javascript:alert('<?php echo $matrix_string; ?>');"><?php } ?><u><?php echo ($automatic) ? 'Mindestpreis OK' : 'Unter Mindestpreis'; ?></u></a></td>
					<td class="main">
					<?php if($active['offer']['bestoffercodetype'] == 'SellerCounterOffer'){?>
					&nbsp;
					<?php }else{ ?>
						<input type="text" name='counterprice[<?php echo $active['ebay_id']; ?>][<?php echo $active['offer']['bestofferid']; ?>]' size="6" value="<?php echo number_format($automatic_offer_price,2,'.','.'); ?>">
						<input type="hidden" name='quantity[<?php echo $active['ebay_id']; ?>][<?php echo $active['offer']['bestofferid']; ?>]' value="<?php echo $active['offer']['quantity']; ?>">
					<?php
					}
					?>
					</td>
					<td class="main">
					<?php if($active['offer']['bestoffercodetype'] == 'SellerCounterOffer'){?>
					Angebot unterbreitet
					<?php }else{ ?>
					<a href="<?php echo xtc_href_link('ebayapi_bestoffers.php',xtc_get_all_get_params(array('action','bID','ebay_id')).'action=view_item&bID='.$active['offer']['bestofferid'].'&ebay_id='.$active['ebay_id'].'&qty='.$active['offer']['quantity']); ?>"><u>Preisanfrage beantworten</u></a>
					<?php
					}
					?>
					</td>
				</tr>
				</table>
				</td>
			</tr>
			<tr>
				<td><?php echo xtc_draw_separator('pixel_black.gif'); ?></td>
			</tr>
<?php
			} // end foreach folders
?>
			<tr>
				<td class="main">
				<a href="javascript:selectall_array('best','bID',true);">Alle Produkte markieren</a><br><a href="javascript:selectall_array('best','bID');">Alle Produkte demarkieren</a>
				</td>
			</tr>
			<tr>
				<td class="main" align="right">
				Ausgew&auml;hlte Preisvorschl&auml;ge&nbsp;
<?php
			echo xtc_draw_pull_down_menu('answer',array(
					0=>array('id'=>'','text'=>'--- Bitte wählen ---'),
					1=>array('id'=>'accept','text'=>'Vorschläge annehmen'),
					2=>array('id'=>'decline','text'=>'Vorschläge ablehnen'),
					3=>array('id'=>'counter','text'=>'Gegenvorschläge')
				)
			
			);
?>
				<input type="submit" value="Senden">
				</td>
			</tr>
			</form>
<?php
			if(sizeOf($actives)==0){
?>

			<tr>
				<td class="main">Derzeit keine Angebote</td>
			</tr>
<?php			
			}
?>
			</table>
<?php			
			break;
	}
?>
	</td>
</tr>
</table>
<?php
require(DIR_WS_INCLUDES . 'application_bottom.php'); 
require(DIR_WS_INCLUDES . 'footer.php'); 
