<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                             Author M. ASPELEITER <dazze@gmx.de>
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/

include( 'includes/application_top.php');
require_once(DIR_FS_ADMIN.DIR_WS_CLASSES.'class.ebay.php');
require(DIR_FS_INC.'xtc_get_site_country_id.inc.php');
require(DIR_FS_INC.'xtc_is_language_installed.inc.php');
require_once(DIR_FS_INC.'yes_get_iso2_from_ebay_countryname.inc.php');
$EBAYAPI = new EbayApi();
$preview_smarty = new yesSmarty;
$preview_smarty->assign('tpl_path','templates/'.CURRENT_TEMPLATE.'/');
$preview_smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');

function msort($original,$field, $descending = false){
            $sortArr = array();

            foreach ( $original as $key => $value )
            {
                $sortArr[ $key ] = $value[ $field ];
            }

            if ( $descending )
            {
                arsort( $sortArr );
            }
            else
            {
                asort( $sortArr );
            }

            $resultArr = array();
            foreach ( $sortArr as $key => $value )
            {
                $resultArr[ $key ] = $original[ $key ];
            }

            return $resultArr;
}


function _get_value_array($value,$key){
	global $values_sort_order;
	if($values_sort_order[$key]){
		$sort = $values_sort_order[$key];
	}else{
		$sort = sizeOf($values_sort_order);
		$values_sort_order[$key] = $sort;
	}
	return array('val'=>$value,'key'=>$key,'sort'=>$sort);
}

$values_sort_order = array(
	'id' => 1,
	'products_id' => 3,
	'sammler_id' => 4,
	'user' => 5,
	'site' => 6,
	'country' => 7,
	'location' => 8,
	'postalcode' => 9,
	'type' => 10,
	'auctionprice' => 11,
	'buyitnowprice' => 12,
	'duration' => 13,
	'quantity' => 14,
	'template' => 15,
	'category' => 16,
	'category2' => 17,
	'shopcat_name' => 18,
	'shopcat2_name' => 19,
	'counter' => 40,
	'vat' => 50,
	'geldzurueck' => 60,
	'sofortneu' => 70,
	'bestoffer' => 80,
	'bestoffer_price' => 90,
	'BestOfferAutoAcceptPrice' => 100,
	'gallery' => 110,
	'galleryfeatured' => 120,
	'galleryfeaturedduration' => 130,
	'paymentinstructions' => 200,
	'revise' => 240,
	'payments' => 260,
	'shippings' => 265,
	'externalproductid' => 270,
	'itemspecifics' => 280,
	'select_set' => 290
);


if(!isset($_GET['preview']) or $_GET['preview'] != '1' ){
	$id = ($_GET["id"]) ? $_GET["id"] : 0;
	$ebay_product = new ebay_product($id);
	$ebay_product_array = (array)$ebay_product;
	unset($ebay_product_array['sql_array']);
	unset($ebay_product_array['uuid']);
	unset($ebay_product_array['characteristics']);
	unset($ebay_product_array['new']);
	unset($ebay_product_array['picture']);
	unset($ebay_product_array['description']);
	unset($ebay_product_array['title']);
	unset($ebay_product_array['subtitletext']);
	unset($ebay_product_array['externalproductidtype']);
	unset($ebay_product_array['status']);
	unset($ebay_product_array['select_set_multiple']);
	unset($ebay_product_array['shopcat']);
	unset($ebay_product_array['shopcat2']);
	unset($ebay_product_array['category_name']);
	unset($ebay_product_array['category2_name']);
	unset($ebay_product_array['subtitletext']);
	unset($ebay_product_array['revise_option']);
	$values = array();
	foreach($ebay_product_array as $key => $value){
		switch($key){
			case 'category':
			case 'category2':
				$site_id = $EBAYAPI->get_site_id_from_name($ebay_product_array['site']);
				$value = $EBAYAPI->get_ebay_category_name_from_favorites($value, $site_id);
				break;
			case 'sammler_id':
				$value = $EBAYAPI->getSammlerTitel($value).' (ID: '.$value.')';
				break;
			case 'type':
				$value = $_YES_auction_types[$value];
				break;
			case 'buyitnowprice':
			case 'auctionprice':
			case 'BestOfferAutoAcceptPrice':
			case 'bestoffer_price':
				$value = number_format($value,2,',','.');
				break;
			case 'vat':
			case 'sofortneu':
			case 'gallery':
			case 'galleryfeatured':
			case 'geldzurueck':
			case 'bestoffer':
				$value = ($value) ? YES : NO;
				break;
			case 'revise':
				$value = ($value) ? sprintf(TEXT_REVISE_OPTION,$ebay_product->revise_option) : NO;
				break;
			case 'itemspecifics':
				$spec_values = array();
				$EBAYAPI->get_itemspecifics('ebay_product',$ebay_product->id,$spec_values);
				$strings = array();
				for($i=0;$i<sizeOf($spec_values);$i++){
					$strings[] = implode(',',$spec_values[$i]);
				}
				$value = (sizeOf($strings) > 0) ? implode(';',$strings) : NO;
				break;
			case 'shippings':
				$value = '';
				$shipping_values = array();
				$shippings_array = array();
				$EBAYAPI->get_shippingcosts_value('ebay_products',$shipping_values,$ebay_product->id);
                                if(is_countable($shipping_values['national'])){
                                    for($i=0;$i<sizeOf($shipping_values['national']);$i++){
                                            $shippings_array[] = sprintf('%s: %s (+%s)',
                                                    $shipping_values['national'][$i]['shipService'],
                                                    number_format($shipping_values['national'][$i]['shipFee'],2,',','.'),
                                                    number_format($shipping_values['national'][$i]['shipAdditionalFee'],2,',','.')
                                            );
                                    }
                                }
				if(sizeOf($shippings_array)>0){
					$value = 'National:<br />'.implode(';<br />',$shippings_array);
				}
				$shippings_array = array();
                                $int_num = (is_countable($shipping_values['international'])) ? sizeOf($shipping_values['international']) : 0;
				for($i=0;$i<$int_num;$i++){
					if(isset($shipping_values['international'][$i]['shipIntlWorldwide']) and $shipping_values['international'][$i]['shipIntlWorldwide'] == 1){
						$region = 'Worldwide';
					}else{
						$region = implode(',',$shipping_values['international'][$i]['shipIntlRegion']);
					}
					$shippings_array[] = sprintf('%s: %s (+%s) %s',
						$shipping_values['international'][$i]['shipServiceIntl'],
						number_format($shipping_values['international'][$i]['shipFeeIntl'],2,',','.'),
						number_format($shipping_values['international'][$i]['shipAdditionalFeeIntl'],2,',','.'),
						$region
					);
				}
				if(sizeOf($shippings_array)>0){
					$value .= '<br />International:<br />'.implode(';<br />',$shippings_array);
				}
				break;
			case 'payments':
				$payments = $EBAYAPI->get_payments('ebay_products_payments','ebay_products_id',$ebay_product->id);
				if(sizeOf($payments)>0){
					$value = implode(',',$payments);
				}
				break;
			case 'select_set':
				$value = ($value) ? YES.(($ebay_product->select_set_multiple > 0)?', '.$ebay_product->select_set_multiple.' '.TEXT_QUANTITY_SHORT:'') : NO;
				break;
		}
		$values[] = _get_value_array($value,$key);
	}
	$values = msort($values,'sort');
	$preview_smarty->assign('values',$values);
	$data = $EBAYAPI->getProductDetails($id);
	$data = xtc_db_prepare_input($data);
	$wrap1 = "";
	include("ebayapi_wrap.php");
	$preview_smarty->assign('DESCRIPTION',$wrap1);
}else{
	$product_query = xtc_db_query("SELECT p.products_image,pd.products_description,pd.products_extra_text,pd.products_short_description, p.ebay_template,pd.ebay_title FROM products p left join products_description pd on p.products_id=pd.products_id WHERE p.products_id='".xtc_db_input($_GET['id'])."' and pd.language_id='".$_SESSION['languages_id']."'");
	$product = xtc_db_fetch_array($product_query);
	$product = xtc_db_prepare_input($product);

	$data['ebay_template'] = $product['ebay_template'];
	$data['ebay_title'] = (xtc_not_null($product['ebay_title'])) ? $product['ebay_title'] : xtc_get_products_name($_GET['id']);
	$data['ebay_bild'] = $product['products_image'];
	$data['products_id'] = $_GET['id'];

	if(EBAY_DESCRIPTION_SOURCE == '1'){ // extratext
		$data["ebay_beschreibung"] = $product['products_extra_text'];
		$data["ebay_extratext"] = '';
	}else{
		$data["ebay_beschreibung"] = $product['products_description'];
		$data["ebay_extratext"] = $product['products_extra_text'];
	}
	$data["ebay_kurzbeschreibung"] = $product['products_short_description'];

	$smarty = new yesSmarty;
	$smarty->assign('tpl_path','templates/'.CURRENT_TEMPLATE.'/');
	$smarty->assign('TITLE',$data["ebay_title"]);

	$PICPATH = (EXTERN_EBAYPICTURE_SERVER == 1) ? EXTERN_EBAYPICTURE_SERVER_PICURL : EBAY_PICPATH_WEBSERVER;

	$pic_query = xtc_db_query("SELECT products_image FROM products WHERE products_id='".$data['products_id']."'");
	$firstpic = xtc_db_fetch_array($pic_query);
	$smarty->assign('BILD1',$PICPATH.$firstpic['products_image']);
	$smarty->assign('EBAYBILD',$PICPATH.$data["ebay_bild"]);

	$pic_count = 2;
	$pic_double = array();

	$pic_query = xtc_db_query("SELECT image_name FROM products_images WHERE products_id='".$data['products_id']."' order by image_nr");
	while($pics = xtc_db_fetch_array($pic_query)){
		if(!in_array($pics["image_name"],$pic_double) ){
			$smarty->assign('BILD'.$pic_count,$PICPATH.$pics["image_name"]);
			$pic_double[] = $pics["image_name"];
			$pic_count++;
		}
	}
	$smarty->assign('BESCHREIBUNG',xtc_db_prepare_input($data["ebay_beschreibung"]));
	$smarty->assign('EXTRATEXT',$data["ebay_extratext"]);
	$smarty->assign('KURZBESCHREIBUNG',$data["ebay_kurzbeschreibung"]);

	$smarty->assign('HERSTELLER',$ebay_hersteller);
	$EBAYAPI = new ebayApi();
	if($data['ebay_beschreibung_system'] == 'y'){
		$wrap1 = $data['ebay_beschreibung'];
	}else{
		$wrap1 = $smarty->fetch(CURRENT_TEMPLATE . '/admin/ebay_templates/'.$data['ebay_template']);
	}

	require('includes/yes_footer.php');
	$wrap1 .= $YESFOOTER;
	$preview_smarty->assign('DESCRIPTION',$wrap1);
}
?>
<!DOCTYPE html>
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>" />
<title><?php 
	if(!$_GET['preview']){
		echo sprintf(HEADING_TITLE,$ebay_product->title);
	}else{
		echo sprintf(HEADING_TITLE,$data["ebay_title"]);
	}
?></title>
<link rel="stylesheet" type="text/css" href="includes/stylesheet.css.php" />
</head>
<body>
<table border="0" width="100%">
<tr>
	<td class="pageHeading">
	<?php
	if(!$_GET['preview']){
		echo sprintf(HEADING_TITLE,$ebay_product->title);
	}else{
		echo sprintf(HEADING_TITLE,$data["ebay_title"]);
	}
	if($ebay_product->subtitletext != ''){
		echo '<br /><i>'.$ebay_product->subtitletext.'</i>';
	}
	?>
	</td>
</tr>
</table>

<?php
$preview_smarty->display(DIR_FS_ADMIN.'templates/ebayapi_preview.html');
?>
</body>
</html>