<?php
// ITEMS = REAL KATALOG
// PRODUCTS = ZUGEWIESENE ITEMS ZU EINEM SELLER (MIT PREIS ETC)
// item = IM KATALOG VON REAL
// unit = EINEM SELLER ZUGEWIESEN
if(!defined('MODULE_OTHER_YES_HITMEISTER_API_STATUS') or MODULE_OTHER_YES_HITMEISTER_API_STATUS != 'True'){
    die("Kaufland module not active");
}
require_once(DIR_WS_CLASSES.'yes_shipping.php');
define('HITMEISTER_ATTRIBUTES_TEXTAREA_ROWS',3);
define('HITMEISTER_ATTRIBUTES_TEXTAREA_COLS',40);
define('HITMEISTER_ATTRIBUTES_SHORTTEXT_MAXLENGTH',512);
define('HITMEISTER_ATTRIBUTES_SMALLTEXT_MAXLENGTH',1024);
define('HITMEISTER_ATTRIBUTES_PICTURE_INPUT_SIZE', 60);
define('HITMEISTER_ATTRIBUTES_TINYTEXT_SIZE',40);
define('HITMEISTER_ATTRIBUTES_TINYTEXT_MAXLENGTH',255);
define('HITMEISTER_ATTRIBUTES_SI_SIZE',16);
define('HITMEISTER_ATTRIBUTES_SI_MAXLENGTH',16);
// DEFAULT
define('HITMEISTER_ATTRIBUTES_TEXT_INPUT_SIZE',16);
define('HITMEISTER_ATTRIBUTES_TEXT_INPUT_MAXLENGTH',16);

$valid_versender = yes_hitmeister::hitmeister_carrier();
if (isset($_GET['action2']) and $_GET['action2'] == 'fulfillment_cleanup') {
    $orders_id_array = array();
    $query = xtc_db_query(sprintf(
        "SELECT s.orders_id FROM shippings s LEFT JOIN %s o USING ( orders_id ) LEFT JOIN hitmeister_orders ho USING(orders_id) LEFT JOIN hitmeister_orders_units hou USING(hitmeister_orders_id) WHERE o.source LIKE 'hitmeis%%' AND hou.fulfillment_sent=0 AND o.orders_status IN(%s) ",
        TABLE_ORDERS, implode(',',array(ORDERS_STATUS_ABGESCHLOSSEN, ORDERS_STATUS_VERSENDET))
    ));
    while($record = xtc_db_fetch_array($query)){
        $orders_id_array[] = $record['orders_id'];
    }
    foreach($orders_id_array as $orders_id){
        $query = xtc_db_query(sprintf(
                "SELECT hitmeister_orders_id FROM hitmeister_orders WHERE orders_id='%d'",
                $orders_id
        ));
        $hou_num = xtc_db_num_rows($query);
        if($hou_num == 1){
            $record = xtc_db_fetch_array($query);
            xtc_db_query(sprintf(
                    "UPDATE hitmeister_orders_units SET fulfillment_sent=1 WHERE hitmeister_orders_id='%d'",
                    $record['hitmeister_orders_id']
            ));
        }else{
            $messageStack->add_session('Zur orders_id '.$orders_id.' gibt es '.$hou_num.' Eintraege','error');
        }
        
        xtc_db_query(sprintf(
                "UPDATE hitmeister_orders SET fulfillment_sent=1 WHERE orders_id='%d'",
                $orders_id
        ));
    }
    $messageStack->add_session('Es wurden '.sizeOf($orders_id).' Kaufland Orders manuell als Versendet markiert.','success');
    xtc_redirect(xtc_href_link('hitmeister.php'));
}
if(isset($_GET['action']) and $_GET['action'] == 'fulfillment_process'){
	$basics = new basics;
	$fulfillment_array = array();
	foreach($_POST['send_tracking'] as $hitmeister_id_order_unit=>$active){
		if($active != '1'){
			continue;
		}
		$fulfillment_array[] = array(
			'id_order_unit'=>$hitmeister_id_order_unit,
			'tracking_number'=>$_POST['tracking'][$hitmeister_id_order_unit],
			'carrier_code'=>$_POST['versender_tracking'][$hitmeister_id_order_unit]
		);
	}
	foreach($fulfillment_array as $fa){
                $q = sprintf(
			"SELECT ho.* FROM hitmeister_orders ho LEFT JOIN hitmeister_orders_units hou USING(hitmeister_orders_id) WHERE id_order_unit='%s'",
			$fa['id_order_unit'] 
		);
		$query = xtc_db_query($q);
                
		$record = xtc_db_fetch_array($query);
                if(!isset($record['hitmeister_id_order'])){
                    $dbgtxt = 'Kein Ergebnis beim hitmeister Fulfillment - Query: '.$q."\r\n\r\n\r\nfulfillment_array Eintrag:\r\n".print_r($fa,true);
                    yes_mail_debug($dbgtxt);
                }
                
                // yes table index
                $hitmeister_orders_id = $record['hitmeister_orders_id'];
                
		$comments = sprintf('Kaufland Order %s / Order Unit %s: Fulfillment sent (carrier: %s/Tracking ID %s)',
			$record['hitmeister_id_order'],
			$fa['id_order_unit'],
			$fa['carrier_code'],
			$fa['tracking_number']
		);
		$trackingnumbers = explode(',',$fa['tracking_number']);
		$send_status = false;
		foreach($trackingnumbers as $tn){
			ob_start();
                        
                        $send = $YH->set_sendOrderUnits($fa['id_order_unit'], $fa['carrier_code'], $tn);
                        // GEAENDERT 05/2023
			//$send = $client->orderUnits()->send($fa['id_order_unit'], $fa['carrier_code'], $tn);
			if($send === True){
				$send_status = True;
				$update_sql_array = array(
		                    'fulfillment_sent'=>1
		                );
		                xtc_db_perform('hitmeister_orders_units',$update_sql_array,'update',
		                        "id_order_unit='".$fa['id_order_unit']."' AND hitmeister_orders_id='".$hitmeister_orders_id."'"
		                );
			}else{
				echo 'send: ';
				var_dump($send);
				yes_debug($comments);
				yes_debug($fa);exit;
				$messageStack->add_session('Konnte Kaufland Order Unit '.$fa['id_order_unit'].' nicht als Versendet melden','error');
			}
			$dbg = ob_get_contents();
			ob_end_clean();
			if($dbg != ''){
				yes_mail_debug($dbg);
			}
		}
		if($send_status !== True){
			continue;
		}
		$order = new order($record['orders_id']);
		$order->add_history($order->info['orders_status'],false,$comments);
                
		$xtPrice = new xtcPrice($order->info['currency'],$order->info['status']);
		$pdf_smarty = new yesSmarty;
		$pdf_order_html=xtc_get_order_html_for_pdf($order,$pdf_smarty,CURRENT_TEMPLATE . '/admin/mail/german/pdf_order.html');
		// FUEGE ORDER AN GESAMTPDF AN
		$pdf_file = \main::get_exportdata_path().'HITMEISTER_INVOICE_ORDER_'.$record['hitmeister_id_order'].'.pdf';
		if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
		    $headerandfooter=main::isDev(true) ? true : false;
		    $pdf = new yes_pdf($headerandfooter);
		    if(DOMPDF_ORDER_LANDSCAPE == 'True'){
			$pdf->set_landscape();
		    }
		    $pdf->set_html($pdf_order_html);
		    $pdf->save($pdf_file);
		}else{
		    $order_pdf=new HTML2FPDF();
		    $order_pdf->AddPage();
		    $order_pdf->WriteHTML($pdf_order_html);
		    $order_pdf->Output($pdf_file,'F'); //Read the FPDF.org manual to know the other options
		}
		$PDF_BIN = file_get_contents($pdf_file);
		unlink($pdf_file);
		$parts = parse_url(HTTP_SERVER);
		$fn = $basics->get_valid_filename_from_string($parts['host'].'_'.TEXT_ORDER.'_'.$record['hitmeister_id_order']).'.pdf';

                // Veraltet, 05/2023 geaendert
		//$response = $client->orderInvoices()->post($record['hitmeister_id_order'], $fn, 'application/pdf', base64_encode($PDF_BIN));
                
                // neu, 05/2023
                $YH->order_invoice_upload($record['hitmeister_id_order'],$fn,base64_encode($PDF_BIN));
                
                $update_sql_array = array(
                        'invoice_upload'=>1
                );
                xtc_db_perform('hitmeister_orders',$update_sql_array,'update',"orders_id='".$record['orders_id']."' and hitmeister_id_order='".$record['hitmeister_id_order']."'");
                $order->add_history($order->info['orders_status'],false,'Kaufland Invoice Upload ('.$fn.') OK');
	}
	$messageStack->add_session(sprintf(
		"Es wurden %d Kaufland Auftragsartikel als versendet gemeldet",sizeOf($fulfillment_array)
	),'success');
	xtc_redirect(xtc_href_link('hitmeister.php'));
	exit;
}

$hitmeister_orders = array();
$idOffer = null;
$createdFrom = null;
$updatedFrom = null;
$sort = 'ts_created:desc';
$limit = 100;
$offset = 0;
// ALT 05/2023
// $hitmeister_order_units = $client->orderUnits()->find('need_to_be_sent', $idOffer, $createdFrom, $updatedFrom, $sort, $limit );
// NEU 05/2023
$hitmeister_order_units = json_decode($YH->get_orderUnits('need_to_be_sent',$idOffer,$createdFrom,$updatedFrom,$sort,$limit, $offset));
$versender_allocation = array();
if(defined('MODULE_OTHER_YES_HITMEISTER_API_CARRIER_ALLOCATION') and MODULE_OTHER_YES_HITMEISTER_API_CARRIER_ALLOCATION != ''){
	$allocations = explode(',',MODULE_OTHER_YES_HITMEISTER_API_CARRIER_ALLOCATION);
	foreach($allocations as $allocation){
		$allocation_values = explode(':',$allocation);
		$versender_allocation[ $allocation_values[0] ] = $allocation_values[1];
	}
}
foreach($hitmeister_order_units->data as $hou){
	$oID = yes_hitmeister::hitmeister_get_yes_orders_id_from_id_order($hou->id_order);
	$action = '';
	if($oID > 0){
		$order = new order($oID);
		if(in_array($order->info['orders_status'],array(ORDERS_STATUS_ABGESCHLOSSEN, ORDERS_STATUS_VERSENDET))){
			$action = '';
			if(yes_shipping::shipping_exists($order->info['id'], 'order')){
				$query = xtc_db_query(sprintf(
					"SELECT id FROM shippings WHERE orders_id='%d' AND reclamations_id < 1",
					$order->info['id']
				));
				while($record = xtc_db_fetch_array($query)){
					$ysh = new yes_shipping($record['id']);
					$name = sprintf("tracking[%s]",$hou->id_order_unit);
					if(sizeOf($ysh->tracking_id_array) > 1){
						$value = '';
						foreach($ysh->tracking_id_array as $tracking_id){
							if(strlen($value) > 1){
								$value .= '+';
							}
							$value .= $tracking_id;
						}
					}else{
						$value = current($ysh->tracking_id_array);
					}
					$versender_name = (isset($versender_allocation[$ysh->versender]))?$versender_allocation[$ysh->versender]:$ysh->versender;
					$versender_changed = ($versender_name != $ysh->versender) ? ' ('.$ysh->versender.') ' : '';
					$input = '<div class="versender" data-versender="'.$versender_name.'" data-id_order_unit="'.$hou->id_order_unit.'">'.$versender_name.$versender_changed.' Trackingnumber(s):</div>'.
						xtc_draw_checkbox_field('send_'.$name,1,true).
						xtc_draw_hidden_field('versender_'.$name,$versender_name).
						xtc_draw_input_field($name, $value);
					$action .= '<br />'.$input;
				}
			}
		}
	}
	$tr_class = '';
	if($oID < 1){
		$tr_class = 'unknown';
		$action = 'not imported';
	}else{
		if($action == ''){
			$tr_class = 'invalid_status';
			$action = 'invalid orders status';
		}
	}
	$hitmeister_orders[] = array(
		'tr_class'=>$tr_class,
		'id_order'=>$hou->id_order, 
		'ts_created'=>$hou->ts_created,
		'delivery_time_expires'=>$hou->delivery_time_expires,
		'orders_id'=>$oID,
		'orders_status_name'=>$order->info['orders_status_name'],
		'id_order_unit'=>$hou->id_order_unit,
		'id_item'=>$hou->item->id_item,
		'products_id'=>yes_hitmeister::get_products_id_from_id_item($hou->item->id_item),
		'main_picture'=>$hou->item->main_picture,
		'url'=>$hou->item->url,
		'title'=>substr($hou->item->title,0,50).' ...',
		'action'=>$action
	);
}
// WENN THACH WIEDER MANUELL BEI real RUMFUHRWERKT
$set_send = array();
$query = xtc_db_query(sprintf(
    "SELECT hou.*,ho.orders_id,ho.hitmeister_id_order FROM shippings s LEFT JOIN %s o USING ( orders_id ) LEFT JOIN hitmeister_orders ho USING(orders_id) LEFT JOIN hitmeister_orders_units hou USING(hitmeister_orders_id) WHERE o.source LIKE 'hitmeis%%' AND hou.fulfillment_sent=0 AND o.orders_status IN(%s) ",
    TABLE_ORDERS, implode(',',array(ORDERS_STATUS_ABGESCHLOSSEN, ORDERS_STATUS_VERSENDET))
));
while($record = xtc_db_fetch_array($query)){
	$listed = false;
	foreach($hitmeister_orders as $ho){
		if($ho['id_order_unit'] == $record['id_order_unit']){
			$listed = true;
		}
	}
	if(!$listed){
		$set_send[] = sprintf('<a href="%s">Auftrag %d (%s)</a>',
			xtc_href_link('hitmeister.php?action=set_send&orders_id='.$record['orders_id']),
			$record['orders_id'],
			$record['hitmeister_id_order']
		);
	}
}

$smarty->assign(array(
	'hitmeister_orders'=>$hitmeister_orders,
	'input_hitmeister_versender'=>xtc_draw_pull_down_menu('hitmeister_versender',$valid_versender),
	'TEXT_UNKNOWN_SHIPPER'=>TEXT_UNKNOWN_SHIPPER,
	'TEXT_SHOW_HIDDEN_HITMEISTER_ORDERS'=>TEXT_SHOW_HIDDEN_HITMEISTER_ORDERS,
	'TEXT_MARK_AS_SEND'=>TEXT_MARK_AS_SEND,
	'TEXT_FULFILLMENT_DATE_EXPIRES'=>TEXT_FULFILLMENT_DATE_EXPIRES,
	'TEXT_SEND_FULFILLMENT_CONFIRMATION'=>TEXT_SEND_FULFILLMENT_CONFIRMATION,
	'HITMEISTER_FULFILLMENT_PAGE_TITLE'=>HITMEISTER_FULFILLMENT_PAGE_TITLE,
	'HITMEISTER_SHIPPER_SELECT'=>HITMEISTER_SHIPPER_SELECT,
	'SET_SEND_ARRAY'=>$set_send
));
yes_draw_pre_header();
yes_draw_header(TITLE);
$smarty->display('templates/hitmeister.fulfillment.html');
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');
exit;
