<?php
if(!defined('MODULE_OTHER_HTG_STATUS') or MODULE_OTHER_HTG_STATUS != 'True'){
    $messageStack->add_session('HTG Module not installed','error');
    xtc_redirect(xtc_href_link(FILENAME_CATEGORIES));
}
include(DIR_FS_CATALOG.'lang/german/modules/other/htg.php');
include(DIR_FS_CATALOG.'includes/modules/other/htg.php');
$htg = new htg;

if(isset($_GET['import']) and $_GET['import'] == 1){
    if(!isset($_POST['import']) or !sizeOf($_POST['import'])){
        xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('import'))));
    }
    $imported = 0;
    foreach($_POST['import'] as $ArticleNumber){
        if($htg->allocation_exists($ArticleNumber)){
            $htg->update_stock($ArticleNumber,$Product->AvailableStock);
            continue;
        }
        $htg->import_item($ArticleNumber);
        $imported++;
    }
    $messageStack->add_session(sprintf(
            MSG_SUCCESS_HTG_IMPORT,
            $imported
    ),'success');
    xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('import'))));
}
    

// wird ueber die categories.php included
$smarty = new yesSmarty;
$smarty->assign('lang_img_path',DIR_WS_LANGUAGES.$_SESSION['language'].'/admin/images/buttons/');
$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
$buttons = array();
/*$buttons = array(
    array('text'=>TEXT_EXTENDED_SEARCH,
	'link'=>xtc_href_link('advanced_search.php',xtc_get_all_get_params(array('action','pID'))),
	'lbOn'=>false,
	'auth'=>true
    ),
);*
 */
$start = (isset($_GET['page'])) ? (int) xtc_db_input($_GET['page']) * $htg::DISPLAY_LIMIT : 0;
$current_page = (isset($_GET['page'])) ? (int) xtc_db_input($_GET['page']) : 0;
$search = (isset($_GET['search'])) ? $_GET['search'] : '';
$search_mode = (isset($_GET['search_mode'])) ? $_GET['search_mode'] : '';
$data = $htg->read_importfile($start,$search_mode, $search);
$data = $htg->assign_products_allocation($data);
$size = $htg->get_importfile_data_size($search_mode, $search);
$modulo = $size % $htg::DISPLAY_LIMIT;
$pages_array = [];
$pages_num = ($size - $modulo) / $htg::DISPLAY_LIMIT;
for($i=0;$i<$pages_num;$i++){
    $pages_array[] = array('id'=>$i,'text'=>($i+1));
}
if($modulo > 0){
    $pages_array[] = array('id'=>$i,'text'=>($i+1));
    $pages_num++;
}
if($start+$htg::DISPLAY_LIMIT <= $size){
    $bis = $start+$htg::DISPLAY_LIMIT;
}else{
    $bis = $size;
}
$smarty->assign(array(
    'HEADING_TITLE'=>HTG_HEADING_TITLE,
    'ADDITIONAL_PAGE_TITLE'=>sprintf(HTG_ADDITIONAL_TITLE,
            $htg->get_importfile_date(), 
            $htg->get_importfile_data_size()
     ),
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
    'PRODUCTS'=>$data,
    'PAGES_SELECT'=>xtc_draw_pull_down_menu('page',$pages_array, $current_page),
    'PAGER_LINK'=>xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('page'))),
    'PAGER_INFO'=>sprintf(TEXT_DISPLAY_NUMBER_OF_PRODUCTS, $start, $bis,$size),
    'INPUT_SEARCHMODE'=>xtc_draw_pull_down_menu('search_mode',[
        ['id'=>'barcode','text'=>'Barcode'],
        ['id'=>'articlenumber','text'=>'ArticleNumber'],
        ['id'=>'description','text'=>'Description'],
     ],$search_mode),
    'INPUT_SEARCH'=>xtc_draw_input_field('search',$search,'size="16" maxlength="32"'),
    'SEARCH_FORM'=>xtc_draw_form('product_search',FILENAME_CATEGORIES,'','GET').
        xtc_draw_hidden_field('action',$_GET['action']),
    'IMPORT_FORM'=>xtc_draw_form('products_import',FILENAME_CATEGORIES,xtc_get_all_get_params(array('import')).'import=1','POST'),
));
yes_draw_pre_header();
yes_draw_header(HTG_HEADING_TITLE);
$smarty->display('htg.html');
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');
exit;