<?php

namespace YES4Trade\Model;

class coupons extends \YES4Trade\Model\BaseType {

    const TABLE_NAME = 'coupons';
    const TABLE_INDEX = 'coupon_id';

    private static $propertyTypes = [
        'coupon_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'coupon_id'
        ],
        'coupon_type' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'coupon_type'
        ],
        'coupon_code' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'coupon_code'
        ],
        'coupon_amount' => [
            'type' => 'double',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'coupon_amount'
        ],
        'coupon_minimum_order' => [
            'type' => 'double',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'coupon_minimum_order'
        ],
        'coupon_start_date' => [
            'type' => 'DateTime',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'coupon_start_date'
        ],
        'coupon_expire_date' => [
            'type' => 'DateTime',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'coupon_expire_date'
        ],
        'uses_per_coupon' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'uses_per_coupon'
        ],
        'uses_per_user' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'uses_per_user'
        ],
        'restrict_to_products' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'restrict_to_products'
        ],
        'restrict_to_categories' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'restrict_to_categories'
        ],
        'restrict_to_customers' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'restrict_to_customers'
        ],
        'coupon_active' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'coupon_active'
        ],
        'date_created' => [
            'type' => 'DateTime',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'date_created'
        ],
        'date_modified' => [
            'type' => 'DateTime',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'date_modified'
        ],
        'free_shipping_countries' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'free_shipping_countries'
        ],
    ];


	public function __construct(array $values = []) {
		list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
		parent::__construct($parentValues);
		if (!array_key_exists(__CLASS__, self::$properties)) {
			self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
		}
		if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
			self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
		}
		$this->setValues(__CLASS__, $childValues);
	}


	public function create() {
		$data = self::convert_values( $this->toArray(),self::$propertyTypes );
		yes_db_perform(self::TABLE_NAME, $data);
		return xtc_db_insert_id();
	}


	public function update() {
		$data = self::convert_values( $this->toArray(),self::$propertyTypes );
		unset($data[self::TABLE_INDEX]);
		$index = self::TABLE_INDEX;
		yes_db_perform(self::TABLE_NAME, $data,'update',[$index=>$this->$index]);
	}


	public static function delete(int $index) {
		yes_query(sprintf(
			"DELETE FROM %s WHERE %s=:id",
				self::TABLE_NAME,self::TABLE_INDEX
			),['id'=>$index]
		);
	}


	public static function get_by_coupon_id(int $coupon_id, array $select_fields = []) {
		$select_field_string = '*';
		if(sizeOf($select_fields)){
			$select_field_string = implode(',',$select_fields);
		}
		$query = yes_query(sprintf(
			"SELECT %s FROM %s WHERE %s=:id",
				$select_field_string,self::TABLE_NAME, self::TABLE_INDEX
			),['id'=>$coupon_id]
		);
		if(!sizeOf($query)){
			return null;
		}
		$record = current($query);
		return new self(self::convert_values($record,self::$propertyTypes));
	}

	public static function get_by_coupon_code(string $coupon_code, array $select_fields = []) {
		$select_field_string = '*';
		if(sizeOf($select_fields)){
			$select_field_string = implode(',',$select_fields);
		}
		$query = yes_query(sprintf(
			"SELECT %s FROM %s WHERE coupon_code=:code",
				$select_field_string,self::TABLE_NAME, 
			),['code'=>$coupon_code]
		);
		if(!sizeOf($query)){
			return null;
		}
		$record = current($query);
		return new self(self::convert_values($record,self::$propertyTypes));
	}

}
