<?php

namespace YES4Trade\Model;

class customers_status extends \YES4Trade\Model\BaseType {

    const TABLE_NAME = 'customers_status';
    const TABLE_INDEX = 'customers_status_id';

    private static $propertyTypes = [
        'customers_status_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_status_id'
        ],
        'language_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'language_id'
        ],
        'customers_status_name' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_status_name'
        ],
        'customers_status_public' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_status_public'
        ],
        'customers_status_image' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_status_image'
        ],
        'customers_status_discount' => [
            'type' => 'double',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_status_discount'
        ],
        'customers_status_ot_discount_flag' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_status_ot_discount_flag'
        ],
        'customers_status_ot_discount' => [
            'type' => 'double',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_status_ot_discount'
        ],
        'customers_status_graduated_prices' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_status_graduated_prices'
        ],
        'customers_status_show_price' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_status_show_price'
        ],
        'customers_status_show_price_tax' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_status_show_price_tax'
        ],
        'customers_status_add_tax_ot' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_status_add_tax_ot'
        ],
        'customers_status_payment_unallowed' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_status_payment_unallowed'
        ],
        'customers_status_shipping_unallowed' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_status_shipping_unallowed'
        ],
        'customers_status_discount_attributes' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_status_discount_attributes'
        ],
        'customers_fsk18' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_fsk18'
        ],
        'customers_fsk18_display' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_fsk18_display'
        ],
        'customers_status_payment_target' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_status_payment_target'
        ],
        'export_note' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'export_note'
        ],
        'export_note_text' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'export_note_text'
        ],
        'customers_status_skonto' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_status_skonto'
        ],
        'customers_status_default_admin_paymentmethod' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_status_default_admin_paymentmethod'
        ],
        'customers_status_delivery_conditions' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_status_delivery_conditions'
        ],
        'account_value_alert_status' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'account_value_alert_status'
        ],
        'account_value_alert_limit' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'account_value_alert_limit'
        ],
        'sort_order' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'sort_order'
        ],
        'customers_status_description' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_status_description'
        ],
    ];


	public function __construct(array $values = []) {
		list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
		parent::__construct($parentValues);
		if (!array_key_exists(__CLASS__, self::$properties)) {
			self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
		}
		if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
			self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
		}
		$this->setValues(__CLASS__, $childValues);
	}


	public function create() {
		$data = self::convert_values( $this->toArray(),self::$propertyTypes );
		yes_db_perform(self::TABLE_NAME, $data);
		return xtc_db_insert_id();
	}


	public function update() {
		$data = self::convert_values( $this->toArray(),self::$propertyTypes );
		unset($data[self::TABLE_INDEX]);
		$index = self::TABLE_INDEX;
		yes_db_perform(self::TABLE_NAME, $data,'update',[$index=>$this->$index]);
	}


	public static function delete(int $index) {
		yes_query(sprintf(
			"DELETE FROM %s WHERE %s=:id",
				self::TABLE_NAME,self::TABLE_INDEX
			),['id'=>$index]
		);
	}


	/**
     * get by customers_status_id
     * 
	 * @param int $customers_status_id
	 * @param array $select_fields
	 * 
	 * @return mixed (null or object)
	 */
	public static function get_by_customers_status_id(int $customers_status_id, array $select_fields = []) {
		$select_field_string = '*';
		if(sizeOf($select_fields)){
			$select_field_string = implode(',',$select_fields);
		}
		$query = yes_query(sprintf(
			"SELECT %s FROM %s WHERE %s=:id",
				$select_field_string,self::TABLE_NAME, self::TABLE_INDEX
			),['id'=>$customers_status_id]
		);
		if(!sizeOf($query)){
			return null;
		}
		$record = current($query);
		return new self(self::convert_values($record,self::$propertyTypes));
	}


	/**
     * get item list by customers_status_id and language_id
     * 
	 * @param int $customers_status_id
	 * @param int $language_id
	 * @param array $select_fields
	 * 
	 * @return array
	 */
	public static function get_by_customers_status_id_and_language_id(int $customers_status_id, int $language_id, array $select_fields = []) {
        $items = [];
		$select_field_string = '*';
		if(sizeOf($select_fields)){
			$select_field_string = implode(',',$select_fields);
		}
		$query = yes_query(sprintf(
			"SELECT %s FROM %s WHERE customers_status_id=:customers_status_id AND language_id=:language_id",
				$select_field_string,self::TABLE_NAME
			),['customers_status_id'=>$customers_status_id,'language_id'=>$language_id]
		);
        foreach($query as $record){
		    $items[] = new self(self::convert_values($record,self::$propertyTypes));
        }
        return $items;
	}

	/**
     * get items by language_id
     * result is sorted by: ORDER BY customers_status_id
     * 
	 * @param int $language_id
	 * @param array $select_fields
	 * 
	 * @return array
	 */
	public static function get_by_language_id(int $language_id, array $select_fields = []) {
        $items = [];
		$select_field_string = '*';
		if(sizeOf($select_fields)){
			$select_field_string = implode(',',$select_fields);
		}
		$query = yes_query(sprintf(
			"SELECT %s FROM %s WHERE language_id=:id ORDER BY customers_status_id",
				$select_field_string,self::TABLE_NAME
			),['id'=>$language_id]
		);
        foreach($query as $record){
		    $items[] = new self(self::convert_values($record,self::$propertyTypes));
        }
        return $items;
	}

    public static function get_next_id(){
        $next_id_query = xtc_db_query(sprintf(
            "select max(customers_status_id) as customers_status_id from %s",
            self::TABLE_NAME
        ));
        $next_id = xtc_db_fetch_array($next_id_query);
        return intval($next_id['customers_status_id']) + 1;
    }

}
