<?php

namespace YES4Trade\Model;

class ebay_email_bodys extends \YES4Trade\Model\BaseType {

    const TABLE_NAME = 'ebay_email_bodys';

    private static $propertyTypes = [
        'email_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'email_id'
        ],
        'email_body' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'email_body'
        ],
    ];


	public function __construct(array $values = []) {
		list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
		parent::__construct($parentValues);
		if (!array_key_exists(__CLASS__, self::$properties)) {
			self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
		}
		if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
			self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
		}
		$this->setValues(__CLASS__, $childValues);
	}


	public function create():int {
		$data = self::convert_values( $this->toArray(),self::$propertyTypes );
		yes_db_perform(self::TABLE_NAME, $data);
		return xtc_db_insert_id();
	}


	public static function delete(int $email_id) {
		yes_query(sprintf(
			"DELETE FROM %s WHERE email_id=:id",
				self::TABLE_NAME
			),['id'=>$email_id]
		);
	}


	public static function get_by_email_id(int $email_id) {
		$query = yes_query(sprintf(
			"SELECT * FROM %s WHERE email_id=:id",
				self::TABLE_NAME
			),['id'=>$email_id]
		);
		if(!sizeOf($query)){
			return null;
		}
		$record = current($query);
		return new self(self::convert_values($record,self::$propertyTypes));
	}

    /**
     * wrapper function to create
     * @param array $data
     * 
     * @return int insert_id
     */
    public static function create_ebay_email_bodys(array $data):int{
        $new = new self($data);
        return $new->create();
    }


    /**
     * Haengt einen Text an einen bestehenden ebay_email_body.email_body mit CONCAT an
     * 
     * @param int $ebay_email_id
     * @param string $add_string
     * 
     * @return none
     */
    public static function add_inline_attachment(int $ebay_email_id, string $add_string){
        yes_query(sprintf(
            "UPDATE %s SET email_body=CONCAT(email_body,'\r\n\r\n',:add_string) WHERE email_id=:id",
                self::TABLE_NAME
            ),[
                'add_string'=>$add_string,
                'id'=>$ebay_email_id
            ]
        );
    }
}
