<?php
namespace YES4Trade\Model;
class ebay_products_regulatory_documents extends \YES4Trade\Model\BaseType{
    const TABLE_NAME = 'ebay_products_regulatory_documents';
    const TABLE_INDEX = 'ebay_products_regulatory_documents_id';
    private static $propertyTypes = [
        'ebay_products_regulatory_documents_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ebay_products_regulatory_documents_id'
        ],
        'ebay_products_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ebay_products_id'
        ],
        'documents_id' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'documents_id'
        ],
        'date_added' => [
            'type' => 'DateTime',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'date_added'
        ],
        'ebay_media_data' => [
            'type' => 'YES4Trade\Model\ebay_media_documents',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ebay_media_data'
        ],
    ];
    
    public function __construct( array $values = [] ){
        list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
        parent::__construct($parentValues);

        if (!array_key_exists(__CLASS__, self::$properties)) {
            self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
        }

        if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
            self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
        }

        $this->setValues(__CLASS__, $childValues);
    }
	public static function convertInt( array $data ){
		foreach(get_class_vars(__CLASS__) as $pk=>$pv){
		   if($pk == 'propertyTypes'){
		   	foreach($pv as $kpart => $part){
			   if($part['type'] == 'integer' and isset($data[$kpart])){
			       $data[$kpart] = (int)$data[$kpart];
			   }
		   	}
		   }
		}
		return $data;
	}
    
    public function create(){
        $data = $this->toArray();
        $data = self::convertInt($data);
        xtc_db_perform(self::TABLE_NAME, $data);
        return xtc_db_insert_id();
    }
    
    public function update(){
        $data = $this->toArray();
        $data = self::convertInt($data);
        unset($data[self::TABLE_INDEX]);
        $index = self::TABLE_INDEX;
        xtc_db_perform(self::TABLE_NAME, $data,'update',self::TABLE_INDEX."='".$this->$index."'");
    }
    
    public static function delete( int $index ){
        xtc_db_query(sprintf(
                "DELETE FROM %s WHERE %s='%d'",
                self::TABLE_NAME,self::TABLE_INDEX, $index
        ));
    }
    
    public static function get_documents_with_ebay_media_details(int $ebay_products_id, string $seller){
        $documents = [];
        $query = xtc_db_query(sprintf(
            "SELECT emd.*,epr.* FROM %s epr LEFT JOIN ebay_media_documents emd USING(documents_id) WHERE ebay_products_id='%d' AND seller='%s'",
            self::TABLE_NAME,$ebay_products_id, $seller
        ));
        while($row = xtc_db_fetch_array($query)){
            $emd_row = $row;
            unset($emd_row['ebay_products_regulatory_documents_id']);
            unset($emd_row['ebay_products_id']);
            unset($emd_row['date_added']);
	    $emd_row = self::convertInt($emd_row);
	    $emd_row['ebay_media_documents_id'] = (int)$emd_row['ebay_media_documents_id'];
	    $emd_row['fileSize'] = (int)$emd_row['fileSize'];
            $row['ebay_media_data'] = new \YES4Trade\Model\ebay_media_documents($emd_row);
            unset($row['ebay_media_documents_id']);
            unset($row['documentType']);
            unset($row['documentStatus']);
            unset($row['fileName']);
            unset($row['fileSize']);
            unset($row['fileType']);
            unset($row['seller']);
	    $row = self::convertInt($row);
            $documents[] = new \YES4Trade\Model\ebay_products_regulatory_documents($row);
        }
        return $documents;
    }
    
    public static function get_by_ebay_products_id( int $ebay_products_id ){
        $items = [];
        $query = xtc_db_query(sprintf(
            "SELECT * FROM %s WHERE ebay_products_id='%d' ORDER BY date_added",
            self::TABLE_NAME, $ebay_products_id
        ));
        while($record = xtc_db_fetch_array($query)){
	    $record = self::convertInt($record);
            $items[] = new \YES4Trade\Model\ebay_products_regulatory_documents($record);
        }
        return $items;
    }
    
    public static function get_by_documents_id_and_ebay_products_id(string $documents_id, int $ebay_products_id){
        $query = xtc_db_query(sprintf(
            "SELECT * FROM %s WHERE ebay_products_id='%d' and documents_id='%s'",
            self::TABLE_NAME, $ebay_products_id, $documents_id
        ));
        if(xtc_db_num_rows($query)){
            $record = xtc_db_fetch_array($query);
 	    $record = self::convertInt($record);
	    return new \YES4Trade\Model\ebay_products_regulatory_documents($record);
        }
        return null;
    }
    
}
