<?php
namespace YES4Trade\Model;

/**
 * Description of category
 *
 * @author mario
 */
class languages extends \YES4Trade\Model\BaseType{
    private static $propertyTypes = [
        'languages_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'languages_id'
        ],
        'name' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'name'
        ],
        'code' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'code'
        ],
        'image' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'image'
        ],
        'directory' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'directory'
        ],
        'sort_order' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'sort_order'
        ],
        'language_charset' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'language_charset'
        ],
    ];
    
    public function __construct( array $values = [] ){
        list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
        parent::__construct($parentValues);

        if (!array_key_exists(__CLASS__, self::$properties)) {
            self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
        }

        if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
            self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
        }

        $this->setValues(__CLASS__, $childValues);
    }
    
    public static function clear_cache(){
        global $InstanceCache;
        \yescache_helper::cache_bump_generation($InstanceCache, 'categories');
        $InstanceCache->deleteItem('languages');
        foreach($InstanceCache->getItemsByTags(['admin','shop']) as $cn=>$cd){
            if(strpos($cd->getKey(),'customers_status')>-1 
                    or strpos($cd->getKey(),'country_values_')>-1
            ){
                $InstanceCache->deleteItem($cd->getKey()); // customers_status,country_values_*
            }
        }
    }
    
    public function create(){
        xtc_db_perform(TABLE_LANGUAGES, $this->toArray());
        self::clear_cache();
        return xtc_db_insert_id();
    }
    
    public function update(){
        $data = $this->toArray();
        $data['languages_id'] = null;
        unset($data['languages_id']);
        xtc_db_perform(TABLE_LANGUAGES, $data,'update',"languages_id='".$this->languages_id."'");
        self::clear_cache();
    }
    
    public static function delete( int $languages_id ){
        xtc_db_query(sprintf(
                "DELETE FROM %s WHERE languages_id='%d'",
                TABLE_LANGUAGES,$languages_id
        ));
        self::clear_cache();
    }
    
    public static function get_list(){
        global $InstanceCache;
        $key = 'languages';
        $CachedString = $InstanceCache->getItem($key);
        if (!$CachedString->isHit()) {
            $return = [];
            $query = xtc_db_query(sprintf(
                    "SELECT * FROM %s order by sort_order",
                    TABLE_LANGUAGES
            ));
            while($record = xtc_db_fetch_array($query)){
                $return[] = $record;
            }
            $CachedString->set($return)->expiresAfter(0)->addTags(['shop','admin']);//languages
            $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
        }else{
            $return = $CachedString->get();
        }
        return $return;
    }
}
