<?php

namespace YES4Trade\Model;

class orders_pallets extends \YES4Trade\Model\BaseType {

    const TABLE_NAME = 'orders_pallets';
    const TABLE_INDEX = 'orders_pallets_id';

    private static $propertyTypes = [
        'orders_pallets_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'orders_pallets_id'
        ],
        'orders_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'orders_id'
        ],
        'length' => [
            'type' => 'double',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'length'
        ],
        'width' => [
            'type' => 'double',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'width'
        ],
        'height' => [
            'type' => 'double',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'height'
        ],
        'weight_total' => [
            'type' => 'double',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'weight_total'
        ],
        'quantity' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'quantity'
        ],
        'notes' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'notes'
        ],
        'created_at' => [
            'type' => 'DateTime',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'created_at'
        ],
        'updated_at' => [
            'type' => 'DateTime',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'updated_at'
        ],
    ];


	public function __construct(array $values = []) {
		list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
		parent::__construct($parentValues);
		if (!array_key_exists(__CLASS__, self::$properties)) {
			self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
		}
		if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
			self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
		}
		$this->setValues(__CLASS__, $childValues);
	}


	public function create() {
		$data = self::convert_values( $this->toArray(),self::$propertyTypes );
		yes_db_perform(self::TABLE_NAME, $data);
		return xtc_db_insert_id();
	}


	public function update() {
		$data = self::convert_values( $this->toArray(),self::$propertyTypes );
		unset($data[self::TABLE_INDEX]);
		$index = self::TABLE_INDEX;
		yes_db_perform(self::TABLE_NAME, $data,'update',[$index=>$this->$index]);
	}


	public static function delete(int $index) {
        $items = \YES4Trade\Model\orders_pallets_items::get_by_orders_pallets_id($index);
        foreach($items as $item){
            \YES4Trade\Model\orders_pallets_items::delete(intval($item->orders_pallets_items_id));
        }
		yes_query(sprintf(
			"DELETE FROM %s WHERE %s=:id",
				self::TABLE_NAME,self::TABLE_INDEX
			),['id'=>$index]
		);
	}

    public static function get_by_orders_id(int $orders_id, array $select_fields = []):array{
        $return = [];
		$select_field_string = '*';
		if(sizeOf($select_fields)){
			$select_field_string = implode(',',$select_fields);
		}
		$query = yes_query(sprintf(
			"SELECT %s FROM %s WHERE orders_id=:id",
				$select_field_string,self::TABLE_NAME
			),['id'=>$orders_id]
		);
		foreach($query as $record){
            $return[] = new self(self::convert_values($record,self::$propertyTypes));
        }
        return $return;
    }

	public static function get_by_orders_pallets_id(int $orders_pallets_id, array $select_fields = []) {
		$select_field_string = '*';
		if(sizeOf($select_fields)){
			$select_field_string = implode(',',$select_fields);
		}
		$query = yes_query(sprintf(
			"SELECT %s FROM %s WHERE %s=:id",
				$select_field_string,self::TABLE_NAME, self::TABLE_INDEX
			),['id'=>$orders_pallets_id]
		);
		if(!sizeOf($query)){
			return null;
		}
		$record = current($query);
		return new self(self::convert_values($record,self::$propertyTypes));
	}

}
