<?php

namespace YES4Trade\Model;

class products_content extends \YES4Trade\Model\BaseType {

    const TABLE_NAME = 'products_content';
    const TABLE_INDEX = 'content_id';

    private static $propertyTypes = [
        'content_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'content_id'
        ],
        'products_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'products_id'
        ],
        'group_ids' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'group_ids'
        ],
        'content_file' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'content_file'
        ],
        'content_link' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'content_link'
        ],
        'languages_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'languages_id'
        ],
        'content_read' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'content_read'
        ],
    ];


    public function __construct(array $values = []) {
        list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
        parent::__construct($parentValues);
        if (!array_key_exists(__CLASS__, self::$properties)) {
            self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
        }
        if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
            self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
        }
        $this->setValues(__CLASS__, $childValues);
    }


    public function create() {
        $data = $this->toArray();
        xtc_db_perform(self::TABLE_NAME, $data);
        return xtc_db_insert_id();
    }


    public function update() {
        $data = $this->toArray();
        unset($data[self::TABLE_INDEX]);
        $index = self::TABLE_INDEX;
        xtc_db_perform(self::TABLE_NAME, $data,'update',$index."='".$this->$index."'");
    }


    public static function delete(int $index) {
        $pcd_list = \YES4Trade\Model\products_content_description::get_by_content_id($index,[
            'products_content_description_id'
        ]);
        foreach($pcd_list as $pcd){
            \YES4Trade\Model\products_content_description::delete(intval($pcd->products_content_description_id));
        }
        xtc_db_query(sprintf(
            "DELETE FROM %s WHERE %s='%d'",
            self::TABLE_NAME,self::TABLE_INDEX, $index
        ));
    }


    public static function get_by_content_id(int $content_id) {
        $query = yes_query(sprintf(
            "SELECT * FROM %s WHERE %s=:id",
                self::TABLE_NAME, self::TABLE_INDEX
            ),['id'=>$content_id]
        );
        if(!sizeOf($query)){
            return null;
        }
        $record = current($query);
        return new self($record);
    }
    
    public static function get_distinct_content_file(){
        $items = [];
        $query = xtc_db_query(sprintf(
                "SELECT DISTINCT content_file FROM %s WHERE content_file != ''",
                self::TABLE_NAME
        ));
        while($record = xtc_db_fetch_array($query)){
            $items[] = $record['content_file'];
        }
        return $items;
    }
    
    public static function get_by_products_id( int $products_id ){
        $items = [];
        $query = yes_query(sprintf(
            "SELECT * FROM %s WHERE products_id =:id order by content_file",
                self::TABLE_NAME
            ),['id'=>$products_id]
        );
        foreach($query as $record){
            $record['content_id'] = (int)$record['content_id'];
            $record['products_id'] = (int)$record['products_id'];
            $record['languages_id'] = (int)$record['languages_id'];
            $record['content_read'] = (int)$record['content_read'];
            $items[] = new self($record);
        }
        return $items;
    }
    
    public static function get_by_content_file( string $file ){
        $items = [];
        $query = yes_query(sprintf(
            "SELECT * FROM %s WHERE content_file =:file",
                self::TABLE_NAME
            ),['file'=>$file]
        );
        foreach($query as $record){
            $record['content_id'] = (int)$record['content_id'];
            $record['products_id'] = (int)$record['products_id'];
            $record['languages_id'] = (int)$record['languages_id'];
            $record['content_read'] = (int)$record['content_read'];
            $items[] = new self($record);
        }
        return $items;
    }

    public static function get_by_not_empty_content_file(){
        $items = [];
        $query = xtc_db_query(sprintf(
                "SELECT * FROM %s WHERE content_file != '' AND products_id > 0",
                self::TABLE_NAME
        ));
        while($record = xtc_db_fetch_array($query)){
            $record['content_id'] = (int)$record['content_id'];
            $record['products_id'] = (int)$record['products_id'];
            $record['languages_id'] = (int)$record['languages_id'];
            $record['content_read'] = (int)$record['content_read'];
            $items[] = new self($record);
        }
        return $items;
    }

    public static function get( array $select_fields = []) {
        $items = [];
		$select_field_string = '*';
		if(sizeOf($select_fields)){
			$select_field_string = implode(',',$select_fields);
		}
        $query = yes_query(sprintf(
            "SELECT %s FROM %s ORDER BY products_id",
                $select_field_string, self::TABLE_NAME
            )
        );
        foreach($query as $record){
            $items[] = new self(self::convert_values($record,self::$propertyTypes));
        }
        return $items;
    }
    
    public static function get_by_languages_id( int $languages_id ){
        $items = [];
        $query = yes_query(sprintf(
            "SELECT * FROM %s WHERE languages_id=:id ORDER BY products_id",
                self::TABLE_NAME
            ),['id'=>$languages_id]
        );
        foreach($query as $record){
            $record['content_id'] = (int)$record['content_id'];
            $record['products_id'] = (int)$record['products_id'];
            $record['languages_id'] = (int)$record['languages_id'];
            $record['content_read'] = (int)$record['content_read'];
            $items[] = new self($record);
        }
        return $items;
    }

    /**
     * wenn in $filename files/ vorhanden ist, wird der Pfad so ausgegeben wie er ist
     * ist kein / vorhanden, liegt die Datei vermutlich in media/products und media/products wird dateinamen vorangestellt
     * ... doof geloest beim anlegen
     * @param string $filename
     * 
     * @return [type]
     */
    public static function get_file_content_dir(string $filename){
        if(empty($filename)){
            return '';
        }
        if(strpos($filename,'/')>-1){
            if(is_file(DIR_FS_CATALOG.$filename)){
                return $filename;
            }
        }
        if(is_file(DIR_FS_CATALOG.'/media/products/'.$filename)){
            return 'media/products/'.$filename;
        }
    }

}
