<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

namespace YES4Trade\Model;
class todo_item_revise{

    function __construct( object $item ){
        $ea_item = \YES4Trade\Model\ebay_auctions::get_by_id(intval($item->params->ebay_auctions_id),[
            'ebay_id', 'type','status'
        ]);
        if($ea_item === null){
            throw new Exception('unknown_auction');
        }
        if(intval($ea_item->status) == 2){
            throw new Exception('expended_auction');
        }
        $EBAYAPI = new \ebayApi;
        $ea = new \ebay_auction($item->params->ebay_auctions_id);
        $itemType = $EBAYAPI->get_sdk_type_class('ItemType');
        $itemType->ItemID = $ea->getEbayId();
        if(is_countable($item->params->variations->variation) && sizeOf($item->params->variations->variation)){
            $Variations = $EBAYAPI->get_sdk_type_class('VariationsType');
            $ziele = [];
            foreach($item->params->variations->variation as $v){
                $new_price = (float)$v->value;
                $Variation = $EBAYAPI->get_sdk_type_class('VariationType');
                $Variation->StartPrice = new \DTS\eBaySDK\Trading\Types\AmountType([
                    'currencyID'=>DEFAULT_CURRENCY,
                    'value'=>$new_price,
                ]);
                $Variation->SKU = (string)$v->sku;
                $Variations->Variation[] = $Variation;
                $ziele[] = 'SKU '.$Variation->SKU.' auf '.number_format((float)$new_price,2,',');
            }
            $ziel = implode(', ',$ziele);
            $itemType->Variations = $Variations;
        }else{
            $new_price = (float)$item->params->value;
            $itemType->StartPrice = new \DTS\eBaySDK\Trading\Types\AmountType([
                'currencyID'=>DEFAULT_CURRENCY,
                'value'=>(float)$new_price,
            ]);
            $ziel = number_format((float)$new_price,2,',');
        }
        $res = $EBAYAPI->revise_auction($ea->getEbayId(), $itemType);
        if($res === false){
            if(is_countable($item->params->variations->variation) && sizeOf($item->params->variations->variation)){
                foreach($item->params->variations->variation as $iv){
                    \specials_ebay_revise::delete_entry($ea->getEbayId(),$iv->sku);
                }
            }else{
                \specials_ebay_revise::delete_entry($ea->getEbayId());
            }
            throw new Exception(sprintf(
                    'Auktion %s (ID: %d) nicht gefunden oder nicht aktiv. (Ziel: Startpreis %s)',
                    $ea->getEbayId(), $item->params->ebay_auctions_id,
                    $ziel
            ));
        }elseif( $res !== ''){
            if(is_countable($item->params->variations->variation) && sizeOf($item->params->variations->variation)){
                foreach($item->params->variations->variation as $iv){
                    \specials_ebay_revise::delete_entry($ea->getEbayId(),$iv->sku);
                }
            }else{
                \specials_ebay_revise::delete_entry($ea->getEbayId());
            }
            throw new Exception(strip_tags(self::br2nl($res))."\n".$ziel );
        }
        // UPDATE or DELETE specials_ebay_revise Datensaetze
        if($item->target_status == 1){
            // UPDATE
            $sku = '';
            if(is_countable($item->params->variations->variation) && sizeOf($item->params->variations->variation)){
                foreach($item->params->variations->variation as $iv){
                    $specials_ebay_revise_id = \specials_ebay_revise::get_specials_ebay_revise_id_from_auction($item->params->ebay_auctions_id, $iv->sku);
                    $ser = new \specials_ebay_revise( $specials_ebay_revise_id );
                    $ser->update_is_revised(1);
                }
            }else{
                $specials_ebay_revise_id = \specials_ebay_revise::get_specials_ebay_revise_id_from_auction($item->params->ebay_auctions_id, '');
                $ser = new \specials_ebay_revise( $specials_ebay_revise_id );
                $ser->update_is_revised(1);
            }
        }else{
            // DELETE
            if(is_countable($item->params->variations->variation) && sizeOf($item->params->variations->variation)){
                foreach($item->params->variations->variation as $iv){
                    \specials_ebay_revise::delete_entry($ea->getEbayId(), $iv->sku );
                }
            }else{
                \specials_ebay_revise::delete_entry($ea->getEbayId(), '' );
            }
        }
        return true;
    }
    public static function br2nl( $input ) {
        return preg_replace('/<br\s?\/?>/ius', "\n", str_replace("\n","",str_replace("\r","", htmlspecialchars_decode($input))));
    }
}
