<?php

namespace YES4Trade\Model;

class zones_to_geo_zones extends \YES4Trade\Model\BaseType {

    const TABLE_NAME = 'zones_to_geo_zones';
    const TABLE_INDEX = 'zones_to_geo_zones_id';

    private static $propertyTypes = [
        'association_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'association_id'
        ],
        'zone_country_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'zone_country_id'
        ],
        'zone_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'zone_id'
        ],
        'geo_zone_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'geo_zone_id'
        ],
        'last_modified' => [
            'type' => 'DateTime',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'last_modified'
        ],
        'date_added' => [
            'type' => 'DateTime',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'date_added'
        ],
    ];


	public function __construct(array $values = []) {
		list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
		parent::__construct($parentValues);
		if (!array_key_exists(__CLASS__, self::$properties)) {
			self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
		}
		if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
			self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
		}
		$this->setValues(__CLASS__, $childValues);
	}


	public function create() {
		$data = self::convert_values( $this->toArray(),self::$propertyTypes );
		yes_db_perform(self::TABLE_NAME, $data);
		return xtc_db_insert_id();
	}


	public function update() {
		$data = self::convert_values( $this->toArray(),self::$propertyTypes );
		unset($data[self::TABLE_INDEX]);
		$index = self::TABLE_INDEX;
		yes_db_perform(self::TABLE_NAME, $data,'update',[$index=>$this->$index]);
	}


	public static function delete(int $index) {
		yes_query(sprintf(
			"DELETE FROM %s WHERE %s=:id",
				self::TABLE_NAME,self::TABLE_INDEX
			),['id'=>$index]
		);
	}


	public static function get_by_association_id(int $association_id, array $select_fields = []) {
		$select_field_string = '*';
		if(sizeOf($select_fields)){
			$select_field_string = implode(',',$select_fields);
		}
		$query = yes_query(sprintf(
			"SELECT %s FROM %s WHERE %s=:id",
				$select_field_string,self::TABLE_NAME, self::TABLE_INDEX
			),['id'=>$association_id]
		);
		if(!sizeOf($query)){
			return null;
		}
		$record = current($query);
		return new self(self::convert_values($record,self::$propertyTypes));
	}
        
        public static function get_by_geo_zone_id_and_zone_id( int $geo_zone_id, int $zone_id = 0,array $select_fields = []):array{
            $items = [];
            $select_field_string = '*';
            if(sizeOf($select_fields)){
                    $select_field_string = implode(',',$select_fields);
            }
            $query = yes_query(sprintf(
                    "SELECT %s FROM %s WHERE geo_zone_id=:geo_zone_id AND zone_id=:zone_id",
                            $select_field_string,self::TABLE_NAME
                    ),[
                        'geo_zone_id'=>$geo_zone_id,
                        'zone_id'=>$zone_id
                    ]
            );
            if(!sizeOf($query)){
                return $items;
            }
            foreach($query as $record){
                $items[] = new self(self::convert_values($record),self::$propertyTypes);
            }
            return $items;
        }
        
        public static function get_by_geo_zone_id_and_zone_country_id( int $geo_zone_id, int $zone_country_id,array $select_fields = []):array{
            $items = [];
            $select_field_string = '*';
            if(sizeOf($select_fields)){
                    $select_field_string = implode(',',$select_fields);
            }
            $query = yes_query(sprintf(
                    "SELECT %s FROM %s WHERE geo_zone_id=:geo_zone_id AND zone_country_id=:zone_country_id order by zone_id",
                            $select_field_string,self::TABLE_NAME
                    ),[
                        'geo_zone_id'=>$geo_zone_id,
                        'zone_country_id'=>$zone_country_id
                    ]
            );
            if(!sizeOf($query)){
                return $items;
            }
            foreach($query as $record){
                $items[] = new self(self::convert_values($record,self::$propertyTypes));
            }
            return $items;
        }
        
        public static function get_by_geo_zone_id(int $geo_zone_id, array $select_fields = []):array{
            $items = [];
            $select_field_string = '*';
            if(sizeOf($select_fields)){
                    $select_field_string = implode(',',$select_fields);
            }
            $query = yes_query(sprintf(
                "SELECT %s FROM %s WHERE geo_zone_id=:geo_zone_id",
                    $select_field_string,self::TABLE_NAME
                ),['geo_zone_id'=>$geo_zone_id]
            );
            if(!sizeOf($query)){
                return $items;
            }
            foreach($query as $record){
                $items[] = new self(self::convert_values($record,self::$propertyTypes));
            }
            return $items;
        }
        
        /**
         * 
         * @param int $geo_zone_id
         * @return int
         */
        public static function count_by_geo_zone_id(int $geo_zone_id):int{
            $query = yes_query(sprintf(
                "select count(*) as num_zones from %s where geo_zone_id =:id group by geo_zone_id",
                    self::TABLE_NAME
                ),['id'=>$geo_zone_id]
            );
            $record = current($query);
            return intval($record['num_zones']);
        }
        
        public static function get_by_zone_country_id(int $country_id, array $select_fields = []):array{
            $items = [];
            $select_field_string = '*';
            if(sizeOf($select_fields)){
                    $select_field_string = implode(',',$select_fields);
            }
            $query = yes_query(sprintf(
                "SELECT %s FROM %s WHERE zone_country_id=:country_id",
                    $select_field_string, self::TABLE_NAME
                ),['country_id'=>$country_id]
            );
            if(!sizeOf($query)){
                return $items;
            }
            foreach($query as $record){
                $items[] = new self(self::convert_values($record,self::$propertyTypes));
            }
            return $items;
        }
        
        public static function is_module_payment_zone_valid(int $geo_zone_id, int $zone_country_id, int $zone_id):bool{
            $items = self::get_by_geo_zone_id_and_zone_country_id(
                $geo_zone_id,
                $zone_country_id,[
                    'zone_id'
                ]
            );
            foreach($items as $check) {
                if(intval($check->zone_id) < 1) {
                    return true;
                }elseif(intval($check->zone_id) == $zone_id) {
                    return true;
                }
            }
            return false;
        }
}
