<?php
/**
 * PrintOption
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Amazon Shipping API
 *
 * The Amazon Shipping API is designed to support outbound shipping use cases both for orders originating on Amazon-owned marketplaces as well as external channels/marketplaces. With these APIs, you can request shipping rates, create shipments, cancel shipments, and track shipments.
 *
 * The version of the OpenAPI document: v2
 * Contact: swa-api-core@amazon.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\ShippingV2;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;

/**
 * PrintOption Class Doc Comment
 *
 * @category Class
 * @description The format options available for a label.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class PrintOption extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'PrintOption';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'supported_dpis' => 'int[]',
        'supported_page_layouts' => 'string[]',
        'supported_file_joining_options' => 'bool[]',
        'supported_document_details' => '\SellingPartnerApi\Model\ShippingV2\SupportedDocumentDetail[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'supported_dpis' => null,
        'supported_page_layouts' => null,
        'supported_file_joining_options' => null,
        'supported_document_details' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'supported_dpis' => 'supportedDPIs',
        'supported_page_layouts' => 'supportedPageLayouts',
        'supported_file_joining_options' => 'supportedFileJoiningOptions',
        'supported_document_details' => 'supportedDocumentDetails'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'supported_dpis' => 'setSupportedDpis',
        'supported_page_layouts' => 'setSupportedPageLayouts',
        'supported_file_joining_options' => 'setSupportedFileJoiningOptions',
        'supported_document_details' => 'setSupportedDocumentDetails'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'supported_dpis' => 'getSupportedDpis',
        'supported_page_layouts' => 'getSupportedPageLayouts',
        'supported_file_joining_options' => 'getSupportedFileJoiningOptions',
        'supported_document_details' => 'getSupportedDocumentDetails'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['supported_dpis'] = $data['supported_dpis'] ?? null;
        $this->container['supported_page_layouts'] = $data['supported_page_layouts'] ?? null;
        $this->container['supported_file_joining_options'] = $data['supported_file_joining_options'] ?? null;
        $this->container['supported_document_details'] = $data['supported_document_details'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        if ($this->container['supported_page_layouts'] === null) {
            $invalidProperties[] = "'supported_page_layouts' can't be null";
        }
        if ($this->container['supported_file_joining_options'] === null) {
            $invalidProperties[] = "'supported_file_joining_options' can't be null";
        }
        if ($this->container['supported_document_details'] === null) {
            $invalidProperties[] = "'supported_document_details' can't be null";
        }
        return $invalidProperties;
    }


    /**
     * Gets supported_dpis
     *
     * @return int[]|null
     */
    public function getSupportedDpis()
    {
        return $this->container['supported_dpis'];
    }

    /**
     * Sets supported_dpis
     *
     * @param int[]|null $supported_dpis A list of the supported DPI options for a document.
     *
     * @return self
     */
    public function setSupportedDpis($supported_dpis)
    {
        $this->container['supported_dpis'] = $supported_dpis;

        return $this;
    }
    /**
     * Gets supported_page_layouts
     *
     * @return string[]
     */
    public function getSupportedPageLayouts()
    {
        return $this->container['supported_page_layouts'];
    }

    /**
     * Sets supported_page_layouts
     *
     * @param string[] $supported_page_layouts A list of the supported page layout options for a document.
     *
     * @return self
     */
    public function setSupportedPageLayouts($supported_page_layouts)
    {
        $this->container['supported_page_layouts'] = $supported_page_layouts;

        return $this;
    }
    /**
     * Gets supported_file_joining_options
     *
     * @return bool[]
     */
    public function getSupportedFileJoiningOptions()
    {
        return $this->container['supported_file_joining_options'];
    }

    /**
     * Sets supported_file_joining_options
     *
     * @param bool[] $supported_file_joining_options A list of the supported needFileJoining boolean values for a document.
     *
     * @return self
     */
    public function setSupportedFileJoiningOptions($supported_file_joining_options)
    {
        $this->container['supported_file_joining_options'] = $supported_file_joining_options;

        return $this;
    }
    /**
     * Gets supported_document_details
     *
     * @return \SellingPartnerApi\Model\ShippingV2\SupportedDocumentDetail[]
     */
    public function getSupportedDocumentDetails()
    {
        return $this->container['supported_document_details'];
    }

    /**
     * Sets supported_document_details
     *
     * @param \SellingPartnerApi\Model\ShippingV2\SupportedDocumentDetail[] $supported_document_details A list of the supported documented details.
     *
     * @return self
     */
    public function setSupportedDocumentDetails($supported_document_details)
    {
        $this->container['supported_document_details'] = $supported_document_details;

        return $this;
    }
}


