<?php
if (version_compare(phpversion(), '7.0', '<')) {
    require_once(dirname(__FILE__).DIRECTORY_SEPARATOR.'class.ebay_auction_variation.php');
}else{
    require_once(realpath(__DIR__).DIRECTORY_SEPARATOR.'class.ebay_auction_variation.php');
}
class ebay_auction extends ebay_item{
	var $id;
	var $ebay_products_id;
	var $ebay_id;
	var $products_id;
	var $start_time;
	var $end_time;
	var $auction_fees;
	var $current_auctionprice;
	var $quantity_sold;
	var $cronstart;
	var $status;
	var $not_valid;
	var $is_automatic;
	var $is_personal_offer;
	var $select_set;
	var $select_set_multiple;
	var $sql_array;
	var $locked;
	var $revise_counter;
        var $variations;

	function __construct($ebay_auction_id){
		$ea = \YES4Trade\Model\ebay_auctions::get_by_id(intval($ebay_auction_id));
		if($ea === null){
			return false;
		}
		$ebay_auction = $ea->toArray();
		$this->setId($ebay_auction_id);
                
		$this->load_variations();
		$this->setSQLArray($ebay_auction);

		$this->setEbayProductsId($ebay_auction['ebay_products_id']);
		$this->setProductsId($ebay_auction['products_id']);
		$this->setEbayId($ebay_auction['ebay_id']);
		$this->setStartTime($ebay_auction['start_time']);
		$this->setEndTime($ebay_auction['end_time']);
		$this->setAuctionFees($ebay_auction['auction_fees']);
		$this->setCurrentAuctionprice($ebay_auction['current_auctionprice']);
		$this->setQuantitySold($ebay_auction['quantity_sold']);
		$this->setCronstart($ebay_auction['cronstart']);
		$this->setNotValid($ebay_auction['not_valid']);
		$this->setIsAutomatic($ebay_auction['is_automatic']);
		$this->setIsPersonalOffer($ebay_auction['is_personal_offer']);
		$this->setSelectSet($ebay_auction['select_set']);
		$this->setSelectSetMultiple($ebay_auction['select_set_multiple']);
		$this->setStatus($ebay_auction['status']);

		$this->setType($ebay_auction['type']);
		$this->setAuctionprice($ebay_auction['auctionprice']);
		$this->setBuyitnowprice($ebay_auction['buyitnowprice']);
		$this->setGallery($ebay_auction['gallery']);
		$this->setGalleryPlus($ebay_auction['gallery_plus']);
		$this->setGalleryfeatured($ebay_auction['galleryfeatured']);
		$this->setGalleryfeaturedDuration($ebay_auction['galleryfeaturedduration']);
		$this->setTitle($ebay_auction['title']);
		$this->setCounter($ebay_auction['counter']);
		$this->setSubtitletext($ebay_auction['subtitletext']);
		$this->setDescription($ebay_auction['description']);
		$this->setPicture($ebay_auction['picture']);
		$this->setCategory($ebay_auction['category']);
		$this->setCategory2($ebay_auction['category2']);
		$this->setDuration($ebay_auction['duration']);
		$this->setQuantity($ebay_auction['quantity']);
		$this->setShopcat($ebay_auction['shopcat']);
		$this->setShopcat2($ebay_auction['shopcat2']);
		$this->setVat($ebay_auction['vat']);
		$this->setGeldzurueck($ebay_auction['geldzurueck']);
		$this->setSofortneu($ebay_auction['sofortneu']);
		$this->setNew($ebay_auction['new']);
		$this->setBestoffer($ebay_auction['bestoffer']);
		$this->setBestofferPrice($ebay_auction['bestoffer_price']);
		$this->setSite($ebay_auction['site']);
		$this->setCountry($ebay_auction['country']);
		$this->setLocation($ebay_auction['location']);
		$this->setPaymentinstructions($ebay_auction['paymentinstructions']);
		$this->setUser($ebay_auction['user']);
		$this->setBestOfferAutoAcceptPrice($ebay_auction['bestofferautoacceptprice']);
		$this->setUUID($ebay_auction['UUID']);
		$this->setRevise($ebay_auction['revise']);
		$this->setReviseOption($ebay_auction['revise_option']);
		$this->setExternalProductID($ebay_auction['external_product_id']);
		$this->setExternalProductIDType($ebay_auction['external_product_id_type']);
		$this->setPostalcode($ebay_auction['postalcode']);
		$this->setDispatchtimemax($ebay_auction['dispatchtimemax']);
		$this->setLocked($ebay_auction['locked']);
		$this->setItemcondition($ebay_auction['itemcondition']);
		$this->setReviseCounter($ebay_auction['revise_counter']);
		$this->setShippingDiscountProfileID($ebay_auction['ShippingDiscountProfileID']);
		$this->setInternationalShippingDiscountProfileID($ebay_auction['InternationalShippingDiscountProfileID']);
		$this->setReserveprice($ebay_auction['reserveprice']);
                $this->setReturnswithincode($ebay_auction['returnswithincode']);
                $this->setShippingcostpaidby($ebay_auction['shippingcostpaidby']);
		$this->setEan($ebay_auction['ean']);
		$this->setIsbn($ebay_auction['isbn']);
		$this->setEBayPlus($ebay_auction['ebay_plus']);
		$this->setSeller_profile_payment_id($ebay_auction['seller_profile_payment_id']);
		$this->setSeller_profile_return_policy_id($ebay_auction['seller_profile_return_policy_id']);
		$this->setSeller_profile_shipping_id($ebay_auction['seller_profile_shipping_id']);
                $this->setProductReferenceID($ebay_auction['ProductReferenceID']);
                $this->setScheduleTime($ebay_auction['scheduletime']);
	}

	private function load_variations(){
		$eav_list = \YES4Trade\Model\ebay_auctions_variations::get_by_ebay_auctions_id(intval($this->getId()),[
			'ebay_auctions_variations_id'
		]);
		$v_nr = 0;
		foreach($eav_list as $eav){
			$ev = new ebay_auction_variation(intval($eav->ebay_auctions_variations_id));
			$this->setVariations($ev,$v_nr);
			$v_nr++;
		}
	}

	function get_characteristics_saved($category_number){
		$query = xtc_db_query("SELECT ebay_auctions_characteristics_id FROM ebay_auctions_characteristics WHERE ebay_auctions_id='".$this->getId()."' and category_number='".$category_number."'");
		if(xtc_db_num_rows($query)){
			return true;
		}else{
			return false;
		}
	}

	function setId($value){
		$this->id = $value;
	}

	function getId(){
		return $this->id;
	}

	function setEbayProductsId($value){
		$this->ebay_products_id = $value;
	}

	function getEbayProductsId(){
		return $this->ebay_products_id;
	}

	function setEbayId($value){
		$this->ebay_id = $value;
	}

	function getEbayId(){
		return $this->ebay_id;
	}

	function setProductsId($value){
		$this->products_id = $value;
	}

	function getProductsId(){
		return $this->products_id;
	}

	function setStartTime($value){
		$this->start_time = $value;
	}

	function getStartTime(){
		return $this->start_time;
	}

	function setEndTime($value){
		$this->end_time = $value;
	}

	function getEndTime(){
		return $this->end_time;
	}

	function setAuctionFees($value){
		$this->auction_fees = $value;
	}

	function getAuctionFees(){
		return $this->auction_fees;
	}

	function setCurrentAuctionprice($value){
		$this->current_auctionprice = $value;
	}

	function getCurrentAuctionprice(){
		return $this->current_auctionprice;
	}

	function setQuantitySold($value){
		$this->quantity_sold = $value;
	}

	function getQuantitySold(){
		return $this->quantity_sold;
	}

	function setCronstart($value){
		$this->cronstart = $value;
	}

	function getCronstart(){
		return $this->cronstart;
	}

	function setStatus($value){
		$this->status = $value;
	}

	function getStatus(){
		return $this->status;
	}

	function setNotValid($value){
		$this->not_valid = $value;
	}

	function getNotValid(){
		return $this->not_valid;
	}

	function setIsAutomatic($value){
		$this->is_automatic = $value;
	}

	function getIsAutomatic(){
		return $this->is_automatic;
	}

	function setIsPersonalOffer($value){
		$this->is_personal_offer = $value;
	}

	function getIsPersonalOffer(){
		return $this->is_personal_offer;
	}

	function setSelectSet($value){
		$this->select_set = $value;
	}

	function getSelectSet(){
		return $this->select_set;
	}

	function setSelectSetMultiple($value){
		$this->select_set_multiple = $value;
	}

	function getSelectSetMultiple(){
		return $this->select_set_multiple;
	}

	function getLocked() {
		return $this->locked;
	}

	function setLocked($locked) {
		$this->locked = $locked;
	}


	function setReviseCounter($value){
		$this->revise_counter = $value;
	}

	function getReviseCounter(){
		return $this->revise_counter;
	}


	function setSQLArray($value){
		$this->sql_array = $value;
	}

	function getSQLArray(){
		return $this->sql_array;
	}

        function getVariations() {
            return $this->variations;
        }

        function setVariations($variations,$index = -1) {
            if(!is_array($this->variations)){
                $this->variations = array();
            }
            if($index >= 0){
                $this->variations[$index] = $variations;
                return true; 
            }
            if(is_array($variations)){
                $this->variations = $variations;
            }elseif(is_object($variations)){
                $this->variations[] = $variations;
            }
        }

        
	function getSmartyListArray($SQ,$actions,$checked=false){
		global $_YES_auction_types;
		$auction = array();
		$auction['auctions_link']='';
		$auction['sammler_id']='';
		$auction['ifilter_format_link']='';
		$auction['ifilter_user_link']='';
		$auction['ifilter_counter_link']='';
		$auction['qty_link']='';
		$auction['runnings']='';
		$auction['variation_sets']='';
		$auction['scheduletime']='';
		$auction['ebay_product_template']='';
		$auction['sammler_titel']='';
		$auction['products_id']='';
		$auction['products_id_link']='';
		
		$auction['SPECIAL_EBAY_REVISES']='';
		$auction['buyitnowprice_revise']='';
		$auction['has_properties']='';
		$auction['add_staffelpreise_as_variation']='';
                
		$EA = new EbayAPI;
		$model_query = xtc_db_query("SELECT products_model FROM products WHERE products_id='".$this->getProductsId()."'");
		$model = xtc_db_fetch_array($model_query);
		if(is_array($model)){
			$auction['products_model'] = xtc_db_prepare_input($model['products_model']);
		}else{
			$auction['products_model'] = '';
		}
		$auction['id'] = $this->getId();
		$EA->get_shippingcosts_value('auction',$item_shippingcosts,$this->getId());
		$anzahl_shippingmethods = $EA->get_shippingcosts_count($item_shippingcosts);
		$auction['shippingmethods_link'] = "<a href='".xtc_href_link('ebayapi_shippingcosts.php',xtc_get_all_get_params(array('source','id','action')).'source=auction&id='.$this->getId())."'><u>".$anzahl_shippingmethods." Versandmethoden</u></a>";
		//$auction['products_id_link'] = "<a href='#' onClick='window.open(\"".xtc_href_link('categories.php','action=new_product&pID='.$this->getProductsId().'&cPath='.xtc_get_product_path($this->getProductsId()))."\",\"popup\",\"width=".EXT_POPUP_WIDTH.",height=".EXT_POPUP_WIDTH.",resizable=yes,scrollbars=yes\");'><u>".$this->getProductsId()."</u></a>";
		if($this->getProductsId() > 0){
		    $auction['products_id_link'] = '<a title="Info pID '.$this->getProductsId().'" href="javascript:;" class="yes_dynamic_tooltip" rel="products.php?action=ajax_view&pID='.$this->getProductsId().'">';
		    $auction['products_id'] = $this->getProductsId();
		}

		$auction['ebay_products_id'] = $this->getEbayProductsId();
		$auction['id'] = $this->getId();
		if($SQ !== Null){
			$auction['products_at_ebay'] = $SQ->get_auction_qty();
		}else{
			$auction['products_at_ebay'] = 0;
		}

		$collies = xtc_get_product_collies($this->getProductsId());
		if(sizeOf($collies)>0){
			$avqty = xtc_get_product_collie_qty($this->getProductsId());
			if($SQ !== Null){
				$auction['products_at_ebay'] = $SQ->get_set_auction_qty();
			}else{
				$auction['products_at_ebay'] = 0;
			}
		}else{
			if($SQ !== Null){
				$avqty = $SQ->get_available2_qty();
			}else{
				$avqty = 0;
			}
		}
		$auction['products_bestand'] = "<a href='#' onClick='window.open(\"".xtc_href_link('products.php','action=bestand&pID='.$this->getProductsId())."\",\"popup\",\"width=".EXT_POPUP_WIDTH."px,height=".EXT_POPUP_HEIGHT."px,scrollbars=yes,resizable=yes\");'><u>". $avqty.'</u></a>';
		if($SQ !== Null){
			$auction['v1'] = (int)$SQ->get_available1_qty();
		}else{
			$auction['v1'] = 0;
		}


		if(!strstr($this->getPicture(),'http:'))
			$auction['products_image_src'] = DIR_WS_CATALOG.'images/product_images/thumbnail_images/'.$this->getPicture();
		else
			$auction['products_image_src'] = $this->getPicture();
		$auction['products_image_alt'] = str_replace('"',"'",$this->getTitle());
                //$auction['products_image_src_error'] = '';
                
		$auction['checkbox'] = xtc_draw_checkbox_field("id[]", $this->getId(), false);
		$auction['template'] = 'bereits gespeichert';
		$auction['startprice'] = number_format($this->getAuctionprice(),2,',','');
		$auction['reserveprice'] = number_format($this->getReserveprice(),2,',','');
		if($this->getStatus() == 0){
                    $auction['startprice_revise'] = 1;
                    $auction['revise_link_price'] = xtc_href_link('ebayapi_cart.php',xtc_get_all_get_params(array('action','id','type')).'action=revise&id='.$this->getId().'&type=price');
		}
		
		
		$auction['binprice'] = number_format($this->getBuyitnowprice(),2,',','');
		if($this->getStatus() == 0 and ($this->getType() == 'Chinese' or $this->getType() == 'Dutch' ) ){
			$auction['buyitnowprice_revise'] = 1;
			$auction['revise_link_buyitnowprice'] = xtc_href_link('ebayapi_cart.php',xtc_get_all_get_params(array('action','id','type')).'action=revise&id='.$this->getId().'&type=buyitnowprice');
		}
		$auction['is_personal_offer'] = $this->getIsPersonalOffer();
                if($this->getCronstart() != '0000-00-00 00:00:00'){
        		$auction['cronstart'] = str_replace(' ','<br />',date('d.m.y h:m',strtotime($this->getCronstart())));
                }else{
        		$auction['cronstart'] = '';
                }
                
		$auction['ebay_id'] = '<a target="_blank" href="'.xtc_get_ebay_link($EA->get_site_id_from_name($this->getSite())).$this->getEbayId().'"><u>'.$this->getEbayId().'</u></a>';
					
		$auction['site'] = $this->getSite();
		$auction['bestofferautoacceptprice'] = ($this->getBestoffer() == 1) ? $this->getBestOfferAutoAcceptPrice() : 0;
		$auction['bestoffer_price'] = ($this->getBestoffer() == 1) ? $this->getBestOfferPrice() : 0;
		if($this->getStatus() == 0 and $this->getBestoffer() == 1){
			$auction['revise_link_bestoffer'] = xtc_href_link('ebayapi_cart.php',xtc_get_all_get_params(array('action','id','type')).'action=revise&id='.$this->getId().'&type=bestoffer');
		}
		
						
		$color = ( $this->getShopcat() == 0 ) ? '<font color="#b9b9b9">' : '';
		$color_end = ( $this->getShopcat() == 0 ) ? '</font>' : '';
		$auction['shopcat'] = '<a href="#" onClick="choose_ebayshopcat(\''.xtc_href_link('ebayapi_ebayshop_popup.php','pID='.$this->getEbayProductsId().'&second=0&noedit=1').'\');"><u>'.$color.'Shop'.$color_end.'</u></a>';

		$color = ( $this->getShopcat2() == '' ) ? '<font color="#b9b9b9">' : '';
		$color_end = ( $this->getShopcat2() == '' ) ? '</font>' : '';
		$auction['shopcat2'] = '<a href="#" onClick="choose_ebayshopcat(\''.xtc_href_link('ebayapi_ebayshop_popup.php','pID='.$this->getEbayProductsId().'&second=1&noedit=1').'\');"><u>'.$color.'Shop 2'.$color_end.'</u></a>';

		$color = ( $this->getCategory() == 0 ) ? '<font color="#b9b9b9">' : '';
		$color_end = ( $this->getCategory() == 0 ) ? '</font>' : '';
		$auction['cat1'] = '<a href="#" onClick="window.open(\''.xtc_href_link('ebayapi_cart.php','action=cat_pop&id='.$this->getEbayProductsId()).'\',\'popup\',\'width='.EXT_POPUP_WIDTH.'px,height='.EXT_POPUP_HEIGHT.'px,scrollbars=yes,resizable=yes\');">'.$color.'<u>Kategorie</u>'.$color_end.'</a>';
					
		$color = ( $this->getCategory2() == 0 ) ? '<font color="#b9b9b9">' : '';
		$color_end = ( $this->getCategory2() == 0 ) ? '</font>' : '';
		$auction['cat2'] = '<a href="#" onClick="window.open(\''.xtc_href_link('ebayapi_cart.php','action=cat_pop2&id='.$this->getEbayProductsId()).'\',\'popup\',\'width='.EXT_POPUP_WIDTH.'px,height='.EXT_POPUP_HEIGHT.'px,scrollbars=yes,resizable=yes\');">'.$color.'<u>Kateg.&nbsp;2</u>'.$color_end.'</a>';
					
		$auction['format'] = $_YES_auction_types[$this->getType()];
					
		$auction['title'] = $this->getTitle();
		$auction['subtitle'] = $this->getSubtitletext();
		$auction['duration'] = $this->getDurationTitle();
		$auction['qty'] = $this->getQuantity();
		$auction['qty_sold'] = $this->getQuantitySold();
		if($this->getStatus() == 0){
			$auction['qty_revise'] = 1;
			$auction['revise_link_qty'] = xtc_href_link('ebayapi_cart.php',xtc_get_all_get_params(array('action','id','type')).'action=revise&id='.$this->getId().'&type=qty');
		}
                
		$auction['starttime'] = date("d.m.Y h:m", strtotime($this->getStartTime()));
		$auction['endtime'] = date("d.m.Y h:m", strtotime($this->getEndTime()));
		$auction['gallery'] = $this->getGallery();
		$auction['gallery_plus'] = $this->getGalleryPlus();
		$auction['galleryfeatured'] = $this->getGalleryfeatured();
		$auction['galleryfeaturedduration'] = $this->getGalleryfeaturedDuration();
				
		$format_counter_text = 'Besucherzaehler';
		$auction['counter'] = ($this->getCounter()!='NoHitCounter')?xtc_image('images/ebay_img/counter.gif',$format_counter_text):xtc_image('images/ebay_img/counter_no.gif',$format_counter_text);
				
		$format_vat_text = 'MwSt. in Auktion ausweisen';
		$auction['vat'] = ($this->getVat()>0)?xtc_image('images/ebay_img/mwst.gif',$format_vat_text):xtc_image('images/ebay_img/mwst_no.gif',$format_vat_text);
				
		$format_vat_text = '14 Tage Rueckgaberecht';
		$format_moneyback_text = 'Geld zurueck';
		$auction['moneyback'] = ($this->getGeldzurueck()>0)?xtc_image('images/ebay_img/rueckgabe.gif',$format_moneyback_text):xtc_image('images/ebay_img/rueckgabe_no.gif',$format_moneyback_text);
				
		$format_sofortneu_text = 'Sofort + Neu';
		$auction['sofortneu'] = ($this->getSofortneu()>0)?xtc_image('images/ebay_img/sofortneu.gif',$format_sofortneu_text):xtc_image('images/ebay_img/sofortneu_no.gif',$format_sofortneu_text);
				
		$format_neu_text = 'Neu';
		$auction['neu'] = ($this->getNew()>0)?xtc_image('images/ebay_img/neu.gif',$format_neu_text):xtc_image('images/ebay_img/neu_no.gif',$format_neu_text);
				
		$auction['user'] = $this->getUser();
		$auction['select_set'] = $this->getSelectSet();
		$auction['select_set_multiple'] = $this->getSelectSetMultiple();
		$auction['popup_products_at_ebay_link'] = '<a href="javascript:void( window.open(\''.xtc_href_link('ebayapi_cart.php','action=products_at_ebay&pID='.$this->getProductsId()).'\',\'popup\',\'width='.EXT_POPUP_WIDTH.',height='.EXT_POPUP_HEIGHT.',scrollbars=yes,resizable=yes\') );">';
                /** WIRD NIRGENDS VERWENDET - 2023/11
		if($this->getCategory() != 0){
			$style = ($this->get_characteristics_saved(1) == true) ? 'style="font-weight:bold;"' : '';
			if($this->getStatus() == 1){
				$auction['edit_characteristics_link_1'] = '<a '.$style.' href="javascript:void( window.open(\''.xtc_href_link('ebayapi_cart.php','action=category_characteristics&category_number=1&id='.$this->getId().'&from=auction').'\',\'popup\',\'width='.EXT_POPUP_WIDTH.',height='.EXT_POPUP_HEIGHT.',scrollbars=yes,resizable=yes\') );">';
			}else{
				$auction['edit_characteristics_link_1'] = '<a '.$style.' href="javascript:alert( \'Laufende Auktion, nicht editierbar.\' );">';
			}
		}
		if($this->getCategory2() != 0){
			$style = ($this->get_characteristics_saved(2) == true) ? 'style="font-weight:bold;"' : '';
			if($this->getStatus() == 1){
				$auction['edit_characteristics_link_2'] = '<a '.$style.' href="javascript:void( window.open(\''.xtc_href_link('ebayapi_cart.php','action=category_characteristics&category_number=2&id='.$this->getId().'&from=auction').'\',\'popup\',\'width='.EXT_POPUP_WIDTH.',height='.EXT_POPUP_HEIGHT.',scrollbars=yes,resizable=yes\') );">';
			}else{
				$auction['edit_characteristics_link_2'] = '<a '.$style.' href="javascript:alert( \'Laufende Auktion, nicht editierbar.\' );">';
			}
		}**/
                
		$auction['revise'] = $this->getRevise();
		$auction['revise_option'] = $this->getReviseOption();
		$auction['revise_text'] = sprintf(TEXT_REVISE_AUTOMATIC,$this->getReviseOption());
		$auction['postalcode'] = $this->getPostalcode();
		$auction['dispatchtimemax'] = $this->getDispatchtimemax();
		$auction['locked'] = $this->getLocked();
		$auction['itemcondition'] = $this->getItemcondition();
		$auction['variations_sets_id'] = $this->get_variations_sets_id_from_ebay_products_id($this->getEbayProductsId());
		$auction['ShippingDiscountProfileID'] = $this->getShippingDiscountProfileID();
		$auction['InternationalShippingDiscountProfileID'] = $this->getInternationalShippingDiscountProfileID();
		$cID = xtc_get_site_country_id($this->getSite());
		$lID = xtc_is_language_installed($cID);
                
		if(!$lID){
			$lID = '2';
		}
		$auction['properties'] = $this->get_properties_from_id('ebay_auctions',$this->getId(),$lID);
                $auction['returnswithincode'] = $this->getReturnswithincode();
                $auction['shippingcostpaidby'] = $this->getShippingcostpaidby();
		if($this->get_properties_count_from_id('ebay_auctions',$this->getId())){
		    $auction['has_properties'] = true;
		}
		$auction['auction_status'] = $this->getStatus();
		$auction['ebay_auctions_id'] = $this->getId();
		$auction['ean'] = $this->getEan();
		$auction['isbn'] = $this->getIsbn();
		if($this->getEbayProductsId() > 0){
		    $ep_query = xtc_db_query(sprintf(
			    "SELECT ebay_sammler_id FROM ebay_products WHERE id='%s'",
			    $this->getEbayProductsId()
		    ));
		    if(xtc_db_num_rows($ep_query)){
			$ep_res = xtc_db_fetch_array($ep_query);
			$auction['sammler_titel'] = $EA->getSammlerTitel($ep_res['ebay_sammler_id']);
		    }
		}
		$auction['ebay_plus'] = $this->getEBayPlus();
                $auction['ProductReferenceID'] = $this->getProductReferenceID();
                if($this->getScheduleTime() != '' and $this->getScheduleTime() != '0000-00-00 00:00:00'){
                    $time = strtotime($this->getScheduleTime());
                    if($time > time()){
                        $auction['scheduletime'] = date('d.m.Y H:i:s',$time);
                    }
                }
		
		return $auction;
	}

	function delete(){
		\YES4Trade\Model\ebay_auctions::delete(intval($this->getId()));
		xtc_db_query(sprintf(
			"DELETE FROM ebay_auctions_payments WHERE ebay_auctions_id='%s'",
			$this->getId()
		));
		xtc_db_query(sprintf(
			"DELETE FROM ebay_auctions_itemspecifics WHERE ebay_auctions_id='%s'",
			$this->getId()
		));
		xtc_db_query(sprintf(
			"DELETE FROM ebay_auctions_characteristics WHERE ebay_auctions_id='%s'",
			$this->getId()
		));
		xtc_db_query(sprintf(
			"DELETE FROM specials_ebay_revise WHERE ebay_auctions_id='%s'",
			$this->getId()
		));

		// GET SHIPPING IDs AND DELETE ALLOCATED LOCATIONS
		$shippingmethods_query = xtc_db_query(sprintf(
			"SELECT ebay_auctions_shippings_id FROM ebay_auctions_shippings
			 WHERE ebay_auctions_id='%s'",
			$this->getId()
		));
		while($shippingmethods = xtc_db_fetch_array($shippingmethods_query)){
			xtc_db_query(sprintf(
				"DELETE FROM ebay_auctions_shippings_locations
				 WHERE ebay_auctions_shippings_id='%s'",
				$shippingmethods['ebay_auctions_shippings_id']
			));
		}
		
		xtc_db_query(sprintf(
			"DELETE FROM ebay_auctions_shippings WHERE ebay_auctions_id='%s'",
			$this->getId()
		));
		foreach($this->getVariations() as $ev){
			$ev->delete($this->getStatus());
		}
		\YES4Trade\Model\ebay_auctions_price_revise_auctions::delete_by_ebay_auctions_id(intval($this->getId()));

		xtc_db_query(sprintf(
			"INSERT INTO ebay_auctions_deleted SET products_id='%d',ebay_products_id='%d',datum=now();",
				$this->getProductsId(),
				$this->getEbayProductsId()
		));
		if(!is_countable($this->getVariations()) or !sizeOf($this->getVariations())){
			$log_qty = $this->getQuantity();
			if($this->getSelectSetMultiple() > 0 ){
				$log_qty = $log_qty * $this->getSelectSetMultiple();
			}
                        // 09/2017 Statuspruefung von 1 auf 0 gesetzt
			if($this->getStatus() == 0){
				yes_update_products_in_auction_quantity($this->getProductsId(),
					yes_products_calc_in_auction_quantity(intval($this->getProductsId())),
					sprintf('Auktion %s entfernt (%s Stk).',$this->getEbayId(),$log_qty),
					true // overwrite!
				);
			}
		}
                
                $ee = \YES4Trade\Model\ebay_auctions_energy_efficiency::get_by_ebay_auctions_id($this->getId());
                if($ee != null){
                    \YES4Trade\Model\ebay_auctions_energy_efficiency::delete($ee->ebay_auctions_energy_efficiency_id);
                }
                $ma = \YES4Trade\Model\ebay_auctions_manufacturer::get_by_ebay_auctions_id($this->getId());
                if($ma !== null){
					try{
						if(intval($ma->ebay_auctions_manufacturers_id)>0){
                    		\YES4Trade\Model\ebay_auctions_manufacturer::delete($ma->ebay_auctions_manufacturers_id);
						}
					}catch(Exception $e){
						// 10/25 behoben. ich habe ebay_auctions_manufacturer_id 
						// statt ebay_auctions_manufacturers_id geprueft
						yes_mail_debug('Seltsamer Fehler. Ich pruefe ob ma == null aber erhalte kein ebay_auctions_manufacturers_id. Hier das ma Objekt:'."\n".print_r($ma,true)."\n\nFehlermeldung: ".$e->getMessage());
					}
                }
                $ps = \YES4Trade\Model\ebay_auctions_productsafety::get_by_ebay_auctions_id($this->getId());
                if($ps !== null){
                    \YES4Trade\Model\ebay_auctions_productsafety::delete($ps->ebay_auctions_productsafety_id);
                }
                $rds = \YES4Trade\Model\ebay_auctions_regulatory_documents::get_by_ebay_auctions_id($this->getId());
                foreach($rds as $rd){
                    \YES4Trade\Model\ebay_auctions_regulatory_documents::delete($rd->ebay_auctions_regulatory_documents_id);
                }
                $hz = \YES4Trade\Model\ebay_auctions_regulatory_hazmats::get_by_ebay_auctions_id($this->getId());
                if($hz !== null){
                    \YES4Trade\Model\ebay_auctions_regulatory_hazmats::delete($hz->ebay_auctions_regulatory_hazmats_id);
                }
                $rps = \YES4Trade\Model\ebay_auctions_responsible_persons::get_by_ebay_auctions_id($this->getId());
                foreach($rps as $rp){
                    \YES4Trade\Model\ebay_auctions_responsible_persons::delete($rp->ebay_auctions_responsible_persons_id);
                }
                
                $vide = \YES4Trade\Model\ebay_auctions_videos::get_by_ebay_auctions_id($this->getId());
                foreach($vide as $video){
                    \YES4Trade\Model\ebay_auctions_videos::delete($video->ebay_auctions_videos_id);
                }
                
	}

	function get_new_auction_sql_from_item(){
		$auction_sql_array = array(
			'ebay_products_id' => $this->getEbayProductsId(),
			'products_id' => $this->getProductsId(),
			'type' => $this->getType(),
			'auctionprice' => $this->getAuctionprice(),
			'buyitnowprice' => $this->getBuyitnowprice(),
			'title' => $this->getTitle(),
			'subtitletext' => $this->getSubtitletext(),
			'description' => $this->getDescription(),
			'picture' => $this->getPicture(),
			'gallery' => $this->getGallery(),
			'gallery_plus' => $this->getGalleryPlus(),
			'galleryfeatured' => $this->getGalleryfeatured(),
			'galleryfeaturedduration' => $this->getGalleryfeaturedDuration(),
			'shopcat' => $this->getShopcat(),
			'shopcat2' => $this->getShopcat2(),
			'category' => $this->getCategory(),
			'category2' => $this->getCategory2(),
			'duration' => $this->getDuration(),
			'quantity' => $this->getQuantity(),
			'counter' => $this->getCounter(),
			'vat' => $this->getVat(),
			'geldzurueck' => $this->getGeldzurueck(),
			'sofortneu' => $this->getSofortneu(),
			'new' => $this->getNew(),
			'bestoffer' => $this->getBestoffer(),
			'select_set' => $this->getSelectSet(),
			'select_set_multiple' => $this->getSelectSetMultiple(),
			'site' => $this->getSite(),
			'paymentinstructions' => $this->getPaymentinstructions(),
			'bestoffer_price' => $this->getBestofferPrice(),
			'country'=>$this->getCountry(),
			'location'=>$this->getLocation(),
			'bestofferautoacceptprice'=>$this->getBestOfferAutoAcceptPrice(),
			'revise'=>$this->getRevise(),
			'revise_option'=>$this->getReviseOption(),
			'user'=>$this->getUser(),
			'external_product_id'=>$this->getExternalProductID(),
			'external_product_id_type'=>$this->getExternalProductIDType(),
			'postalcode'=>$this->getPostalcode(),
			'dispatchtimemax'=>$this->getDispatchtimemax(),
			'itemcondition'=>$this->getItemcondition(),
			'ShippingDiscountProfileID' => $this->getShippingDiscountProfileID(),
			'reserveprice'=>$this->getReserveprice(),
                        'returnswithincode' => $this->getReturnswithincode(),
                        'shippingcostpaidby' => $this->getShippingcostpaidby(),
		    'ean'=>$this->getEan(),
		    'isbn'=>$this->getIsbn(),
		    'ebay_plus'=>$this->getEBayPlus(),
		    'seller_profile_payment_id'=>$this->getSeller_profile_payment_id(),
		    'seller_profile_shipping_id'=>$this->getSeller_profile_shipping_id(),
		    'seller_profile_return_policy_id'=>$this->getSeller_profile_return_policy_id(),
                    'ProductReferenceID'=>$this->getProductReferenceID(),
                    'scheduletime'=>$this->getScheduleTime(),
		);
		return $auction_sql_array;
	}

        private function parseNameRecommendation($NaRe, $IS = null, $eigeneMerkmale = false){
                $helptext = '';
                if($NaRe->HelpURL != ''){
                    $helptext .= sprintf('<a href="%s" target="_blank">',$NaRe->HelpURL);
                }
                if($NaRe->HelpText != ''){
                    $helptext .= substr($NaRe->HelpText,0,80);
                }else{
                    if($NaRe->HelpURL != ''){
                        $helptext .= '[Link]';
                    }
                }
                if($NaRe->HelpURL != ''){
                    $helptext .= sprintf('</a>');
                }
                $relationship = '';
                if(sizeOf($NaRe->ValidationRules->Relationship)){
                    $relationship .= ' &gt;&nbsp;Abh&auml;ngig von ';
                    $rel_node = array();
                    foreach($NaRe->ValidationRules->Relationship as $Rel){
                        $rel_node[] = sprintf('<i>%s</i>',$Rel->ParentName);
                    }
                    $relationship .= implode(', ',$rel_node);
                }
                $value = '';
                if(strtolower(gettype($IS)) != 'null'){
                    foreach($IS->Item->ItemSpecifics as $NVL){
                        if($NVL->Name == $NaRe->Name){
                            $value = current($NVL->Value);
                            break;
                        }
                    }
                }
                $value_recommendations = array(array('id'=>'','text'=>TEXT_SELECT));
                if($NaRe->ValueRecommendation){
                    foreach($NaRe->ValueRecommendation as $VaRe){
                        $value_recommendations[] = array(
                            'Value'=>$VaRe->Value,
                            'Name'=>sprintf('%s%s%s',
                                    $VaRe->Value,
                                    ($VaRe->ValidationRules->ProductRequired == 'Enabled') ? ' [eBay Katalog Artikel]' : '',
                                    ($VaRe->ValidationRules->RelationShip) ? sprintf(' [Abh&auml;ngig von %s%s]',
                                        $VaRe->ValidationRules->RelationShip->ParentName,
                                        ($VaRe->ValidationRules->RelationShip->ParentValue != '') ? ' '.$VaRe->ValidationRules->RelationShip->ParentValue : ''
                                    ) : ''
                            ),
                            'text'=>$VaRe->Value,
                            'id'=>urldecode($VaRe->Value)
                        );
                    }
                }
                $input = '';
                $input_array = array();
                if($NaRe->ValidationRules->MaxValues == 1){
                    $input = xtc_draw_input_field( 'INPUT['.urlencode($NaRe->Name).']',$value,'id="INPUT_'.urlencode($NaRe->Name).'"' );
                }else{
                    $rec_input_array = array();
		    if($eigeneMerkmale){
	                $input_array[] = array(
	                    'input'=>xtc_draw_input_field( 'INPUT['.urlencode($NaRe->Name).'][]',current($NaRe->Value)),
	                    'value'=>current($NaRe->Value)
	                );
		    }else{
		            foreach($value_recommendations as $val){
			        $checked = ($val['Value'] == $value)?true:false;
			        $input_array[] = array(
			            'input'=>xtc_draw_checkbox_field( 'INPUT['.urlencode($NaRe->Name).'][]',$val['Value'], $checked),
			            'value'=>$val['Value']
			        );
		            }
		    }
                }
                
                return array(
                    'MinValues'=>$NaRe->ValidationRules->MinValues,
                    'PFLICHT'=>($NaRe->ValidationRules->MinValues > 0) ? sprintf(' <span title="%s">*</span>',TEXT_ITEMSPECIFIC_PFLICHTFELD) : '',
                    'max_values'=>$NaRe->ValidationRules->MaxValues,
                    'MaxValueLength'=>$NaRe->ValidationRules->MaxValueLength,
                    'text'=>$NaRe->Name,
                    'HelpText'=>$helptext,
                    'Constraint'=>$NaRe->ValidationRules->Constraint,
                    'ValueType'=>$NaRe->ValidationRules->ValueType,
                    'Relationship'=>$relationship,
                    'value'=>$value,
                    'SelectionMode'=>$NaRe->ValidationRules->SelectionMode,
                    'recommendations'=>$value_recommendations,
                    'VariationSpecifics'=>$NaRe->ValidationRules->VariationSpecifics,
                    'ValueFormat'=>$NaRe->ValidationRules->ValueFormat,
                    'AspectUsage'=>$NaRe->ValidationRules->AspectUsage,
                    'VariationPicture'=>$NaRe->ValidationRules->VariationPicture,
                    'ProductRequired'=>$NaRe->ValidationRules->ProductRequired,
                    'input'=>$input,
                    'input_array' => $input_array,
                );
	}

        public function get_categoryspecifics_input_fields(GetCategorySpecificsResponseType $CS, GetItemResponseType $IS){
            $items = array();
            foreach($CS->Recommendations[0]->NameRecommendation as $NaRe){
		$items[] = $this->parseNameRecommendation($NaRe,$IS);

            }
	    foreach($IS->Item->ItemSpecifics as $NaRe){
		$exists = false;
		foreach($items as $item){
			if($item['text'] == $NaRe->Name){
				$exists = true;
			}
		}
		if(!$exists){
			$items[] = $this->parseNameRecommendation($NaRe,null,true);
		}
	    }
            return $items;
        }

	public function sync_variations_from_getItemResult($res){
		if( gettype($res->Item->Variations) != 'object'){
			return false;
		}
		$this->variations = array();
		foreach($res->Item->Variations->Variation as $V){
			foreach($V->VariationSpecifics as $VS){
				if(!in_array($VS->Name, array(
					MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_VARIATION_NAME_DE,
					MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_VARIATION_NAME_EN
				))){
					continue;
				}
				\YES4Trade\Model\ebay_auctions_variations::update_ebay_auctions_variations_by_ebay_auctions_id_and_sku([
					'quantity'=>(int)$V->Quantity,
					'price'=>(float)$V->StartPrice->value,
					'sku'=>(string)$V->SKU,
					'ebay_auctions_id'=>intval($this->getId())
				]);
				self::add_history($this->getId(), (int)$V->Quantity, sprintf(
						"[%s::sync_variations_from_getItemResult]",
						basename(__FILE__)
				));
			}
		}
		$this->load_variations();
	}
	public function get_staffelpreis_products_id(){
		foreach($this->variations as $variation){
			return $variation->products_id;
		}
		return 0;
	}

    public function get_sdk_recommendations_input_fields( $res, $saved_raw ){
        $saved = array();
        foreach($saved_raw->Item->ItemSpecifics->NameValueList as $NaRe){
			$value = (is_countable($NaRe->Value)) ? current($NaRe->Value) : (string)$NaRe->Value;
            $saved[ "".$NaRe->Name ] = "".$value;
        }
        foreach($res as $rec){
            $values = array(0=>array('id'=>'','text'=>TEXT_SELECT));
            foreach($rec->aspectValues as $av){
                $values[] = array(
                    'id'=>$av->localizedValue,
                    'text'=>$av->localizedValue,
                );
            }
            $pflicht = '';
            if($rec->aspectConstraint->aspectRequired == 1){
                $pflicht = sprintf(' <span title="%s">*</span>',TEXT_ITEMSPECIFIC_PFLICHTFELD);
            }
            if($rec->aspectConstraint->itemToAspectCardinality == 'SINGLE'){
                $value = '';
                if( isset( $saved[ $rec->localizedAspectName ] ) ){
                        $value = $saved[ $rec->localizedAspectName ];
                }
                $input_array[] = array(
                        'text'=>$rec->localizedAspectName,
                        'value'=>$value,
                        'input'=>xtc_draw_input_field( 'INPUT['.urlencode($rec->localizedAspectName).']',$value,'id="INPUT_'.urlencode($rec->localizedAspectName).'"' ),
                        'recommendations'=>$values,
                    'PFLICHT'=>$pflicht,
                    'SelectionMode'=>$rec->aspectConstraint->aspectMode,
                );
            }else{
                $rec_input_array = array();
                foreach($values as $valkey=>$val){
                    if($valkey == 0) continue;
                    $checked = (isset($saved[ $rec->localizedAspectName ]) and is_countable($saved[ $rec->localizedAspectName ]) and in_array($val['id'], $saved[ $rec->localizedAspectName ]))?true:false;
                    $rec_input_array[] = array(
                        'input'=>xtc_draw_checkbox_field( 'INPUT['.urlencode($rec->localizedAspectName).'][]',$val['id'], $checked),
                        'value'=>$val['id']
                    );
                }
                $input_array[] = array(
                        'text'=>$rec->localizedAspectName,
                        'input_array'=>$rec_input_array,
                        'recommendations'=>$values,
                    'max_values'=>(isset($rec->aspectConstraint->aspectMaxLength))?$rec->aspectConstraint->aspectMaxLength:1,
                    'PFLICHT'=>$pflicht,
                    'SelectionMode'=>$rec->aspectConstraint->aspectMode,
                );
            }
        }
        return $input_array;
    }
    
    /**
     * ebay_auction.quantity History
     * 
     * Speichert Historieneintraege wenn Mengen in Auktionen aktualisiert werden
     * Kann irgendwann wieder raus, ist nur zum Finden von Unstimmigkeiten
     * 
     * @param int $ebay_auctions_id
     * @param int $quantity
     * @param string $comments
     */
    public static function add_history( $ebay_auctions_id, $quantity, $comments ){
        $insert_sql_array = array(
            'ebay_auctions_id'=>$ebay_auctions_id,
            'comments'=>$comments,
            'quantity'=>$quantity,
            'date_added'=>'now()'
        );
        xtc_db_perform('ebay_auctions_quantity_history',$insert_sql_array);
    }
}
