<?php
/*
Sean Huber CURL library
Session-based caching added by Mike Purvis

This library is a basic implementation of CURL capabilities.

==================================== USAGE ====================================
It exports the CURL object globally, so set a callback with setCallback($func).
(Use setCallback(array('class_name', 'func_name')) to set a callback as a func
that lies within a different class)
Then use one of the CURL request methods:

get($url);
post($url, $vars); vars is a urlencoded string in query string format.

Your callback function will then be called with 1 argument, the response text.
If a callback is not defined, your request will return the response text.
*/

class CURL {
        var $callback = false, $cache = false, $flush_cache = false;

        function setCallback($func_name) {
                $this->callback = $func_name;
        }

        function enableCache() {
                $this->cache = true;
                if (session_id() == "")
                        session_start();
        }

        function flushCache() {
                unset($_SESSION['curl_cache']);
        }

        function doRequest($method, $url, $vars) {
                if ($this->cache)
                {
                        $cache_key = md5(serialize(func_get_args()));

                        if (!isset($_SESSION['curl_cache'])) $_SESSION['curl_cache'] = array();

                        if (isset($_SESSION['curl_cache'][$cache_key]))
                        {
                                if ($this->callback)
                                {
                                        $callback = $this->callback;
                                        $this->callback = false;
                                        return call_user_func($callback, $_SESSION['curl_cache'][$cache_key]);
                                } else {
                                        return $_SESSION['curl_cache'][$cache_key];
                                }
                        }
                }

                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $url);
                curl_setopt($ch, CURLOPT_HEADER, false);
                curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']);
                curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch, CURLOPT_COOKIEJAR, 'cookie.txt');
                curl_setopt($ch, CURLOPT_COOKIEFILE, 'cookie.txt');

                if ($method == 'POST') {
                        curl_setopt($ch, CURLOPT_POST, 1);
                        curl_setopt($ch, CURLOPT_POSTFIELDS, $vars);
                }
                $data = curl_exec($ch);
                curl_close($ch);

                if ($data) {
                        if ($this->callback)
                        {
                                $callback = $this->callback;
                                $this->callback = false;
                                return call_user_func($callback, $_SESSION['curl_cache'][$cache_key] = $data);
                        } else {
                                return $_SESSION['curl_cache'][$cache_key] = $data;
                        }
                } else {
                        return curl_error($ch);
                }
        }

        function get($url) {
                return $this->doRequest('GET', $url, 'NULL');
        }

        function post($url, $vars) {
                return $this->doRequest('POST', $url, $vars);
        }
}
