<?php
/* --------------------------------------------------------------
   (c) mario aspeleiter 05/2005 <dazze@gmx.de>
   --------------------------------------------------------------*/

  class retoure {
    var $info, $totals, $products, $customer, $delivery, $editor_id;

    function __construct($retoure_id) {
      $this->info = array();
      $this->products = array();
      $this->delivery = array();
      $this->editor_id = $_SESSION['customer_id'];

      $this->query($retoure_id);	
    }

    function query($retoure_id) {
      $retoure_query = xtc_db_query("select *
                                  from retouren r where
                                  retoure_id = '" . xtc_db_input($retoure_id) . "'");

      $retoure = xtc_db_fetch_array($retoure_query);

      $this->info = array(
                          'date_created' => $retoure['date_created'],
                          'retoure_status' => $retoure['retoure_status'],
                          'id' => $retoure['retoure_id'],
                          'orders_id'=>$retoure['orders_id'],
                          'date_initiated' => $retoure['date_initiated'],
                          'costs' => $retoure['costs'],
			  'date_finished' => $retoure['date_finished'],
			  'reclamations_id' => $retoure['reclamations_id'],
			  'versender' => $retoure['versender']);

	// FUER DIE SERIENNUMMERN MUSS GESCHAUT WERDEN WAS FUER EIN TYP DIE REKLAMATION HAT
	// BEI DEFEKT/NEUVERSAND WIRD AUF DIE SN DER BESTELLUNG ZURUECKGEGRIFFEN
	$reclamations_type_query = xtc_db_query("SELECT reclamations_type FROM reclamations WHERE reclamations_id='".$this->info['reclamations_id']."'");
	$reclamations_type = xtc_db_fetch_array($reclamations_type_query);
	$this->info['reclamations_type'] = $reclamations_type['reclamations_type'];

      $this->delivery = array('name' => $retoure['shipping_name'],
                              'company' => $retoure['shipping_company'],
                              'street_address' => $retoure['shipping_street'],
                              'suburb' => $retoure['shipping_street2'],
                              'city' => $retoure['shipping_city'],
                              'postcode' => $retoure['shipping_postcode'],
                              'ID' => $retoure['customers_id'],
                              'country' => $retoure['shipping_country']);

      $index = 0;
      $retoures_products_query = xtc_db_query("select
                                                 retoure_products_id,products_id, products_name, products_model, products_quantity, false_products_id
                                             from
                                                 retoure_products
                                             where
                                                 retoure_id ='" . xtc_db_input($retoure_id) . "'");


    $retoures_products_array = [];
    while ($_retoures_products = xtc_db_fetch_array($retoures_products_query)) {
        $retoures_products_array[] = $_retoures_products;
    }
    
    foreach($retoures_products_array as $retoures_products){
        $this->products[$index] = array(
            'qty' => $retoures_products['products_quantity'],
            'name' => $retoures_products['products_name'],
            'id' => $retoures_products['products_id'],
            'rpID' => $retoures_products['retoure_products_id'],
            'model' => $retoures_products['products_model'],
            'false_products_id'=>$retoures_products['false_products_id'],
        );

        $properties = array();
        $query = xtc_db_query(sprintf(
                "SELECT property_title,property_value,input_span FROM retoure_products_properties WHERE retoure_products_id='%d'",
                $retoures_products['retoure_products_id']
        ));
        while($record = xtc_db_fetch_array($query)){
                $properties[] = $record;
        }
        $this->products[$index]['properties'] = $properties;
		
        $index++;
      }
    }

	function add_history($status_id,$notified,$comments){
		$new = new \YES4Trade\Model\retoure_status_history([
                    'retoure_id'=>(int)$this->info['id'],
                    'retoure_status_id'=>(int)$status_id,
                    'date_added'=>date('Y-m-d H:i:s'),
                    'customer_notified'=>($notified)?1:0,
                    'comments'=>$comments,
                    'editor_id'=>(int)$this->editor_id
                ]);
		$new->create();
	}
  
	public function get_update_address_part_prefix($address_type){
		switch($address_type){
			case 'customer':
				$prefix = 'customers_';
				break;
			case 'shipping':
				$prefix = 'shipping_';
				break;
			case 'invoice':
				$prefix = 'billing_';
				break;
		}
		return $prefix;
	}
	
	public function get_address_part_sql($address_type,$data,$transform_to='',$utf8_decode=true){
		$prefix = $this->get_update_address_part_prefix($address_type);
		$update_sql_array = array();
		$target_key = ($transform_to != '') ? $this->get_update_address_part_prefix($transform_to) : '';
		foreach($data as $key=>$val){
			if(!strstr($key,$prefix) or $key == 'update_customers_name'){
				continue;
			}
			if(strstr($key,'country')){
				if($target_key != ''){
					if($utf8_decode)
						$update_sql_array[ str_replace($prefix,$target_key,$key) ] = yes_decode_string( xtc_get_country_name( $val ) );
					else
						$update_sql_array[ str_replace($prefix,$target_key,$key) ] = xtc_get_country_name( $val );
				}else{
					if($utf8_decode)
						$update_sql_array[ $key ] = yes_decode_string(xtc_get_country_name($val));
					else
						$update_sql_array[ $key ] = xtc_get_country_name($val);
				}
			}else{
				if($target_key != ''){
					if(!strstr($key,'telephone') and !strstr($key,'mobile') and !strstr($key,'vat_id')){
						$update_sql_array[ str_replace($prefix,$target_key,$key) ] = yes_decode_string($val);
					}
				}else{
					$update_sql_array[ $key ] = yes_decode_string($val);
				}
			}
		}
		return $update_sql_array;
	}
	public function update_address_part($update_sql_array){
		foreach($update_sql_array as $key => $val){
			if(mb_detect_encoding($val) == 'UTF-8'){
				//$update_sql_array[ $key ] = utf8_encode($val);
			}
		}
		xtc_db_perform('retouren',$update_sql_array,'update',"retoure_id='".$this->info['id']."'");
	}
        
        public function write_included_products_history(string $comments){
            foreach($this->products as $p){
                product::add_history_static($p['id'], $comments.' [Artikel ist '.$p['qty'].'x in Retoure enthalten]');
            }
        }
}