<?php
require(DIR_WS_CLASSES.'storage_number.php');
require(DIR_WS_CLASSES.'storage_product.php');
require(DIR_WS_CLASSES.'storage_products_transfer.php');
class storage {
	
	var $id;
	var $name;
	var $beschreibung;
	var $schema_key;
	var $schema_start;
	var $default_storage;
	var $storage_numbers;
	
	public function getId() {
		return $this->id;
	}

	public function setId($id) {
		$this->id = $id;
	}

	public function getName() {
		return $this->name;
	}

	public function setName($name) {
		$this->name = $name;
	}

	public function getBeschreibung() {
		return $this->beschreibung;
	}

	public function setBeschreibung($beschreibung) {
		$this->beschreibung = $beschreibung;
	}

	public function getSchema_key() {
		return $this->schema_key;
	}

	public function setSchema_key($schema_key) {
		$this->schema_key = $schema_key;
	}

	public function getSchema_start() {
		return $this->schema_start;
	}

	public function setSchema_start($schema_start) {
		$this->schema_start = $schema_start;
	}

	public function getDefault_storage() {
		return $this->default_storage;
	}

	public function setDefault_storage($default_storage) {
		$this->default_storage = $default_storage;
	}
	
	public function getStorage_numbers() {
		return $this->storage_numbers;
	}

	public function setStorage_numbers($storage_numbers) {
		$this->storage_numbers = $storage_numbers;
	}

	public function __construct($id) {
		$this->setId($id);
		if($this->getId() > 0){
			$query = xtc_db_query(sprintf(
				"SELECT name,beschreibung,schema_key,schema_start,default_storage FROM storages WHERE id=%s",
				$this->getId()
			));
			if(xtc_db_num_rows($query)){
				$record = xtc_db_fetch_array($query);
				$this->setBeschreibung($record['beschreibung']);
				$this->setDefault_storage($record['default_storage']);
				$this->setName($record['name']);
				$this->setSchema_key($record['schema_key']);
				$this->setSchema_start($record['schema_start']);
			}
		}
	}
	
	function getStorage_numbers_from_db(){
		$storage_numbers = array();
		$query = xtc_db_query(sprintf(
			"SELECT id FROM storage_numbers WHERE storage_id=%s",
			$this->getId()
		));
		while($record = xtc_db_fetch_array($query)){
			$storage_numbers[] = new storage_number($record['id']);
		}
		$this->setStorage_numbers($storage_numbers);
	}
	
	public function getStorage_number_by_products_id($pID){
		$query = xtc_db_query(sprintf(
			"SELECT id FROM storage_numbers WHERE products_id=%s AND storage_id=%s",
			$pID,$this->getId()
		));
		$record = xtc_db_fetch_array($query);
		if($record['id'] > 0){
			$storage_number = new storage_number($record['id']);
			return $storage_number;
		}else{
			return -1;
		}
	}
	public function get_storage_places(){
            $storage_places = array();
            $query = xtc_db_query(sprintf(
                    "SELECT storage_places_id,title FROM `storage_places` sp WHERE storage_id='%s' ORDER BY title",
                    $this->getId()
            ));
	    while($record = xtc_db_prepare_input(xtc_db_fetch_array($query))){
		$storage_places[] = array(
		    'id'=>$record['storage_places_id'],
		    'text'=>$record['title']
		);
	    }
	    return $storage_places;
        }
	public function get_storage_places_for_product($pID,$unique_check=false){
	    $storage_places = array();
	    if($unique_check){
		$query = xtc_db_query(sprintf(
			"SELECT storage_places_id,title FROM `storage_places` sp WHERE storage_id='%s' AND storage_places_id NOT IN (SELECT storage_places_id FROM storage_products WHERE storage_id='%s' AND products_id='%s') ORDER BY title",
			$this->getId(),$this->getId(),$pID
		));
	    }else{
		$query = xtc_db_query(sprintf(
			"SELECT storage_places_id,title FROM `storage_places` sp WHERE storage_id='%s' ORDER BY title",
			$this->getId(),$this->getId(),$pID
		));
	    }
	    while($record = xtc_db_prepare_input(xtc_db_fetch_array($query))){
		$storage_places[] = array(
		    'id'=>$record['storage_places_id'],
		    'text'=>$record['title']
		);
	    }
	    return $storage_places;
	}
}
