<?php
class userprofile_emailfilter_addresses_allocation{
    const TABLE_ALLOCATION = 'userprofile_emailfilter_addresses';
    
    var $customers_id;
    var $addresses;
    public function __construct( int $customers_id ) {
        $this->setCustomers_id( $customers_id );
        $this->load_addresses();
    }
    
    private function load_addresses(){
        $query = xtc_db_query(sprintf(
                "SELECT email_address FROM %s WHERE customers_id='%d'",
                $this::TABLE_ALLOCATION,
                $this->getCustomers_id()
        ));
        while($record = xtc_db_fetch_array($query)){
            $this->add_address( $record['email_address'] );
        }
    }
    
    private function add_address($address){
        $this->addresses[] = $address;
    }
    
    public function getCustomers_id() {
        return $this->customers_id;
    }

    public function getAddresses() {
        return $this->addresses;
    }

    public function setCustomers_id($customers_id): void {
        $this->customers_id = $customers_id;
    }

    public function setAddresses($addresses): void {
        $this->addresses = $addresses;
    }
    
    public function exists( $address ){
        foreach( $this->addresses as $saved ){
            if(strtolower($saved) == strtolower($address)){
                return true;
            }
        }
        return false;
    }
    
    public function delete( $address ){
        xtc_db_query(sprintf(
                "DELETE FROM %s WHERE customers_id='%d' AND email_address='%s'",
                $this::TABLE_ALLOCATION, $this->getCustomers_id(), $address
        ));
    }
    
    public function add( $address ){
        $insert_sql_array = [
            'customers_id'=>$this->getCustomers_id(),
            'email_address'=>$address,
            'date_added'=>'now()',
        ];
        xtc_db_perform($this::TABLE_ALLOCATION,$insert_sql_array);
    }

}
