<?php
require_once(__DIR__.DIRECTORY_SEPARATOR.'yes_cron_export_heading_rows.php');
class yes_cron_export
{
    var $name, $id, $date_added, $last_export, $use_heading_row, $ini_file, 
            $current_export_page, $current_export, $export_filename,
            $export_linked_products, $cat, $allCat, $distributors_id,
            $export_interval_in_hours;

    const TABLE_NAME = 'yes_cron_exports';
    const TABLE_INDEX_FIELD = 'yes_cron_exports_id';

    /**
     * Liefert den Pfad ohne endendes /
     * @return string
     */
    private static function get_ini_files_path():string{
        return \main::get_exportdata_path().'module_export_configs';
    }
    function getName() {
        return $this->name;
    }

    function getId() {
        return $this->id;
    }

    function setName($name) {
        $this->name = $name;
    }

    function setId($id) {
        $this->id = $id;
    }

    function getDate_added() {
        return $this->date_added;
    }

    function getLast_export() {
        return $this->last_export;
    }

    function setDate_added($date_added) {
        $this->date_added = $date_added;
    }

    function setLast_export($last_export) {
        $this->last_export = $last_export;
    }
    function getUse_heading_row() {
        return $this->use_heading_row;
    }

    function setUse_heading_row($use_heading_row) {
        $this->use_heading_row = $use_heading_row;
    }
    function getIni_file() {
        return $this->ini_file;
    }

    function setIni_file($ini_file) {
        $this->ini_file = $ini_file;
    }

    function getCurrent_export() {
        return $this->current_export;
    }

    function setCurrent_export($current_export) {
        $this->current_export = $current_export;
    }

    function getCurrent_export_page() {
        return $this->current_export_page;
    }

    function setCurrent_export_page($current_export_page) {
        $this->current_export_page = $current_export_page;
    }

    function getExport_filename() {
        return $this->export_filename;
    }

    function setExport_filename($export_filename) {
        $this->export_filename = $export_filename;
    }

    function getExport_linked_products() {
        return $this->export_linked_products;
    }

    function getCat() {
        return $this->cat;
    }

    function getAllCat() {
        return $this->allCat;
    }

    function setExport_linked_products($export_linked_products) {
        $this->export_linked_products = $export_linked_products;
    }

    function setCat($cat) {
        $this->cat = $cat;
    }

    function setAllCat($allCat) {
        $this->allCat = $allCat;
    }

    function getDistributors_id() {
        return $this->distributors_id;
    }

    function setDistributors_id($distributors_id) {
        $this->distributors_id = $distributors_id;
    }

    function getExport_interval_in_hours() {
        return $this->export_interval_in_hours;
    }

    function setExport_interval_in_hours($export_interval_in_hours) {
        $this->export_interval_in_hours = $export_interval_in_hours;
    }

    function __construct( $id ){
        $data = self::get_db_values($id);
        if(!$data){
            return false;
        }
        $this->setId($id);
        $this->setName($data['name']);
        $this->setDate_added($data['date_added']);
        $this->setLast_export($data['last_export']);
        $this->setIni_file($data['ini_file']);
        $this->setUse_heading_row($data['use_heading_row']);
        $this->setCurrent_export($data['current_export']);
        $this->setCurrent_export_page($data['current_export_page']);
        $this->setExport_filename($data['export_filename']);
        $this->setExport_linked_products((bool)$data['export_linked_products']);
        $this->setAllCat((bool)$data['allCat']);
        $this->setCat($data['cat']);
        $this->setDistributors_id($data['distributors_id']);
        $this->setExport_interval_in_hours($data['export_interval_in_hours']);
    }
    
    
    public static function get_db_values( $id ){
        $query = xtc_db_query(sprintf(
                "SELECT * FROM %s WHERE %s=%s",
                self::TABLE_NAME,
                self::TABLE_INDEX_FIELD,
                $id
        ));
        if(!xtc_db_num_rows($query)){
            return false;
        }
        return xtc_db_fetch_array($query);
    }
    
    public static function add($name, $ini, $export_interval_in_hours, $use_heading_row=0, $export_linked_products=false, $cat='', $allCat=true, $distributors_id = 0){
        if(empty(trim($name)) or empty(trim($ini))){
            return false;
        }
        if(!self::ini_exists($ini)){
            return false;
        }
        $insert_sql_array = array(
            'name'=>trim($name),
            'date_added'=>'now()',
            'ini_file'=>$ini,
            'use_heading_row'=>$use_heading_row,
            'export_linked_products'=>$export_linked_products,
            'cat'=>($allCat < 1) ? $cat : '',
            'allCat'=>$allCat,
            'distributors_id'=>$distributors_id,
            'export_interval_in_hours'=>$export_interval_in_hours
        );
        xtc_db_perform(self::TABLE_NAME, $insert_sql_array);
        return xtc_db_insert_id();
    }
    
    public static function name_exists($name){
        $query = xtc_db_query(sprintf(
                "SELECT %s FROM %s WHERE name='%s'",
                self::TABLE_INDEX_FIELD,
                self::TABLE_NAME,
                $name
        ));
        return xtc_db_num_rows($query);
    }
    
    public static function get_yes_cron_export_id_by_name($name){
        $query = xtc_db_query(sprintf(
                "SELECT %s FROM %s WHERE name='%s'",
                self::TABLE_INDEX_FIELD,
                self::TABLE_NAME,
                $name
        ));
        $record = xtc_db_fetch_array($query);
        return $record[ self::TABLE_INDEX_FIELD ];
    }
    
    public static function get_yes_cron_export_id_by_ini_file($ini_file){
        $query = xtc_db_query(sprintf(
                "SELECT %s FROM %s WHERE ini_file='%s'",
                self::TABLE_INDEX_FIELD,
                self::TABLE_NAME,
                $ini_file
        ));
        $record = xtc_db_fetch_array($query);
        return $record[ self::TABLE_INDEX_FIELD ];
    }
    
    public function delete(){
        xtc_db_query(sprintf(
                "DELETE FROM %s WHERE %s='%s'",
                self::TABLE_NAME,
                self::TABLE_INDEX_FIELD,
                $this->getId()
        ));
        foreach($this->get_heading_rows() as $row){
            $row->delete();
        }
    }
    
    public static function get_inis(){
        $array = array();
        if ($handle = opendir(self::get_ini_files_path())) {
            while (false !== ($entry = readdir($handle))) {
                if(!strstr($entry,'.ini')){
                    continue;
                }
                $array[] = array(
                    'id'=>$entry,
                    'text'=>str_replace(array('yes2_','.ini'),'',$entry)
                );
            }
            closedir($handle);
        }
        return $array;
    }
    
    public static function ini_exists($ini){
        return is_file(self::get_ini_files_path().DIRECTORY_SEPARATOR.'yes2_'.$ini.'.ini');
    }
    
    public function add_heading_rows_row($sort_order, $name){
        if(yes_cron_export_heading_rows::exists($this->getId(), $sort_order, $name)){
            return false;
        }
        return yes_cron_export_heading_rows::add_row($this->getId(), $sort_order, $name);
    }
    
    public static function get_current_cron_export(){
        $query = xtc_db_query(sprintf(
                "SELECT %s FROM %s WHERE current_export=1",
                self::TABLE_INDEX_FIELD,
                self::TABLE_NAME
        ));
        if(!xtc_db_num_rows($query)){
            $query = xtc_db_query(sprintf(
                    "SELECT %s FROM %s WHERE ((UNIX_TIMESTAMP(last_export)+(export_interval_in_hours*60*60)) < UNIX_TIMESTAMP()) OR UNIX_TIMESTAMP(last_export) IS NULL",
                    self::TABLE_INDEX_FIELD,
                    self::TABLE_NAME
            ));
            if(!xtc_db_num_rows($query)){
                return false;
            }
            $record = xtc_db_fetch_array($query);
            $update_sql_array = array(
                'current_export'=>1
            );
            xtc_db_perform(self::TABLE_NAME, $update_sql_array, 'update',self::TABLE_INDEX_FIELD."='".$record[self::TABLE_INDEX_FIELD]."'");
            return $record[self::TABLE_INDEX_FIELD];
        }
        $record = xtc_db_fetch_array($query);
        return $record[self::TABLE_INDEX_FIELD];
    }
    
    public function get_heading_rows(){
        $rows = array();
        foreach(yes_cron_export_heading_rows::get_rows($this->getId()) as $hr){
            $rows[] = $hr;
        }
        return $rows;
    }
    
    public function update_current_export($status){
        $update_sql_array = array(
            'current_export'=>$status
        );
        xtc_db_perform(self::TABLE_NAME, $update_sql_array, 'update',self::TABLE_INDEX_FIELD."='".$this->getId()."'");
    }
    
    public function update_last_export($date){
        $update_sql_array = array(
            'last_export'=>$date
        );
        xtc_db_perform(self::TABLE_NAME, $update_sql_array, 'update',self::TABLE_INDEX_FIELD."='".$this->getId()."'");
    }
    
    public function update( $data ){
        $allCat = (isset($data['allCat']) and $data['allCat'] == 1) ? 1 : 0;
        $update_sql_array = array(
            'name'=>$data['name'],
            'use_heading_row'=>(isset($data['use_heading_row']) and $data['use_heading_row'] == 1) ? 1 : 0,
            'export_filename'=>$data['export_filename'],
            'distributors_id'=>(isset($data['distributors_id'])) ? (int)xtc_db_input($data['distributors_id']) : 0,
            'allCat'=>$allCat,
            'cat'=>($allCat == 0 and isset($data['cat'])) ? implode(',',$data['cat']) : '',
            'export_linked_products'=>(isset($data['export_linked_products']) and $data['export_linked_products'] == 1) ? 1 : 0,
            'export_interval_in_hours'=>$data['export_interval_in_hours']
        );
        xtc_db_perform(self::TABLE_NAME,$update_sql_array,'update',self::TABLE_INDEX_FIELD."='".$this->getId()."'");
        return true;
    }
    
    public static function create_from_post($data){
        $allCat = (isset($data['allCat']) and $data['allCat'] == 1) ? 1 : 0;
        $insert_sql_array = array(
            'date_added'=>'now()',
            'name'=>$data['name'],
            'use_heading_row'=>(isset($data['use_heading_row']) and $data['use_heading_row'] == 1) ? 1 : 0,
            'ini_file'=>str_replace(array('yes2_','.ini'),'',$data['ini_file']),
            'export_filename'=>$data['export_filename'],
            'distributors_id'=>(isset($data['distributors_id'])) ? (int)xtc_db_input($data['distributors_id']) : 0,
            'allCat'=>$allCat,
            'cat'=>($allCat == 0 and isset($data['cat'])) ? implode(',',$data['cat']) : '',
            'export_linked_products'=>(isset($data['export_linked_products']) and $data['export_linked_products'] == 1) ? 1 : 0,
            'export_interval_in_hours'=>$data['export_interval_in_hours'],
        );
        xtc_db_perform(self::TABLE_NAME,$insert_sql_array);
        return true;
    }
    
    public function update_heading_rows($data){
        xtc_db_query(sprintf(
                "DELETE FROM yes_cron_export_heading_rows WHERE %s='%s'",
                self::TABLE_INDEX_FIELD, $this->getId()
        ));
        foreach($data as $sort_order=>$text){
            $insert_sql_array = array(
                self::TABLE_INDEX_FIELD => $this->getId(),
                'sort_order'=>$sort_order,
                'name'=>$text
            );
            xtc_db_perform('yes_cron_export_heading_rows',$insert_sql_array);
        }
    }
    public static function export_filename_exists($export_filename){
        $query = xtc_db_query(sprintf(
                "SELECT %s FROM %s WHERE export_filename='%s'",
                self::TABLE_INDEX_FIELD,
                self::TABLE_NAME,
                $export_filename
        ));
        return xtc_db_num_rows($query);
    }
    
    public static function getExport_interval_in_hours_values(){
        return array(
            array('id'=>4,'text'=>'4 Stunden'),
            array('id'=>8,'text'=>'8 Stunden'),
            array('id'=>12,'text'=>'12 Stunden'),
            array('id'=>24,'text'=>'1 Tag'),
            array('id'=>48,'text'=>'2 Tage'),
            array('id'=>168,'text'=>'1 Woche'),
            array('id'=>672,'text'=>'4 Wochen')
        );
    }
}