<?php
class yes_lister_table_heading_sort {
	var $columns;
	var $page_link;
	public function getColumns() {
		return $this->columns;
	}

	public function setColumns($columns) {
		$this->columns = $columns;
	}

	public function getPage_link() {
		return $this->page_link;
	}

	public function setPage_link($page_link) {
		$this->page_link = $page_link;
	}
	
	function __construct($columns,$page_link){
		$this->setColumns($columns);
		$this->setPage_link($page_link);
	}

	public function getHeadingRows($smarty=false){
		global $_REQUEST;
		$headings = array();

		// SORT DIRECTION SWITCH
		$current_sort_row = false;
		if(isset($_REQUEST['order_by'])){
			$order_by_parts = explode(' ',$_REQUEST['order_by']);
			$current_sort_row = $order_by_parts[0];
			$next_sort_direction = ($order_by_parts[1] == 'DESC') ? 'ASC' : 'DESC';
		}
		foreach($this->getColumns() as $key=>$value){
			if(!isset($value['heading_hide']) or $value['heading_hide'] == 0){
				if(!$current_sort_row or $current_sort_row != $value['field']){
					$sort_href = xtc_href_link($this->page_link,xtc_get_all_get_params(array('order_by')).'order_by='.$value['field'].'%20DESC');
				}else{
					// SORT DIRECTION SWITCH
					$sort_href = xtc_href_link($this->page_link,xtc_get_all_get_params(array('order_by')).'order_by='.$value['field'].'%20'.$next_sort_direction);
				}
				$data = array(
					'title'=>$value['heading'],
					'sort'=>$value['sortable'],
					'column'=>$value['column'],
					'sort_href_asc'=>xtc_href_link($this->page_link,xtc_get_all_get_params(array('order_by')).'order_by='.$value['field'].'%20DESC'),
					'sort_href_desc'=>xtc_href_link($this->page_link,xtc_get_all_get_params(array('order_by')).'order_by='.$value['field'].'%20ASC'),
					'sort_href'=>$sort_href
				);
				if($smarty)
					$data['html'] = $this->getHtml($data,$smarty);
				$headings[] = $data;
			}else{
				if($this->$value['heading_display_function']() == true){
					$data = array(
						'title'=>$value['heading'],
						'sort'=>$value['sortable'],
						'column'=>$value['column'],
						'sort_href_asc'=>xtc_href_link($this->getPage_link(),xtc_get_all_get_params(array('order_by')).'order_by='.$value['field'].'%20DESC'),
						'sort_href_desc'=>xtc_href_link($this->getPage_link(),xtc_get_all_get_params(array('order_by')).'order_by='.$value['field'].'%20ASC')
					);
					if($smarty)
						$data['html'] = $this->getHtml($data,$smarty);
					$headings[] = $data;
				}
			}
		}
		return $this->record_sort($headings,'column');
	}

	function record_sort($records, $field, $reverse=false)
	{
	    $hash = array();
	   
	    foreach($records as $key => $record)
	    {
	        $hash[$record[$field].$key] = $record;
	    }
	   
	    ($reverse)? krsort($hash) : ksort($hash);
	   
	    $records = array();
	   
	    foreach($hash as $record)
	    {
	        $records []= $record;
	    }
	   
	    return $records;
	}
	
	public function getHtml($data,$smarty,$td_class='dataTableHeadingContent',$template='yes_lister_table_heading_sort_td.html'){
		$smarty->assign(array(
			'class'=>$td_class,
			'td'=>$data,
			'TEXT_SORT_ASC'=>TEXT_SORT_ASC,
			'TEXT_SORT_DESC'=>TEXT_SORT_DESC
		));
		return $smarty->fetch($template);
	}

}
