<?php
require(DIR_FS_INC.'yes_get_products_ordered_by_distributors.inc.php');
define('MODULE_MELDEBESTAND_TEXT_DESCRIPTION', 'Export - Meldebest&auml;nde (Tab getrennt)');
define('MODULE_MELDEBESTAND_TEXT_TITLE', 'Meldebestand Export - CSV');
define('MODULE_MELDEBESTAND_FILE_TITLE' , '<hr noshade>Dateiname');
define('MODULE_MELDEBESTAND_FILE_DESC' , 'Geben Sie einen Dateinamen ein, falls die Exportdatei am Server gespeichert werden soll.<br>(Verzeichnis ebaymich/)');
define('MODULE_MELDEBESTAND_STATUS_DESC','Modulstatus');
define('MODULE_MELDEBESTAND_EXPORT_ALL','Alle Artikel exportieren');
define('MODULE_MELDEBESTAND_STATUS_TITLE','Status');
@define('EXPORT_YES','Nur Herunterladen');
@define('EXPORT_NO','Am Server Speichern');
@define('DATE_FORMAT_EXPORT', '%d.%m.%Y');  // this is used for strftime()
// include needed functions

class meldebestand extends products_export{
	var $code, $title, $description, $enabled,$Separator,$EOL,$tmp_directory,
                $sort_order, $_check,$TextSign,$max_items_per_step;
	function __construct() {
		$this->TextSign = '';
		$this->Separator = "\t";
		$this->EOL = "\r\n";
		$this->code = 'meldebestand';
		$this->title = MODULE_MELDEBESTAND_TEXT_TITLE;
		$this->description = MODULE_MELDEBESTAND_TEXT_DESCRIPTION;
		$this->sort_order = (defined('MODULE_MELDEBESTAND_SORT_ORDER')) ? MODULE_MELDEBESTAND_SORT_ORDER : 0;
		$this->enabled = ((defined('MODULE_MELDEBESTAND_STATUS') and MODULE_MELDEBESTAND_STATUS == 'True') ? true : false);
		$this->max_items_per_step = 1000;
	}
	
	public function get_sql(){
		$products_query_raw = "SELECT p.products_meldebestand,p.products_id,pd.products_name,pd.ebay_title,p.products_status,p.products_date_available,p.in_auction,p.products_model FROM products p,products_description pd LEFT JOIN products_collies pc USING(products_id) WHERE pc.products_id IS NULL and pd.products_id=p.products_id and pd.language_id='2'";
		if(!isset($_REQUEST['all']) or $_REQUEST['all'] != '1'){
		    $products_query_raw .= " and p.meldebestand_active=1";
		}
		return $products_query_raw;
	}
	
	public function get_total_number_of_items(){
	    @xtc_set_time_limit(0);
	    $items = 0;
	    $records = array();
	    $query = xtc_db_query($this->get_sql());
	    while($record = xtc_db_fetch_array($query)){
		$records[] = $record;
	    }
	    if(sizeOf($records)){
		foreach($records as $products){
			$SQ = new products_quantity($products['products_id']);
			$pqty = $SQ->get_available1_qty();
			if($pqty<=$products['products_meldebestand']){
			    $items++;
			}
		}
	    }
	    return $items;
	}
	
	public function process_header(){
	    $basics = new basics;
	    $str = implode($this->Separator, $this->get_schema())."\r\n";
	    if(is_file($this->tmp_directory.'/00_HEADER.CSV'))
		unlink($this->tmp_directory.'/00_HEADER.CSV');
	    $basics->create_file($this->tmp_directory.'/00_HEADER.CSV', $str);
	}
	
	public function get_schema(){
		return array('pID','Amazon SKU','Artikelname','eBay Titel','Art.-Nr.','Artikelstatus','Meldebestand','Erscheinungsdatum','Physik. Bestand', 'Verfg. 1','Verfg. 2','Amazonbestand','eBay Bestand' ,'Bestellungen','Lieferantenbestellungen');
	}
	
	public function process_page($page,$max_items_per_step){
	    $basics = new basics;
	    @xtc_set_time_limit(0);
	    $page_sql = $this->get_sql();
	    //$page_sql .= sprintf(' LIMIT %s, %s',$page*$max_items_per_step,$max_items_per_step);

	    $items = array();
	    $records = array();
	    $query = xtc_db_query($page_sql);
	    while($record = xtc_db_fetch_array($query)){
		$records[] = $record;
	    }
	    if(sizeOf($records)){
		foreach($records as $products){
			$SQ = new products_quantity($products['products_id']);
			$pqty = $SQ->get_available1_qty();
                        $av2 = $SQ->get_available2_qty();
                        $ebay_qty = $products['in_auction'];
                        $amz_sku = '';
                        $amz_qty = 0;
                        if(defined('MODULE_OTHER_AMAZON_STATUS') and MODULE_OTHER_AMAZON_STATUS == 'True'){
                            $amz = yes_get_products_amazon_values($products['products_id']);
                            if(sizeOf($amz)){
                                $amz_sku = $amz['sku'];
                                $amz_qty = $amz['quantity'];
                            }
                        }
			$phys = $SQ->get_products_total_qty();
			if($pqty<=$products['products_meldebestand']){
			    $current_size = sizeOf($items);
			    if($current_size == 0 or ($current_size > $page*$max_items_per_step and $current_size < ($page*$max_items_per_step)+$max_items_per_step)){
				$items[] = array(
					$products['products_id'],
                                        $amz_sku,
					xtc_db_prepare_input($products['products_name']),
					xtc_db_prepare_input($products['ebay_title']),
                                        $products['products_model'],
					$products['products_status'],
					$products['products_meldebestand'],
                                        xtc_date_long($products['products_date_available']),
					$phys,
					$pqty,
                                        $av2,
                                        $amz_qty,
                                        $ebay_qty,
					$phys-$pqty,
					yes_get_products_ordered_by_distributors($products['products_id'])
				);
			    }
			}
		} // eof foreach records
	    } // eof size of records
	    if(sizeOf($items)){
		$str = '';
		foreach($items as $row){
		    $str .= implode($this->Separator,$row)."\r\n";
		}
		$basics->create_file($this->tmp_directory.'/PAGE_'.$page.'.CSV', $str);
	    }
	}

	function process($file) {
        @xtc_set_time_limit(0);
		$columns = array();
		$columns[] = array('pID','Amazon SKU','Artikelname','eBay Titel','Art.-Nr.','Artikelstatus','Meldebestand','Erscheinungsdatum','Physik. Bestand', 'Verfg. 1','Verfg. 2','Amazonbestand','eBay Bestand' ,'Bestellungen','Lieferantenbestellungen');
		$records = array();
		$schema = '';
		$products_query_raw = "SELECT p.products_meldebestand,p.products_id,pd.products_name,pd.ebay_title,p.products_status,p.products_date_available,p.in_auction,p.products_model FROM products p,products_description pd LEFT JOIN products_collies pc USING(products_id) WHERE pc.products_id IS NULL and pd.products_id=p.products_id and pd.language_id='2'";
		if(!isset($_REQUEST['all']) or $_REQUEST['all'] != '1'){
		    $products_query_raw .= " and p.meldebestand_active=1";
		}
		$products_query = xtc_db_query($products_query_raw);
		while($row = xtc_db_fetch_array($products_query)){
			$records[] = $row;
		}
		foreach($records as $products){
			$SQ = new products_quantity($products['products_id']);
			$pqty = $SQ->get_available1_qty();
                        $av2 = $SQ->get_available2_qty();
                        $ebay_qty = $products['in_auction'];
                        $amz_sku = '';
                        $amz_qty = 0;
                        if(defined('MODULE_OTHER_AMAZON_STATUS') and MODULE_OTHER_AMAZON_STATUS == 'True'){
                            $amz = yes_get_products_amazon_values($products['products_id']);
                            if(sizeOf($amz)){
                                $amz_sku = $amz['sku'];
                                $amz_qty = $amz['quantity'];
                            }
                        }
			$phys = $SQ->get_products_total_qty();
			if($pqty<=$products['products_meldebestand']){
				$columns[] = array(
					$products['products_id'],
                                        $amz_sku,
					xtc_db_prepare_input($products['products_name']),
					xtc_db_prepare_input($products['ebay_title']),
					$products['model'],
					$products['products_status'],
					$products['products_meldebestand'],
                                        xtc_date_long($products['products_date_available']),
					$phys,
					$pqty,
                                        $av2,
                                        $amz_qty,
                                        $ebay_qty,
					$phys-$pqty,
					yes_get_products_ordered_by_distributors($products['products_id'])
				);
			}
		}
		foreach($columns as $row){
			$schema .= implode($this->Separator,$row);
			$schema .= $this->EOL;
		}

		// create File
		$fp = fopen(DIR_FS_CATALOG.'../ebaymich/' . $file, "w+");
		fputs($fp, $schema);
		fclose($fp);


		switch ($_POST['export']) {
        	case 'yes':
			// send File to Browser
			$extension = substr($file, -3);
			$fp = fopen(DIR_FS_CATALOG.'../ebaymich/' . $file,"rb");
			$buffer = fread($fp, filesize(DIR_FS_CATALOG.'../ebaymich/' . $file));
			fclose($fp);
			header('Content-type: application/x-octet-stream');
			header('Content-disposition: attachment; filename=' . $file);
			echo $buffer;
			exit;
			break;
        }
    }


    function display() {
	/* WIR WOLLEN AUSGEWAEHLTE KATEGORIEN EXPORTEN */
		$array = array('text' =>  
			'<script type="text/javascript">'.
			"  $().ready(function(){
			    $('.start_lbon_export_button').click(function(){
				showPreloader();
				$('#modal_window').dialog({title: 'Export'}).load(
				    '".xtc_href_link(FILENAME_MODULE_EXPORT,xtc_get_all_get_params(array('action')).'&action=save_stepwise')."&'+$('form[name=\"modules\"]').serialize(),
					function(){
					    hidePreloader();
					}
				);
				return false;
			    });
			   });
			</script>".   
				    '<br />'.yes_draw_href_button(IMAGE_EXPORT,'javascript:','width:120px;','button','start_lbon_export_button ui-button ui-corner-all ui-state-default') . '&nbsp;' .
				    yes_draw_href_button(IMAGE_CANCEL,xtc_href_link(FILENAME_MODULE_EXPORT, 'set=' . $_GET['set'] . '&module=meldebestand'),'width:120px;'));
		return $array;
    }

	function check() {
		if (!isset($this->_check)) {
			$check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_MELDEBESTAND_STATUS'");
			$this->_check = xtc_db_num_rows($check_query);
		}
		return $this->_check;
	}

    function install() {
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_MELDEBESTAND_FILE', 'meldebestand.csv',  '6', '1', '', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_MELDEBESTAND_STATUS', 'True',  '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
}

    function remove() {
      xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_MELDEBESTAND_STATUS','MODULE_MELDEBESTAND_FILE');
    }
}
