<?php
require_once(DIR_WS_CLASSES.'class.basics.php');
require_once(DIR_FS_INC.'yes_get_sha1_from_string.inc.php');
define('MODULE_RUECKERSTATTUNGEN_TEXT_DESCRIPTION', 'Export - R&uuml;ckerstattungen (Tab getrennt)');
define('MODULE_RUECKERSTATTUNGEN_TEXT_TITLE', 'R&uuml;ckerstattungen Export - CSV');
define('MODULE_RUECKERSTATTUNGEN_FILE_TITLE' , '<hr noshade>Dateiname');
define('MODULE_RUECKERSTATTUNGEN_FILE_DESC' , 'Geben Sie einen Dateinamen ein, falls die Exportdatei am Server gespeichert werden soll.<br>(Verzeichnis ebaymich/)');
define('MODULE_RUECKERSTATTUNGEN_STATUS_DESC','Modulstatus');
define('MODULE_RUECKERSTATTUNGEN_STATUS_TITLE','Status');
define('MODULE_RUECKERSTATTUNGEN_STARTDATE','Exportzeitraum (von)');
define('MODULE_RUECKERSTATTUNGEN_ENDDATE','Exportzeitraum (bis)');
@define('EXPORT_YES','Nur Herunterladen');
@define('EXPORT_NO','Am Server Speichern');
// include needed functions

class rueckerstattungen extends products_export{
    var $TextSign, $code, $title, $description, $enabled,$_check, $sort_order;


    function __construct() {
      $this->TextSign = '';
      $this->code = 'rueckerstattungen';
      $this->title = MODULE_RUECKERSTATTUNGEN_TEXT_TITLE;
      $this->description = MODULE_RUECKERSTATTUNGEN_TEXT_DESCRIPTION;
      $this->sort_order = (defined('MODULE_RUECKERSTATTUNGEN_SORT_ORDER')) ? MODULE_RUECKERSTATTUNGEN_SORT_ORDER : 0;
      $this->enabled = ((defined('MODULE_RUECKERSTATTUNGEN_STATUS') and MODULE_RUECKERSTATTUNGEN_STATUS == 'True') ? true : false);
    }



    function process($file) {
		$basics = new basics;
        @xtc_set_time_limit(0);
		$header = array('Nr','Re-Nr','Rekl-Nr','Empfaenger','Gespeichert','Typ','Status','Betrag','Ausgezahlt','Kto. Nummer','Kto. BLZ','Kto. Inhaber','Kommentar','VWZ','Kto. Bank','IBAN','SWIFT');
		$schema = implode("\t",$header)."\r\n";
		$date_from = xtc_db_input($_REQUEST['date_from']);
		$date_to = xtc_db_input($_REQUEST['date_to']).' 23:59:59';
		$query_raw = sprintf(
				"SELECT * FROM rueckerstattungen WHERE date_created > '%s' AND date_created < '%s' ORDER BY date_created",
				$date_from,$date_to
		);
		$query = xtc_db_query($query_raw);
		$data = array();
		while($record = xtc_db_fetch_array($query)){
			$data[] = array(
				$record['rueckerstattungs_id'],
				$record['orders_id'],
				$record['reclamations_id'],
				xtc_get_editor_name($record['customers_id']),
				xtc_date_short($record['date_created']),
				$record['paymode'],
				xtc_get_rueckerstattungen_status_name($record['status']),
				$record['betrag'],
				(($record['date_payment'] != '0000-00-00 00:00:00')?xtc_date_short($record['date_payment']):''),
				$record['kto_nummer'],
				$record['kto_blz'],
				$record['kto_inhaber'],
				$record['comments'],
				$record['kto_grund'],
				$record['kto_bank'],
				$record['kto_iban'],
				$record['kto_swift']
			);
		}
		if(sizeOf($data)){
			foreach($data as $line){
				$schema .= implode("\t",$line);
				$schema .= "\r\n";
			}
		}
		// create File
		$fp = fopen(DIR_FS_CATALOG.'../ebaymich/' . $file, "w+");
		fputs($fp, $schema);
		fclose($fp);


		switch ($_POST['export']) {
        	case 'yes':
			
			$crypt_file = yes_get_sha1_from_string( date('d.m.Y_H.i.s') );
			$filename = sprintf('rueckerstattungen_%s.csv',$crypt_file);
			$filepath = \main::get_exportdata_path();
			$basics->create_file($filepath.$filename,$schema);
			$basics->zip_file($filepath,$filename,$filename.'.zip',true);

			$file_contents = $basics->read_file_content($filepath.$filename.'.zip',$mode='rb');
			unlink($filepath.$filename.'.zip');
			// send File to Browser
			$file = 'rueckerstattungen_'.date('Y-m-d_H_i_s').'.zip';
			header('Content-Type: application/octet-stream');
			header('Content-Transfer-Encoding: binary');
			header('Content-disposition: attachment; filename=' . $file);
			echo $file_contents;
			exit;
			break;
        	}
	} // end if categories_array

    function display() {
		$from = yes_strftime('%Y-%m-%d',time()-60*60*24*2);
		$to = date('Y-m-d');
		$array = array('text' =>  EXPORT_TYPE.'<br />'.
			'<script type="text/javascript">'.
			'  var dateStart = new ctlSpiffyCalendarBox("dateStart", "modules", "date_from","btnDate1","'.$from.'",scBTNMODE_CUSTOMBLUE);'.
			'  var dateEnd = new ctlSpiffyCalendarBox("dateEnd", "modules", "date_to","btnDate1","'.$to.'",scBTNMODE_CUSTOMBLUE);'.
			'</script>'.
			MODULE_RUECKERSTATTUNGEN_STARTDATE.'<br /><script type="text/javascript">dateStart.writeControl(); dateStart.dateFormat="yyyy-MM-dd";</script><br />'.
			MODULE_RUECKERSTATTUNGEN_ENDDATE.'<br /><script type="text/javascript">dateEnd.writeControl(); dateEnd.dateFormat="yyyy-MM-dd";</script><br />'.
			EXPORT.'<br />'.
			xtc_draw_radio_field('export', 'no',false).EXPORT_NO.'<br />'.
			xtc_draw_radio_field('export', 'yes',true).EXPORT_YES.'<br /><br />'.
			'<br />' . xtc_image_submit('button_export.gif',IMAGE_EXPORT) .
			'<a href="'.xtc_href_link(FILENAME_MODULE_EXPORT, 'set=' . $_GET['set'] . '&module=rueckerstattungen').'">'.xtc_image_button('button_cancel.gif',IMAGE_CANCEL).'</a>'
		);
		return $array;
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_RUECKERSTATTUNGEN_STATUS'");
        $this->_check = xtc_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_RUECKERSTATTUNGEN_FILE', 'rueckerstattungen.csv',  '6', '1', '', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_RUECKERSTATTUNGEN_STATUS', 'True',  '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
	}

    function remove() {
      xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_RUECKERSTATTUNGEN_STATUS','MODULE_RUECKERSTATTUNGEN_FILE');
    }
}
