<?php
$dummy = "order-id	order-item-id	purchase-date	payments-date	buyer-email	buyer-name	payment-method-details	buyer-phone-number	sku	number-of-items	product-name	quantity-purchased	currency	item-price	item-tax	shipping-price	shipping-tax	gift-wrap-price	gift-wrap-tax	ship-service-level	ship-service-name	recipient-name	ship-address-1	ship-address-2	ship-address-3	address-type	ship-city	ship-state	ship-postal-code	ship-country	ship-phone-number	bill-name	bill-address-1	bill-address-2	bill-address-3	bill-city	bill-state	bill-postal-code	bill-country	gift-wrap-type	gift-message-text	item-promotion-discount	item-promotion-id	ship-promotion-discount	ship-promotion-id	delivery-start-date	delivery-end-date	delivery-time-zone	delivery-Instructions	sales-channel	order-channel	order-channel-instance	external-order-id	payment-method	cod-collectible-amount	already-paid	payment-method-fee	earliest-ship-date	latest-ship-date	earliest-delivery-date	latest-delivery-date	item-extensions-data	is-business-order
k15H7-w8p5-egh	srwjyxfg48-37kk-4596li-xvc158kmn9	2025-02-06T07:37:59.561+00:00	2025-02-06T07:37:59.561+00:00	123456abcde@marktplatz-mail.de	Max Mustermann			780	1	PREMIUM Staubwedel in bunt	1	EUR	78.30	12.50	0.00	0.00					Max Mustermann	Hauptstrasse 1				Musterstadt		12345	DE		Max Mustermann	Hauptstrasse 1			Musterstadt		12345	DE			0.00		0.00						marktplatz							0.00						false";
define('AMAZON_ADDRESS_FORMAT_ID',5);
if(!class_exists('product')){
    die("No class 'product' defined.");
}
require_once (DIR_FS_INC . 'yes_write_notice.inc.php');
require_once (DIR_FS_INC . 'xtc_encrypt_password.inc.php');
require_once (DIR_FS_INC . 'xtc_get_customer_status_value.inc.php');
require_once (DIR_FS_INC . 'xtc_get_serial_number.inc.php');
require_once (DIR_FS_INC . 'xtc_get_order_html_for_pdf.inc.php');
require_once (DIR_FS_INC . 'xtc_get_orders_ebay_seller.inc.php');
require_once (DIR_FS_INC . 'xtc_format_price_order.inc.php');
require_once (DIR_FS_CATALOG . 'lang/'.$_SESSION['language'].'/modules/order_total/ot_subtotal.php');
require_once (DIR_FS_CATALOG . 'lang/'.$_SESSION['language'].'/modules/order_total/ot_total.php');

function mi_get_name_pairs($fullname){
    $parts = explode(' ',$fullname);
    $parts = array_reverse($parts);
    $last_name = array_shift($parts);
    $parts = array_reverse($parts);
    return array('last_name'=>$last_name,'first_name'=>implode(' ',$parts));
}
$import_preview = $_FILES['importfile']??[];
$import_unknown_products = true;
$smarty = new yesSmarty;
$basics = new \basics;
$import_now = false;
if(isset($_GET['dl'])){
    // Dateiname für den Download
    $filename = "multi_import.csv";

    // Richtige Header senden
    header('Content-Type: text/csv; charset=utf-8');
    header('Content-Disposition: attachment; filename="' . $filename . '"');
    header('Pragma: no-cache');
    header('Expires: 0');

    // Ausgabe starten
    echo $dummy;
    exit;    
}
if(isset($_GET['import']) and $_GET['import'] == '1'){
    $import_now = true;
}
if(sizeOf($import_preview) or $import_now){
    // @todo: auswahlfeld in preview
    $customers_status_id = intval($_GET['customers_status']??MODULE_OTHER_AMAZON_CUSTOMERS_STATUS_ID);
    $source = $_GET['orders_source']??'shop';
    $orders_status_id = intval($_GET['orders_status']??1);

    $target_dir = "importdata/";
    $target_file = $target_dir . 'MULTIORDER_IMPORT.csv';
    if(!$import_now){
        if(file_exists($target_file)){
            unlink($target_file);
        }
        $uploadOk = 1;
        $imageFileType = strtolower(pathinfo($target_file,PATHINFO_EXTENSION));
        // Check if image file is a actual image or fake image
        if (!move_uploaded_file($_FILES["importfile"]["tmp_name"], $target_file)) {
            $messageStack->add_session('File import failed','error');
            xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params()));
        }
    }
    $content = file_get_contents($target_file);
    $lines = explode("\n",$content);
    $csv = [];
    foreach($lines as $line){
        if(empty($line)){
            continue;
        }
        $csv[] = explode("\t",$line);
    }

    $amazon_values = [];
    $keys = [];
    $keynr = 0;
    foreach($csv[0] as $colname){
        $keys[ str_replace('-','_',$colname) ] = $keynr;
        $keynr++;
    }
    foreach($csv as $row=>$cols){
        if($row < 1){
            continue;
        }
        $exists = false;
        foreach($amazon_values as $nr => $av){
            if($av[ 'order_id' ] == $cols[ $keys['order_id'] ]){
                // entry exists - also bestellung mit mehreren artikeln
                $exists = true;
                $exist_nr = $nr;
                break;
            }
        }
        // TICKET 3452
        if($cols[ $keys['is_buyer_requested_cancellation'] ] == 'true'){
            continue;
        }
        if($exists){
            // items erweitern
            $item = [
                    'amazon_order_item_code'=>$cols[ $keys['order_item_id'] ],
                    'products_id'=> yes_get_products_id_from_amazon_sku($cols[ $keys['sku'] ], $selling_partner_id),
                    'price'=>[
                        [
                            'type'=>'Principal',
                            'amounts'=>[
                                'amount'=>$cols[ $keys['item_price'] ], 
                                'currency'=>$cols[ $keys['currency'] ]
                            ]
                        ],[
                            'type'=>'Shipping',
                            'amounts'=>[
                                'amount'=>$cols[ $keys['shipping_price'] ], 
                            ]
                        ],[
                            'type'=>'ShippingTax',
                            'amounts'=>[
                                'amount'=>$cols[ $keys['shipping_tax'] ], 
                            ]
                        ],[
                            'type'=>'Tax',
                            'amounts'=>[
                                'amount'=>$cols[ $keys['item_tax'] ], 
                            ]
                        ],
                    ],
                    'sku'=>$cols[ $keys['sku'] ],
                    'name'=>$cols[ $keys['product_name'] ],
                    'quantity_purchased'=>$cols[ $keys['quantity_purchased'] ],
                    'product_tax_code'=>'',
                    'promotion_claim_code'=>'',
                    'merchant_promotion_id'=>$cols[ $keys['item_promotion_id'] ],
                    'total_item_fee'=>''
            ];
            $amazon_values[ $exist_nr ]['items'][] = $item;
            continue;
        }else{
            $items = [[
                    'amazon_order_item_code'=>$cols[ $keys['order_item_id'] ],
                    'products_id'=> yes_get_products_id_from_amazon_sku($cols[ $keys['sku'] ], $selling_partner_id),
                    'price'=>[
                        [
                            'type'=>'Principal',
                            'amounts'=>[
                                'amount'=>$cols[ $keys['item_price'] ], 
                                'currency'=>$cols[ $keys['currency'] ]
                            ]
                        ],[
                            'type'=>'Shipping',
                            'amounts'=>[
                                'amount'=>$cols[ $keys['shipping_price'] ], 
                            ]
                        ],[
                            'type'=>'ShippingTax',
                            'amounts'=>[
                                'amount'=>$cols[ $keys['shipping_tax'] ], 
                            ]
                        ],[
                            'type'=>'Tax',
                            'amounts'=>[
                                'amount'=>$cols[ $keys['item_tax'] ], 
                            ]
                        ],
                    ],
                    'sku'=>$cols[ $keys['sku'] ],
                    'name'=>$cols[ $keys['product_name'] ],
                    'quantity_purchased'=>$cols[ $keys['quantity_purchased'] ],
                    'product_tax_code'=>'',
                    'promotion_claim_code'=>'',
                    'merchant_promotion_id'=>$cols[ $keys['item_promotion_id'] ],
                    'total_item_fee'=>''
            ]];
        }
        $amazon_values[] = [
            'buyer_email'=>$cols[ $keys['buyer_email'] ],
            'buyer_name'=>$cols[ $keys['buyer_name'] ],
            'buyer_company_name'=>$cols[ $keys['buyer_company_name']],
            'buyer_phone_number'=>$cols[ $keys['buyer_phone_number'] ],
            'bill_name'=>$cols[ $keys['bill_name'] ],
/* - */                     'bill_country_code'=>$cols[ $keys['bill_country'] ],
            'bill_address_1'=>$cols[ $keys['bill_address_1'] ],
            'bill_address_2'=>$cols[ $keys['bill_address_2'] ],
            'bill_address_3'=>$cols[ $keys['bill_address_3'] ],
            'bill_postal_code'=>$cols[ $keys['bill_postal_code'] ],
            'bill_city'=>$cols[ $keys['bill_city'] ],
            'bill_state'=>$cols[ $keys['bill_state'] ],
/* - */                     'ship_country_code'=>$cols[ $keys['ship_country'] ],
            'items'=>$items,
            'order_id'=>$cols[ $keys['order_id'] ],
            'delivery_instructions'=>$cols[ $keys['delivery_instructions'] ],

            'ship_address_1'=>$cols[ $keys['ship_address_1'] ],
            'ship_address_2'=>$cols[ $keys['ship_address_2'] ],
            'ship_address_3'=>$cols[ $keys['ship_address_3'] ],
            'shipping_service_level'=>$cols[ $keys['ship_service_level'] ],
            'shipping_method'=>$cols[ $keys['ship_service_name'] ],

            'recipient_name'=>$cols[ $keys['recipient_name'] ],
            'ship_city'=>$cols[ $keys['ship_city'] ],
            'ship_postal_code'=>$cols[ $keys['ship_postal_code'] ],
            'ship_state'=>$cols[ $keys['ship_state'] ],
            'purchase_date'=>$cols[ $keys['purchase_date'] ],
            'currency'=>$cols[ $keys['currency'] ],
            'is_business_order'=>$cols[ $keys['is_business_order'] ],
        ];
    }
    if($import_now){
		/**
		 * Dieses Array enthaelt am Ende alle Werte die notwendigen Variablen
		 * fuer den Bestellbestaetigung Feed
		 */
		$orders_created = array();
        foreach($amazon_values as $amazon_order){
            $customer_obj = \YES4Trade\Model\customers::get_by_email_address($amazon_order['buyer_email']);
            // CUSTOMER HAS ALREADY AN AMAZON ORDER
            if($customer_obj !== null){
                $customers_id = $customer_obj->customers_id;
                $address_book_id = $customer_obj->customers_default_address_id;
            }else{
                $password = $basics->generate_password();
                $name_pairs = mi_get_name_pairs($amazon_order['buyer_name']);
                $insert_sql_array = array(
                    'customers_email_address'=>$amazon_order['buyer_email'],
                    'customers_status'=>$customers_status_id,
                    'customers_firstname'=>$name_pairs['first_name'],
                    'customers_lastname'=>$name_pairs['last_name'],
                    'customers_default_address_id'=>'',
                    'customers_telephone'=>$amazon_order['buyer_phone_number'],
                    'customers_password'=>xtc_encrypt_password($password)
                );
                xtc_db_perform('customers',$insert_sql_array);
                $customers_id = xtc_db_insert_id();

                $name_pairs = mi_get_name_pairs($amazon_order['bill_name']);
                $bill_country_id = yes_get_country_id_from_iso2($amazon_order['bill_country_code']);
                $new = new \YES4Trade\Model\address_book([
                    'customers_id'=>(int)$customers_id,
                    'entry_company'=>'',
                    'entry_firstname'=>$name_pairs['first_name'],
                    'entry_lastname'=>$name_pairs['last_name'],
                    'entry_street_address'=>$amazon_order['bill_address_1'],
                    'entry_suburb'=>$amazon_order['bill_address_2'].(
                            (!empty($amazon_order['bill_address_3']) ? ' '.$amazon_order['bill_address_3']:'')
                    ),
                    'entry_postcode'=>$amazon_order['bill_postal_code'],
                    'entry_city'=>$amazon_order['bill_city'],
                    'entry_state'=>$amazon_order['bill_state'],
                    'entry_country_id'=>(int)$bill_country_id,
                    'entry_zone_id'=>0,
                    'address_class'=>'',
                    'address_date_added'=>date('Y-m-d H:i:s')
                ]);
                $address_book_id = $new->create();
                
                $query = xtc_db_query(sprintf(
                    "UPDATE customers SET customers_default_address_id='%s' WHERE customers_id='%s'",
                    $address_book_id,$customers_id
                ));
            }

            $cs_query = yes_db_query(sprintf(
                "SELECT customers_status_name, customers_status_image FROM customers_status WHERE customers_status_id='%s'",
                $customers_status_id
            ),true);
            if($cs_query){
                $cs = current($cs_query);
            }else{
                $cs = array('Unbekannt', '');
            }
            if(!isset($bill_country_id)) // FALLS ADRESSE SCHON BEKANNT
                $bill_country_id = yes_get_country_id_from_iso2($amazon_order['bill_country_code']);
            $ship_country_id = yes_get_country_id_from_iso2($amazon_order['ship_country_code']);
                    $shipping_costs = 0;
                    $shipping_tax = 0;
                    $price_netto = 0;
                    $price_brutto = 0;
                    $insert_products_sql = [];
                    $models = [];
                    foreach($amazon_order['items'] as $product){
                        $YESproduct = new product($product['products_id']);
                        
                        $models[ $product['products_id'] ] = $YESproduct->info['products_model'];
                        
                        if(!isset($YESproduct->info['products_id']) and !$import_unknown_products)
                                        continue;

                        $products_tax = 0;
                        $additional_costs = 0; // for amazon_features
                        if($product['products_id'] <= 0){
                                $tax_class_id = 1; // idR 19%
                                if(defined('MODULE_OTHER_AMAZON_DUMMY_PRODUCTS_ID') and MODULE_OTHER_AMAZON_DUMMY_PRODUCTS_ID > 0){
                                    $tax_class_id = yes_eu_oss_get_products_tax_class_id(MODULE_OTHER_AMAZON_DUMMY_PRODUCTS_ID, $ship_country_id);
                                    $product['products_id'] = MODULE_OTHER_AMAZON_DUMMY_PRODUCTS_ID;
                                }
                        }else{
                            // EU OSS
                            $tax_class_id = yes_eu_oss_get_products_tax_class_id($product['products_id'], $ship_country_id);

                            //ALT: $tax_class_id = $YESproduct->info['products_tax_class_id'];
                        }
                        $tax_rate = xtc_get_tax_rate($tax_class_id,$ship_country_id);
                        foreach($product['price'] as $price){
                            $amt = $price['amounts'];
                            switch($price['type']){
                                    case 'Principal':
                                        $price_netto += floatval($amt['amount']) / ((100+$tax_rate)/100);
                                        $price_brutto += floatval($amt['amount']);
                                        if(!isset($currency)){
                                            $currency = $amt['currency'];
                                        }
                                        break;
                                    case 'Shipping':
                                        $shipping_costs += floatval($amt['amount']);
                                        break;
                                    case 'ShippingTax':
                                        /**
                                         *  shippingtax berechnen wir separat - hier nur der
                                         * vollstaendigkeit halber
                                         */
                                        $shipping_tax += floatval($amt['amount']);
                                        break;
                                    case 'Tax':
                                        $tax += floatval($amt['amount']);
                                        break;
                                    default:
                                        echo '<h4>Achtung: Unbekannte Preiskomponente. Bitte informieren Sie das YES4trade Team</h4><pre>';
                                        print_r($price);
                                        echo '</pre>';
                                        exit;
                                        break;
                            }
                        }
                    } // end foreach items
                            
                    $shipping_class = 'yes';
                    if(in_array(strtolower($amazon_order['shipping_service_level']),array('nextday','secondday'))){
                        $shipping_class .= '_'.strtolower($amazon_order['shipping_service_level']);
                    }
                    if($amazon_order['is_business_order'] == 'true'){
                        $customers_street_address = $amazon_order['bill_address_2'].' '.$amazon_order['bill_address_3'];
                        $customers_suburb = '';
                        $delivery_company = $amazon_order['ship_address_1'];
                        $delivery_street_address = $amazon_order['ship_address_2'].' '.$amazon_order['ship_address_3'];
                        $delivery_suburb = '';
                    }else{
                        $customers_street_address = $amazon_order['bill_address_1'].' '.$amazon_order['bill_address_2'];
                        $customers_suburb = $amazon_order['bill_address_3'];
                        $delivery_company = '';
                        $delivery_street_address = $amazon_order['ship_address_1'].' '.$amazon_order['ship_address_2'];
                        $delivery_suburb = $amazon_order['ship_address_3'];
                    }
                    $bill_country = yes_get_country_id_from_iso2($amazon_order['bill_country_code']);
                    $ship_country = yes_get_country_id_from_iso2($amazon_order['ship_country_code']);
                    $shipping_comments = ($amazon_order['delivery_instructions']) ? $amazon_order['delivery_instructions'] : '';
                    $insert_sql_array = array(
                            'comments'=>$amazon_order['order_id'],

                            'customers_id'=>$customers_id,
                            'customers_cid'=>'',
                            'customers_vat_id'=>'',
                            'customers_status'=>$customers_status_id,
                            'customers_status_name'=>$cs['customers_status_name'],
                            'customers_status_image'=>$cs['customers_status_image'],
                            'customers_status_discount'=>0,
                            'customers_name'=>$amazon_order['buyer_name'],
                            'customers_company'=>$amazon_order['buyer_company_name'],
                            'customers_street_address'=>$customers_street_address,
                            'customers_suburb'=>$customers_suburb,
                            'customers_city'=>$amazon_order['bill_city'],
                            'customers_postcode'=>$amazon_order['bill_postal_code'],
                            'customers_state'=>$amazon_order['bill_state'],
                            'customers_country'=>xtc_get_country_name($bill_country),
                            'customers_telephone'=>$amazon_order['buyer_phone_number'],
                            'customers_mobile'=>'',
                            'customers_email_address'=>$amazon_order['buyer_email'],
                            'customers_address_format_id'=>AMAZON_ADDRESS_FORMAT_ID,
                            'delivery_name'=>$amazon_order['recipient_name'],
                            'delivery_company'=>$delivery_company,
                            'delivery_street_address'=>$delivery_street_address,
                            'delivery_suburb'=>$delivery_suburb,
                            'delivery_city'=>$amazon_order['ship_city'],
                            'delivery_postcode'=>$amazon_order['ship_postal_code'],
                            'delivery_state'=>$amazon_order['ship_state'],
                            'delivery_country'=>xtc_get_country_name($ship_country),
                            'delivery_address_format_id'=>AMAZON_ADDRESS_FORMAT_ID,
                            'billing_name'=>$amazon_order['buyer_name'],
                            'billing_company'=>$amazon_order['buyer_company_name'],
                            'billing_street_address'=>$customers_street_address,
                            'billing_suburb'=>$customers_suburb,
                            'billing_city'=>$amazon_order['bill_city'],
                            'billing_postcode'=>$amazon_order['bill_postal_code'],
                            'billing_state'=>$amazon_order['bill_state'],
                            'billing_country'=>xtc_get_country_name($bill_country),
                            'billing_address_format_id'=>AMAZON_ADDRESS_FORMAT_ID,
                            'payment_method'=>'moneyorder',
                            'date_purchased'=>$amazon_order['purchase_date'],

                            'orders_status'=>$orders_status_id,
                            'orders_date_finished'=>null,
                            'currency'=>$amazon_order['currency'],
                            'currency_value'=>0.000000,
                            'account_type'=>0,
                            'payment_class'=>'moneyorder',
                            'shipping_method'=>$amazon_order['shipping_method'].'_'.$amazon_order['shipping_service_level'],
                            'shipping_class'=>$shipping_class,
                            'language'=>yes_get_language_folder(true),
                            'source'=>$source,
                            'amazon_prime'=>($amazon_order['is_prime'] == 'true'),
                            'shipping_comments'=>$shipping_comments,
                    );
                    xtc_db_perform('orders',$insert_sql_array);
                    $orders_id = xtc_db_insert_id();
                    $amazon_orders_id = xtc_db_insert_id();
                    foreach($amazon_order['items'] as $product){
                        foreach($product['price'] as $pp){
                            switch($pp['type']){
                                case 'Principal':
                                    $single_price = floatval($pp['amounts']['amount']) / intval($product['quantity_purchased']);
                                    $total_price = floatval($pp['amounts']['amount']);
                                    break;
                                case 'Shipping':
                                    $shipping_price = floatval($pp['amounts']['amount']);
                                    break;
                                case 'Shipping':
                                    $price_shipping = floatval($pp['amounts']['amount']);
                                    break;
                                case 'ShippingTax':
                                    $price_shipping_tax = floatval($pp['amounts']['amount']);
                                    break;
                                case 'Tax':
                                    $price_tax = floatval($pp['amounts']['amount']);
                                    break;
                                
                            }
                        }
                        $products_tax = 0;
                        $additional_costs = 0; // for amazon_features
                        if($product['products_id'] <= 0){
                                $tax_class_id = 1; // idR 19%
                                if(defined('MODULE_OTHER_AMAZON_DUMMY_PRODUCTS_ID') and MODULE_OTHER_AMAZON_DUMMY_PRODUCTS_ID > 0){
                                    $tax_class_id = yes_eu_oss_get_products_tax_class_id(MODULE_OTHER_AMAZON_DUMMY_PRODUCTS_ID, $ship_country_id);
                                    $product['products_id'] = MODULE_OTHER_AMAZON_DUMMY_PRODUCTS_ID;
                                }
                        }else{
                            // EU OSS
                            $tax_class_id = yes_eu_oss_get_products_tax_class_id($product['products_id'], $ship_country_id);
                        }
                        $tax_rate = xtc_get_tax_rate($tax_class_id,$ship_country_id);
                        $pname = $product['name'];
                        if($product['products_id'] > 0 and defined('MODULE_OTHER_AMAZON_PRODUCTS_NAME_FROM_AMAZON') and MODULE_OTHER_AMAZON_PRODUCTS_NAME_FROM_AMAZON == 'True'){
                                if($product['products_id'] != MODULE_OTHER_AMAZON_DUMMY_PRODUCTS_ID){
                                        $pname = xtc_get_products_name($product['products_id']);
                                }
                        }
                        $insert_sql_array = array(
                            'orders_id'=>$orders_id,
                            'products_id'=>$product['products_id'],
                            'products_model'=>$models[ $product['products_id'] ],
                            'products_name'=>$pname,
                            'products_price'=>$single_price,
                            'products_discount_made'=>0,
                            'final_price'=>$total_price,
                            'products_tax'=>$tax_rate,
                            'products_quantity'=>$product['quantity_purchased'],
                            'allow_tax'=>1,
                            'date_added'=>'now()',
                        );
                        xtc_db_perform('orders_products',$insert_sql_array);
                        $opID = xtc_db_insert_id();
                        $insert_sql_array = array(
                            'products_id'=>$product['products_id'],
                            'editor_id'=>0,
                            'date_saved'=>'now()',
                            'comments'=>sprintf('[Multi Order Import] '.$source.' Order %s / YES Auftrag %d: %d Stk',
                                    $amazon_order['order_id'],
                                    $orders_id,
                                    $product['quantity_purchased']
                            )
                        );
                        xtc_db_perform('products_history',$insert_sql_array);

                        // -------------------------------------------
                        // VERKAUFTE-PRODUKTE-COUNTER IN products HOCHSETZEN
                        // ** ABER NUR WENN DIE PID NICHT DER
                        // ** MODULE_OTHER_AMAZON_DUMMY_PRODUCTS_ID ENTSPRICHT
                        // -------------------------------------------
                        if($product['products_id'] >= 0 && (!defined('MODULE_OTHER_AMAZON_DUMMY_PRODUCTS_ID') or MODULE_OTHER_AMAZON_DUMMY_PRODUCTS_ID != $product['products_id'])){
                                xtc_db_query("update " . TABLE_PRODUCTS . " set products_ordered = products_ordered + " . sprintf('%d', $product['quantity_purchased'] ). " where products_id = '" . $product['products_id'] . "'");
                                if( sizeOf($YESproduct->collies)>0 and STOCK_ALLOW_CHECKOUT != 'true' ){
                                        foreach($YESproduct->collies as $k=>$collie){
                                                xtc_db_query("update " . TABLE_PRODUCTS . " set products_ordered = products_ordered + " . sprintf('%d', $product['quantity_purchased'] * $collie['quantity'] ). " where products_id = '" . $product['collie_products_id'] . "'");
                                        }
                                }
                        }

                        if($product['products_id'] > 0 and defined('EBAY_END_AUCTION_AT_SHOPORDER') and EBAY_END_AUCTION_AT_SHOPORDER == 'True'){
                                yes_end_auction_add($product['products_id'],$product['quantity_purchased']);
                        }
                    } // end foreach items
                    // -------------------------------------------
                    // SUBTOTAL
                    // -------------------------------------------
                    $orders_total_subtotal_array = array(
                        'orders_id'=>$orders_id,
                        'title'=>MODULE_ORDER_TOTAL_SUBTOTAL_TITLE.':',
                        'text'=>number_format($price_brutto,2,',','.').' '.$currency,
                        'value'=>$price_brutto,
                        'class'=>'ot_subtotal',
                        'sort_order'=>MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER
                    );
                    xtc_db_perform(TABLE_ORDERS_TOTAL, $orders_total_subtotal_array);

                    // -------------------------------------------
                    // SHIPPINGTOTAL
                    // -------------------------------------------
                    $orders_total_shipping_array = array(
                        'orders_id'=>$orders_id,
                        'title'=>'Shipping',
                        'text'=>number_format($shipping_costs,2,',','.').' '.$currency,
                        'value'=>$shipping_costs,
                        'class'=>'ot_shipping',
                        'sort_order'=>MODULE_ORDER_TOTAL_SHIPPING_SORT_ORDER
                    );
                    xtc_db_perform(TABLE_ORDERS_TOTAL, $orders_total_shipping_array);

                    // -------------------------------------------
                    // VATTOTAL
                    // -------------------------------------------
                    // WIR BERECHNEN UNSERE EIGENE SHIPPINGCOSTS-MWST
                    if($shipping_costs > 0){
                        $shipping_costs_netto = $shipping_costs / ((100+$tax_rate)/100);
                    }else{
                        $shipping_costs_netto = 0; // nicht durch null teilen, darum so
                    }
                    $shipping_tax = $shipping_costs - $shipping_costs_netto;
                    $products_price_tax = ($price_brutto - $price_netto);
                    /**
                     * Versand Steuerklasse gleich Produkt Steuerklasse
                     * Wir addieren beide und haben die gesamte Steuer
                     */
                    $ot_tax_value = $shipping_tax + $products_price_tax;
                    $orders_total_tax_array = array(
                            'orders_id'=>$orders_id,
                            'title'=>sprintf('USt %s%%',
                                    number_format($tax_rate,0,',','.')),
                            'text'=> number_format($ot_tax_value,2,',','.' ).' '.$currency,
                            'value'=>$ot_tax_value,
                            'class'=>'ot_tax',
                            'sort_order'=>MODULE_ORDER_TOTAL_TAX_SORT_ORDER,
                        'tax_rate_percent'=>$tax_rate
                    );
                    xtc_db_perform(TABLE_ORDERS_TOTAL, $orders_total_tax_array);

                    // -------------------------------------------
                    // TOTAL
                    // -------------------------------------------
                    $orders_total_total_array = array(
                            'orders_id'=>$orders_id,
                            'title'=>MODULE_ORDER_TOTAL_TOTAL_TITLE,
                            'text'=>number_format($price_brutto+$shipping_costs+$additional_costs,2,',','.').' '.$currency,
                            'value'=>$price_brutto+$shipping_costs+$additional_costs,
                            'class'=>'ot_total',
                            'sort_order'=>MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER
                    );
                    xtc_db_perform(TABLE_ORDERS_TOTAL, $orders_total_total_array);

                    // ----------------------------------------------------
                    // IN BESTELLHISTORIE HINZUFUEGEN orders_status_history
                    // ----------------------------------------------------
                    $customer_notification = (SEND_EMAILS == 'true') ? '1' : '0';
                    $order_history_sql_array = array(
                            'orders_id' => $orders_id,
                            'orders_status_id' => $orders_status_id,
                            'date_added' => 'now()',
                            'customer_notified' => $customer_notification,
                            'comments' => 'Multi Order Import'
                    );
                    xtc_db_perform(TABLE_ORDERS_STATUS_HISTORY, $order_history_sql_array);
                }


        $messageStack->add_session('Multi Order Import done','success');
        xtc_redirect(xtc_href_link(FILENAME_ORDERS));
    }
    $smarty->assign([
        'PREVIEW'=>1,
        'VALUES'=>$amazon_values,
        'INPUT_CS'=>xtc_draw_pull_down_menu('customers_status',xtc_get_customers_statuses(),2),
        'INPUT_SOURCE'=>xtc_draw_pull_down_menu('orders_source',\main::get_order_sources(),'shop'),
        'INPUT_OS'=>xtc_draw_pull_down_menu('orders_status',xtc_get_orders_status(),1),
    ]);
}else{
    
}
yes_draw_pre_header();
yes_draw_header('Multi Order Import');
$smarty->assign([
    'language_path'=>DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
    'HEADING_TITLE'=>'Multi Order Import'
]);
$smarty->display('orders.multi_import.html');

include('includes/footer.php');
include('includes/application_bottom.php');
