<?php
/* -----------------------------------------------------------------------------------------
   $Id: checkout_payment_address.php,v 1.9 2018/02/14 06:48:50 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(checkout_payment_address.php,v 1.13 2003/05/27); www.oscommerce.com 
   (c) 2003	 nextcommerce (checkout_payment_address.php,v 1.14 2003/08/17); www.nextcommerce.org

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/

include( 'includes/application_top.php');
require_once(DIR_FS_INC.'xtc_get_countries_with_iso_codes.inc.php');
// create smarty elements
$smarty = new yesSmarty;
// include boxes
$popup = (isset($_GET['popup']) and $_GET['popup'] == 1) ? true : false;
if(!$popup){
    $YesBoxes->load( $smarty, basename(__FILE__) );
}
// include needed functions
require_once(DIR_FS_INC . 'xtc_count_customer_address_book_entries.inc.php');
require_once(DIR_FS_INC . 'xtc_address_label.inc.php');
require_once(DIR_FS_INC . 'xtc_draw_radio_field.inc.php');
require_once(DIR_FS_INC . 'xtc_image_button.inc.php');

if (is_array($_SESSION['nvpReqArray'])) {
	$link_checkout_payment = FILENAME_PAYPAL_CHECKOUT;
} else {
	$link_checkout_payment = FILENAME_CHECKOUT_PAYMENT;
}
$no_customer_id = false;
if(isset($_SESSION['payment']) and $_SESSION['payment'] == 'yes_ppp'){
    $order = new order('',$xtcPrice);
    $no_customer_id = !isset($_SESSION['customer_id']);
    if($no_customer_id){
        if(isset($_SESSION['YES_PPP']['yes_billing_address'])){
            $order->customer = $_SESSION['YES_PPP']['yes_billing_address'];
        }else{
            $pp = new \YES4Trade\Model\paypal_api();
            $pp_order = $pp->getOrder($pp->getOrderToken());
            $order->customer = \YES4Trade\Model\paypal_api::get_yes_orders_customer_array($pp_order);
        }
        $order->customer['country'] = xtc_get_country_name($_SESSION['YES_PPP']['yes_billing_address']['country']);
    }
}

if (!isset($_SESSION['customer_id']) and $no_customer_id === false) {
    xtc_redirect(xtc_href_link(FILENAME_LOGIN, '', 'SSL'));
}

// if there is nothing in the customers cart, redirect them to the shopping cart page
if ($_SESSION['cart']->count_contents() < 1) {
    xtc_redirect(xtc_href_link(FILENAME_SHOPPING_CART));
}


$error = false;
$process = false;
$json = (isset($_POST['mode']) and $_POST['mode'] == 'json') ? true : false;
if (isset($_POST['action']) && ($_POST['action'] == 'submit')) {
    // process a new billing address
    if (xtc_not_null($_POST['firstname']) && xtc_not_null($_POST['lastname']) && xtc_not_null($_POST['street_address'])) {
        $process = true;

        if (ACCOUNT_GENDER == 'true') $gender = xtc_db_prepare_input($_POST['gender']);
        if (ACCOUNT_COMPANY == 'true') $company = xtc_db_prepare_input($_POST['company']);
        $firstname = xtc_db_prepare_input($_POST['firstname']);
        $lastname = xtc_db_prepare_input($_POST['lastname']);
        $street_address = xtc_db_prepare_input($_POST['street_address']);
        if (ACCOUNT_SUBURB == 'true') $suburb = xtc_db_prepare_input($_POST['suburb']);
        $postcode = xtc_db_prepare_input($_POST['postcode']);
        $city = xtc_db_prepare_input($_POST['city']);
        $country = xtc_db_prepare_input($_POST['country']);
        if (ACCOUNT_STATE == 'true') {
            $zone_id = xtc_db_prepare_input($_POST['zone_id']);
            $state = xtc_db_prepare_input($_POST['state']);
        }

        if (ACCOUNT_GENDER == 'true') {
            if ( ($gender != 'm') && ($gender != 'f') ) {
                $error = true;
                if($json){
                    $error_array[] = ENTRY_GENDER_ERROR;
                }else{
                    $messageStack->add('checkout_address', ENTRY_GENDER_ERROR);
                }
            }
        }

        if (strlen($firstname) < ENTRY_FIRST_NAME_MIN_LENGTH) {
            $error = true;
            if($json){
                $error_array[] = ENTRY_FIRST_NAME_ERROR;
            }else{
                $messageStack->add('checkout_address', ENTRY_FIRST_NAME_ERROR);
            }
        }

        if (strlen($lastname) < ENTRY_LAST_NAME_MIN_LENGTH) {
            $error = true;
            if($json){
                $error_array[] = ENTRY_LAST_NAME_ERROR;
            }else{
                $messageStack->add('checkout_address', ENTRY_LAST_NAME_ERROR);
            }
        }

        if (strlen($street_address) < ENTRY_STREET_ADDRESS_MIN_LENGTH) {
            $error = true;
            if($json){
                $error_array[] = ENTRY_STREET_ADDRESS_ERROR;
            }else{
                $messageStack->add('checkout_address', ENTRY_STREET_ADDRESS_ERROR);
            }
        }

        if (strlen($postcode) < ENTRY_POSTCODE_MIN_LENGTH) {
            $error = true;
            if($json){
                $error_array[] = ENTRY_POST_CODE_ERROR;
            }else{
                $messageStack->add('checkout_address', ENTRY_POST_CODE_ERROR);
            }
        }

        if (strlen($city) < ENTRY_CITY_MIN_LENGTH) {
            $error = true;
            if($json){
                $error_array[] = ENTRY_CITY_ERROR;
            }else{
                $messageStack->add('checkout_address', ENTRY_CITY_ERROR);
            }
        }

        if (ACCOUNT_STATE == 'true') {
            $zone_id = 0;
            $parameters = [
                'zone_country_id'=>(int)$country
            ];
            $check_query_raw = sprintf("select count(*) as total from %s where zone_country_id = :zone_country_id",
                TABLE_ZONES
            );
            $check = yes_query($check_query_raw, $parameters,true);
            $entry_state_has_zones = ($check['total'] > 0);
            if ($entry_state_has_zones == true) {
                $parameters = [
                    'zone_country_id' => (int)$country,
                    'zone_name'=>$state . '%',
                    'zone_code'=>'%' . $state . '%'
                ];
                $zone_query_raw = sprintf("select distinct zone_id from %s where zone_country_id = :zone_country_id and (zone_name like :zone_name or zone_code like :zone_code)",
                    TABLE_ZONES
                );
                $zone_query = yes_query($zone_query_raw, $parameters);
                if (sizeOf($zone_query) == 1) {
                    $zone = current($zone_query);
                    $zone_id = $zone['zone_id'];
                } else {
                    $error = true;
                    if($json){
                        $error_array[] = ENTRY_STATE_ERROR_SELECT;
                    }else{
                        $messageStack->add('checkout_address', ENTRY_STATE_ERROR_SELECT);
                    }
                }
            } else {
                if (strlen($state) < ENTRY_STATE_MIN_LENGTH) {
                    $error = true;
                    if($json){
                        $error_array[] = ENTRY_STATE_ERROR;
                    }else{
                        $messageStack->add('checkout_address', ENTRY_STATE_ERROR);
                    }
                }
            }
        }

        if ( (is_numeric($country) == false) || ($country < 1) ) {
            $error = true;
            if($json){
                $error_array[] = ENTRY_COUNTRY_ERROR;
            }else{
                $messageStack->add('checkout_address', ENTRY_COUNTRY_ERROR);
            }
        }

        if ($error == false) {
            if($no_customer_id){
                    // update paypal address
                if(isset($_SESSION['payment']) and $_SESSION['payment'] == 'yes_ppp'){
                    $post_data = $_POST;
                    $isos = xtc_get_countries_with_iso_codes(intval($post_data['country']));
                    $post_data['country'] = [
                        'id' => intval($post_data['country']),
                        'title' => $isos['countries_name'],
                        'iso_code_2' => $isos['countries_iso_code_2'],
                        'iso_code_3' => $isos['countries_iso_code_3']
                    ];

                    $_SESSION['YES_PPP']['yes_billing_address'] = $post_data;
                    xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_SHIPPING));		
                }
            }else{

                $sql_data_array = array(
                    'customers_id' => (int)$_SESSION['customer_id'],
                    'entry_firstname' => $firstname,
                    'entry_lastname' => $lastname,
                    'entry_street_address' => $street_address,
                    'entry_postcode' => $postcode,
                    'entry_city' => $city,
                    'entry_country_id' => (int)$country
                );

                if (ACCOUNT_GENDER == 'true') {
                    $sql_data_array['entry_gender'] = $gender;
                }
                if (ACCOUNT_COMPANY == 'true') {
                    $sql_data_array['entry_company'] = $company;
                }
                if (ACCOUNT_SUBURB == 'true') {
                    $sql_data_array['entry_suburb'] = $suburb;
                }
                if (ACCOUNT_STATE == 'true') {
                if ($zone_id > 0) {
                    $sql_data_array['entry_zone_id'] = (int)$zone_id;
                    $sql_data_array['entry_state'] = '';
                } else {
                    $sql_data_array['entry_zone_id'] = 0;
                    $sql_data_array['entry_state'] = $state;
                }
                }
                if($json){
                    foreach($sql_data_array as $k=>$v){
                        if(!is_int($v)){
                            $sql_data_array[$k] = yes_decode_string($v);
                        }
                    }
                }
                $new = new \YES4Trade\Model\address_book($sql_data_array);
                $abID = $new->create();
                $_SESSION['billto'] = $abID;

                if (isset($_SESSION['payment'])) {
                    unset($_SESSION['payment']);
                }

                if(!$json){
                    xtc_redirect(xtc_href_link($link_checkout_payment, '', 'SSL'));
                }
            }
            if($json){
                $msg = implode("\r\n",$error_array);
                header('Content-Type: text/html; charset='.CHARSET);
                die(json_encode(array(
                    'MSG'=>yes_encode_string($msg)
                )));
            }
        }
      // process the selected billing destination
    } elseif (isset($_POST['address'])) {
      $reset_payment = false;
      if (isset($_SESSION['billto'])) {
        if ($billto != $_POST['address']) {
          if (isset($_SESSION['payment'])) {
            $reset_payment = true;
          }
        }
      }

      $_SESSION['billto'] = $_POST['address'];
      $anz = \YES4Trade\Model\address_book::get_by_customers_id_and_address_book_id(
            (int)$_SESSION['customer_id'],
            (int)$_SESSION['billto']
      );

      if ($anz == 1) {
        if ($reset_payment == true) {
            unset($_SESSION['payment']);
        }
	xtc_redirect(xtc_href_link($link_checkout_payment, '', 'SSL'));
      } else {
        unset($_SESSION['billto']);
      }
      // no addresses to select from - customer decided to keep the current assigned address
    } else {
      $_SESSION['billto'] = $_SESSION['customer_default_address_id'];

	xtc_redirect(xtc_href_link($link_checkout_payment, '', 'SSL'));
    }
} // end if submit

  // if no billing destination address was selected, use their own address as default
if (!isset($_SESSION['billto'])) {
    $_SESSION['billto'] = $_SESSION['customer_default_address_id'];
}

$breadcrumb->add(NAVBAR_TITLE_1_PAYMENT_ADDRESS, xtc_href_link($link_checkout_payment, '', 'SSL'));
$breadcrumb->add(NAVBAR_TITLE_2_PAYMENT_ADDRESS, xtc_href_link(FILENAME_CHECKOUT_PAYMENT_ADDRESS, '', 'SSL'));
$addresses_count = xtc_count_customer_address_book_entries();
if(!$popup){
    require(DIR_WS_INCLUDES . 'header.php');
}

$smarty->assign('FORM_ACTION',xtc_draw_form('checkout_address', xtc_href_link(FILENAME_CHECKOUT_PAYMENT_ADDRESS, '', 'SSL'), 'post', 'onSubmit="return check_form_optional(checkout_address);"'));
if ($messageStack->size('checkout_address') > 0) {
    $smarty->assign('error',$messageStack->output('checkout_address'));
}

if ($process == false) {
    if($no_customer_id === false){
        $smarty->assign('ADDRESS_LABEL',xtc_address_label($_SESSION['customer_id'], $_SESSION['billto'], true, ' ', '<br>'));
    }else{
        $smarty->assign('ADDRESS_LABEL',xtc_address_label_no_customer_id($order->customer, true, ' ', '<br>'));
        $addresses_count = 0;
    }
    if ($addresses_count > 1) {
	$address_content_array = array();
	$address_content='<table border="0" width="100%" cellspacing="0" cellpadding="0">';
	$radio_buttons = 0;
    $items = \YES4Trade\Model\address_book::get_by_customers_id((int)$_SESSION['customer_id']);
	foreach($items as $it){
	    $format_id = xtc_get_address_format_id($it->entry_country_id);
	    $address_content.=' <tr>
                <td>'. xtc_draw_separator('pixel_trans.gif', '10', '1').'</td>
                <td colspan="2"><table border="0" width="100%" cellspacing="0" cellpadding="2">
                ';
            if ($it->address_book_id == $_SESSION['billto']) {
              $address_content.='                  <tr id="defaultSelected" class="moduleRowSelected" onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)" onclick="selectRowEffect(this, ' . $radio_buttons . ')">' . "\n";
            } else {
              $address_content.= '                  <tr class="moduleRow" onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)" onclick="selectRowEffect(this, ' . $radio_buttons . ')">' . "\n";
            }
            $addresses = [];
            $address_raw = $it->toArray();
            foreach($address_raw as $ark=>$arv){
                $arkn = str_replace('entry_','',$ark);
                $addresses[ $arkn ] = $arv;
            }
            $address_content.='
                    <td width="10">'. xtc_draw_separator('pixel_trans.gif', '10', '1').'</td>
                    <td class="main" colspan="2"><b>'. $addresses['firstname'] . ' ' . $addresses['lastname'].'</b></td>
                    <td class="main" align="right">'. xtc_draw_radio_field('address', $it->address_book_id, ($it->address_book_id == $_SESSION['billto'])).'</td>
                    <td width="10">'. xtc_draw_separator('pixel_trans.gif', '10', '1').'</td>
                  </tr>
                  <tr>
                    <td width="10">'. xtc_draw_separator('pixel_trans.gif', '10', '1').'</td>
                    <td colspan="3"><table border="0" cellspacing="0" cellpadding="2">
                      <tr>
                        <td width="10">'. xtc_draw_separator('pixel_trans.gif', '10', '1').'</td>
                        <td class="main">'. xtc_address_format($format_id, $addresses, true, ' ', ', ').'</td>
                        <td width="10">'. xtc_draw_separator('pixel_trans.gif', '10', '1').'</td>
                      </tr>
                    </table></td>
                    <td width="10">'. xtc_draw_separator('pixel_trans.gif', '10', '1').'</td>
                  </tr>
                </table></td>
                <td>'. xtc_draw_separator('pixel_trans.gif', '10', '1').'</td>
              </tr>';
	$address_content_array[] = array(
	    'ADDRESS'=>$addresses,
	    'INPUT'=>xtc_draw_radio_field('address', $it->address_book_id, ($it->address_book_id == $_SESSION['billto'])),
	    'ADDRESS_FORMATTED'=>xtc_address_format($format_id, $addresses, true, ' ', ', ')
	);
        $radio_buttons++;
      }
      $address_content.='</table>';
      $smarty->assign(array(
	    'BLOCK_ADDRESS'=>$address_content,
	    'ADDRESSES'=>$address_content_array
      ));
    }
} // end if process false

if ($addresses_count < MAX_ADDRESS_BOOK_ENTRIES) {
    require(DIR_WS_MODULES . 'checkout_new_address.php');
}
$smarty->assign('BUTTON_CONTINUE',xtc_draw_hidden_field('action', 'submit') . xtc_image_submit('button_continue.gif', IMAGE_BUTTON_CONTINUE));
if ($process == true) {
    $smarty->assign('BUTTON_BACK','<a href="' . xtc_href_link(FILENAME_CHECKOUT_PAYMENT_ADDRESS, '', 'SSL') . '">' . xtc_image_button('button_back.gif', IMAGE_BUTTON_BACK) . '</a>');
}

$smarty->assign('language', $_SESSION['language']);

$smarty->caching = 0;
$main_content= $smarty->fetch(CURRENT_TEMPLATE.'/module/checkout_payment_address.html');
if(!$popup){
    $smarty->assign('language', $_SESSION['language']);
    $smarty->assign('main_content',$main_content);
    $smarty->caching = 0;
    if (!defined('RM')) $smarty->load_filter('output', 'note');
      $smarty->display(CURRENT_TEMPLATE . '/index.html');
}else{
    echo $main_content;
}
include ('includes/application_bottom.php');
