<?php
/* -----------------------------------------------------------------------------------------
   $Id: xtc_get_path.inc.php,v 1.2 2008/05/26 09:23:45 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(general.php,v 1.225 2003/05/29); www.oscommerce.com 
   (c) 2003	 nextcommerce (xtc_get_path.inc.php,v 1.3 2003/08/13); www.nextcommerce.org

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/
   
function xtc_get_path($current_category_id = '') {
    global $cPath_array,$InstanceCache;
    if (xtc_not_null($current_category_id)) {
        $cp_size = (is_array($cPath_array))?sizeof($cPath_array):0;
        if ($cp_size == 0) {
            $cPath_new = $current_category_id;
        } else {
            $cache_key = 'shop.categories.path_cid-'.$current_category_id;
            $cache_group = 'categories';
            $key = \yescache_helper::cache_key($InstanceCache, $cache_group, $cache_key);

            $CachedString = $InstanceCache->getItem($key); // cache group

            if (!$CachedString->isHit()) {
                $cPath_new = '';
                $last_category_query = "select parent_id from " . TABLE_CATEGORIES . " where categories_id =:categories_id";
                $last_category_query  = yes_query($last_category_query,[
                    'categories_id'=>$cPath_array[($cp_size-1)]
                ]);
                if(sizeOf($last_category_query)){
                    $last_category = current($last_category_query);
                }

                $current_category_query_raw = "select parent_id from " . TABLE_CATEGORIES . " where categories_id =:categories_id";
                $current_category_query  = yes_query($current_category_query_raw,[
                    'categories_id'=>$current_category_id
                ]);
                if(sizeOf($current_category_query)){
                    $current_category = current($current_category_query);
                }

                if ($last_category['parent_id'] == $current_category['parent_id']) {
                    for ($i=0; $i<($cp_size-1); $i++) {
                        $cPath_new .= '_' . $cPath_array[$i];
                    }
                } else {
                    for ($i=0; $i<$cp_size; $i++) {
                        $cPath_new .= '_' . $cPath_array[$i];
                    }
                }
                $cPath_new .= '_' . $current_category_id;

                if (substr($cPath_new, 0, 1) == '_') {
                    $cPath_new = substr($cPath_new, 1);
                }
                $CachedString->set($cPath_new)->expiresAfter(YES_CACHE_LIFETIME_LONG);//cat
                $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
            }else{
                $cPath_new = $CachedString->get();
            }
        }
    } else {
        // bugfix php8
      if( !empty($cPath_array)){
        $cPath_new = @implode('_', $cPath_array);
      }else{
          $cPath_new = '';
      }
    }
    return 'cPath=' . $cPath_new;
}
