<?php
/* -----------------------------------------------------------------------------------------
   $Id: xtc_get_uprid.inc.php,v 1.4 2017/10/19 07:37:07 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(general.php,v 1.225 2003/05/29); www.oscommerce.com 
   (c) 2003	 nextcommerce (xtc_get_uprid.inc.php,v 1.3 2003/08/13); www.nextcommerce.org

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/
   
// Return a product ID with attributes
// MARIO 01.03.13 - umgeschrieben auf properties

function xtc_get_uprid($prid, $properties_params = null) {
	if (is_numeric($prid)) {
            $uprid = $prid;
            if (is_array($properties_params) && (sizeof($properties_params) > 0)) {
                $properties_ids = sprintf('{%s}',implode(',',$properties_params));
                $uprid .= $properties_ids;
            }
	} else {
            $uprid = xtc_get_prid($prid);

            if (is_numeric($uprid)) {
                if (strpos($prid, '{') !== false) {
                    $attributes = explode('{', substr($prid, strpos($prid, '{')+1));
                    $pairs = explode('}', $attributes[0]);
                    $pairs = explode(',', current($pairs));
                    $properties_ids = sprintf('{%s}',implode(',',$pairs));
                    $uprid .= $properties_ids;
                }
            } else {
                    return false;
            }
	}
	return $uprid;
}
