<?php
/* -----------------------------------------------------------------------------------------
   $Id: shopping_cart.php,v 1.37 2019/09/27 07:09:51 ssh-511548-cvs Exp $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(shopping_cart.php,v 1.32 2003/02/11); www.oscommerce.com
   (c) 2003	 nextcommerce (shopping_cart.php,v 1.21 2003/08/17); www.nextcommerce.org

   Released under the GNU General Public License
   -----------------------------------------------------------------------------------------
   Third Party contributions:

   Customers Status v3.x  (c) 2002-2003 Copyright Elari elari@free.fr | www.unlockgsm.com/dload-osc/ | CVS : http://cvs.sourceforge.net/cgi-bin/viewcvs.cgi/elari/?sortby=date#dirlist

   Credit Class/Gift Vouchers/Discount Coupons (Version 5.10)
   http://www.oscommerce.com/community/contributions,282
   Copyright (c) Strider | Strider@oscworks.com
   Copyright (c  Nick Stanko of UkiDev.com, nick@ukidev.com
   Copyright (c) Andre ambidex@gmx.net
   Copyright (c) 2001,2002 Ian C Wilson http://www.phesis.org

   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/

// include needed functions
require_once(DIR_FS_INC . 'xtc_create_random_value.inc.php');
require_once(DIR_FS_INC . 'xtc_get_prid.inc.php');
require_once(DIR_FS_INC . 'xtc_draw_form.inc.php');
require_once(DIR_FS_INC . 'xtc_draw_input_field.inc.php');
require_once(DIR_FS_INC . 'xtc_image_submit.inc.php');
require_once(DIR_FS_INC . 'xtc_get_prid.inc.php');
require_once(DIR_FS_INC . 'xtc_get_tax_description.inc.php');
require_once(DIR_FS_INC . 'xtc_in_array.inc.php');
require_once (DIR_FS_INC.'xtc_collis.inc.php');
require_once (DIR_FS_INC.'xtc_date_short.inc.php');
require_once (DIR_FS_INC.'xtc_count_shipping_modules.inc.php');


class shoppingCart {
    var $contents, $total, $weight, $cartID, $content_type,$tax, $total_discount;

    function __construct() {
        $this->reset();
    }

    function restore_contents() {
        if (!isset($_SESSION['customer_id'])){
            return false;
        }
        // insert current cart contents in database
        if (is_array($this->contents)) {
            reset($this->contents);
            foreach($this->contents as $products_id=>$egal){
                $qty = $this->contents[$products_id]['qty'];
                $product_query = yes_query(
                    "select products_id from " . TABLE_CUSTOMERS_BASKET . " where customers_id =:customers_id and products_id =:products_id",
                    [
                        'customers_id'=> (int)$_SESSION['customer_id'],
                        'products_id'=> $products_id
                    ]
                );
                    
                if (!sizeOf($product_query)) {
                    $insert_sql_array = [
                        'customers_id'=>(int)$_SESSION['customer_id'], 
                        'products_id'=>$products_id, 
                        'customers_basket_quantity'=>(int)$qty, 
                        'customers_basket_date_added'=>date('Ymd')
                    ];
                    yes_db_perform(TABLE_CUSTOMERS_BASKET,$insert_sql_array);
                    $cbID = xtc_db_insert_id();
                } else {
                    $update_sql_array = [
                        'customers_basket_quantity' => (int) $qty
                    ];
                    yes_db_perform(TABLE_CUSTOMERS_BASKET, $update_sql_array,'update',[
                        'customers_id' => (int) $_SESSION['customer_id'],
                        'products_id' => $products_id
                    ]);
                }
            }
        }
        // reset per-session cart contents, but not the database contents
        $this->reset(false);

        $records = array();
        $products_query = yes_query(
            "select customers_basket_id,products_id, customers_basket_quantity from " . TABLE_CUSTOMERS_BASKET . " where customers_id =:customers_id",
            ['customers_id'=>(int) $_SESSION['customer_id']]
        );
        foreach($products_query as $products) {
            $records[] = $products;
        }
        foreach($records as $products){
            $this->contents[$products['products_id']] = array(
                'qty' => $products['customers_basket_quantity']
            );
        }
        $this->cleanup();
    }

    function reset($reset_database = false) {
        $this->contents = array();
        $this->total = 0;
        $this->weight = 0;
// BOF - Tomcraft - 2009-10-03 - Paypal Express Modul
        $this->tax = 0;
// EOF - Tomcraft - 2009-10-03 - Paypal Express Modul
        $this->content_type = false;

        if (isset($_SESSION['customer_id']) && ($reset_database == true)) {
            $records = array();
            $query = yes_query(sprintf(
                "SELECT customers_basket_id FROM %s WHERE customers_id=:customers_id",
                    TABLE_CUSTOMERS_BASKET
                ),['customers_id'=>(int)$_SESSION['customer_id']]
            );
            foreach($query as $record) {
                $records[] = $record['customers_basket_id'];
            }
            foreach($records as $cbID){
                yes_query("delete from " . TABLE_CUSTOMERS_BASKET . " where customers_basket_id=:cb_id",
                   ['cb_id'=>(int)$cbID]
                );
            }
        }
        unset($this->cartID);
        if (isset($_SESSION['cartID'])){
            unset($_SESSION['cartID']);
        }
    }

    function add_cart($products_id, $qty = '1', $notify = true,$properties = array() ) {
        global $new_products_id_in_cart;
        $products_id = xtc_get_uprid($products_id, $properties);
	    // BOF - WAR VORHER NUR WENN ARTIKEL NOCH NICHT IM CART
	    if ($notify == true) {
		    $_SESSION['new_products_id_in_cart'] = $products_id;
	    }
	    // EOF - WAR VORHER NUR WENN ARTIKEL NOCH NICHT IM CART
        if ($this->in_cart($products_id)) {
            $this->update_quantity($products_id, $qty);
        } else {
            $this->contents[] = array($products_id);
            $this->contents[$products_id] = array('qty' => $qty);
            // insert into database
            if (isset($_SESSION['customer_id'])) {
                $insert_sql_array = [
                    'customers_id'=>intval($_SESSION['customer_id']),
                    'products_id'=>$products_id,
                    'customers_basket_quantity'=>(int)$qty, 
                    'customers_basket_date_added'=>date('Ymd')
                ];
                yes_db_perform(TABLE_CUSTOMERS_BASKET, $insert_sql_array);
            }
        }
        $this->cleanup();
        // assign a temporary unique ID to the order contents to prevent hack attempts during the checkout procedure
        $this->cartID = $this->generate_cart_id();
    }

    function update_quantity($products_id, $quantity = '') {
        if (empty($quantity)){ 
            return true; // nothing needs to be updated if theres no quantity, so we return true..
        }
        $this->contents[$products_id] = array(
            'qty' => $quantity,
        );
        // update database
        if (isset($_SESSION['customer_id'])) {
            yes_db_perform(TABLE_CUSTOMERS_BASKET, 
                ['customers_basket_quantity' => (int)$quantity],
                'update',[
                    'customers_id' => (int)$_SESSION['customer_id'],
                    'products_id' => $products_id
                ]
            );
        }
    }

    function cleanup() {
        reset($this->contents);
        foreach ($this->contents as $key=>$egal) {
            if ($this->contents[$key]['qty'] > 0) {
                continue;
            }
            unset($this->contents[$key]);
            // remove from database
            if (xtc_session_is_registered('customer_id')) {
                $records = array();
                $query = yes_query(sprintf(
                    "SELECT customers_basket_id FROM %s WHERE customers_id=:customers_id and products_id =:products_id",
                        TABLE_CUSTOMERS_BASKET
                    ),[
                        'customers_id'=>(int)$_SESSION['customer_id'],
                        'products_id'=>$key
                    ]
                );
                foreach($query as $record) {
                    $records[] = (int)$record['customers_basket_id'];
                }
                foreach($records as $cbID){
                    xtc_db_query(sprintf(
                        "delete from %s where customers_basket_id='%d'",
                        TABLE_CUSTOMERS_BASKET,
                        intval($cbID)
                    ));
                }
            }
        }
    }

    function count_contents() {  // get total number of items in cart 
        $total_items = 0;
        if (!is_array($this->contents)) {
            return $total_items;
        }
        reset($this->contents);
        foreach($this->contents as $products_id=>$uninteressant) {
            $total_items += $this->get_quantity($products_id);
        }
        return $total_items;
    }

    function get_quantity($products_id) {
        if (isset($this->contents[$products_id]) and isset($this->contents[$products_id]['qty'])) {
            return $this->contents[$products_id]['qty'];
        }
        return 0;
    }


    function in_cart($products_id) {
        if (isset($this->contents[$products_id])) {
          return true;
        }
        return false;
    }

    function remove($products_id) {
        unset($this->contents[$products_id]);
        // remove from database
        if (xtc_session_is_registered('customer_id')) {
            $records = array();
            $query = yes_query(sprintf(
                "SELECT customers_basket_id FROM %s WHERE customers_id=:customers_id and products_id =:products_id",
                    TABLE_CUSTOMERS_BASKET
                ),[
                    'customers_id'=>(int)$_SESSION['customer_id'],
                    'products_id'=>$products_id
                ]
            );
            foreach($query as $record) {
                $records[] = (int)$record['customers_basket_id'];
            }
            foreach($records as $cbID){
                xtc_db_query(sprintf(
                    "delete from %s where customers_basket_id='%d'",
                    TABLE_CUSTOMERS_BASKET,
                    intval($cbID)
                ));
            }
        }

        // assign a temporary unique ID to the order contents to prevent hack attempts during the checkout procedure
        $this->cartID = $this->generate_cart_id();
    }

    function remove_all() {
        $this->reset();
    }

    function get_product_id_list() {
        $product_id_list = '';
        if (is_array($this->contents)) {
            reset($this->contents);
            foreach($this->contents as $products_id=>$uninteressant) {
                $product_id_list .= ', ' . $products_id;
            }
        }
        return substr($product_id_list, 2);
    }

    /**
     * 
     * total, total_discount, weight und tax berechnen
     */
    function calculate( ) {
        $this->total = 0;
        $this->weight = 0;
        $this->tax = array();
        // BOF - Tomcraft - 2009-10-03 - Paypal Express Modul
        $this->total_discount = array ();
        // EOF - Tomcraft - 2009-10-03 - Paypal Express Modul
        $customers_status = $_SESSION['customers_status']['customers_status_id'];
        if (!is_array($this->contents)) return 0;

        reset($this->contents);
        $xtPrice = new xtcPrice($_SESSION['currency'],$customers_status);

        // EU-OSS 2021/07
        
        $country_id = (isset($_SESSION['default_shipping_countries_id']) and $_SESSION['default_shipping_countries_id'] > 0) ? $_SESSION['default_shipping_countries_id'] : yes_get_store_country_id();
        
        $zone_id =  (isset($_SESSION['default_shipping_zone_id'])) ? $_SESSION['default_shipping_zone_id'] : 0;
        
        // BOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
        /*if(yes_eu_oss_use_country_handling($country_id)){
            $xtPrice->setCountryZone($country_id,$zone_id);
        }*/
        // EOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
        
        // BUGF_CH_OSS - IMMER ZONE/COUNTRY - STATT OBEREN BLOCK
        $xtPrice->setCountryZone($country_id,$zone_id);

        foreach($this->contents as $products_id=>$uninteressant) {
            $qty = ((isset($this->contents[$products_id]['qty']))?$this->contents[$products_id]['qty']:0);
            // products price
            $product = yes_query(
                "select products_id, products_price, products_discount_allowed, products_weight from " . TABLE_PRODUCTS . " where products_id=:products_id",
                ['products_id'=> xtc_get_prid($products_id)],
                true
            );
            // EU-OSS 2021/07
            $products_tax_class_id = yes_eu_oss_get_products_tax_class_id(xtc_get_prid($products_id),$country_id);
            $format=false;
            $products_price=$xtPrice->xtcGetPrice(xtc_get_prid($products_id),
                $format,
                $qty,
                // EU-OSS 2021/07
                $products_tax_class_id,
                (float)$product['products_price']
            );
            
            $properties = $this->get_properties_array( $products_id );
            $xy = \YES4Trade\Model\product_properties_xy_prices::get_from_products_id((int)xtc_get_prid($products_id));
            if($xy !== false){
            
                foreach($properties as $pp_item){
                    if($pp_item['products_properties_id'] == $xy->products_properties_id_X){
                        $X = $pp_item['value'];
                    }
                    if($pp_item['products_properties_id'] == $xy->products_properties_id_Y){
                        $Y= $pp_item['value'];
                    }
                }
                $xy_price = $xy->get_price($X, $Y, xtc_get_tax_rate($products_tax_class_id));
                $products_price = $xy_price['PRICE_BRUTTO'];
                if(is_countable($xy_price['ALLOCATED_PROPERTIES_PRICES']) and sizeOf($xy_price['ALLOCATED_PROPERTIES_PRICES'])){
                    $p1 = explode('{',$products_id);
                    $p2 = explode('}',$p1[1]);
                    $p3 = explode(',',$p2[0]);
                    // ALLE UEBERGEBENEN ppvID durchlaufen
                    foreach($p3 as $products_properties_values_id){
                            if(strpos($products_properties_values_id,':')>-1){
                                    continue;
                            }
                            $r1 = yes_query(
                                "SELECT ppv.products_properties_id FROM `products_properties_values` ppv WHERE `products_properties_values_id`=:ppv_id",
                                ['ppv_id'=>$products_properties_values_id],
                                true
                            );
                            $products_properties_id = $r1['products_properties_id'];
                            foreach($xy_price['ALLOCATED_PROPERTIES_PRICES'] as $ap){
                                    if($ap['products_properties_id'] == $products_properties_id and $ap['products_properties_values_id'] == $products_properties_values_id){
                                            $products_price += $ap['PRICE_BRUTTO'];
                                    }
                            }
                    }
		}
                $properties_price_brutto = 0;
            }else{// end is xy
                $properties_price_brutto = $xtPrice->xtcFormat($this->get_product_properties_price_netto($products_id),false,$products_tax_class_id);
            }
            
            
            if(is_float($products_price)){
                $this->total += $products_price*$qty;
            }
            $this->weight += ($qty * $product['products_weight']);

            // BOF PAYPAL
            // $this->total hat netto * Stueck in der 1. Runde
            // Artikel Rabatt beruecksichtigt
            // Gesamt Rabatt auf Bestellung nicht
            // Nur weiterrechnen, falls Product nicht ohne Steuer
            // $this->total + $this->tax wird berechnet
            if ($products_tax_class_id != 0) {
                if ($_SESSION['customers_status']['customers_status_ot_discount_flag'] == 1) {
                    // Rabatt fuer die Steuerberechnung
                    // der eigentliche Rabatt wird im order-details_cart abgezogen
                    $products_price_tax = $products_price - ($products_price / 100 * $_SESSION['customers_status']['customers_status_ot_discount']);
                }

                // BUGF_CH_OSS
                $use_country_id = $country_id;
                $use_zone_id = $zone_id;
                
                $products_tax = xtc_get_tax_rate($products_tax_class_id, $use_country_id, $use_zone_id);
                $products_tax_description = xtc_get_tax_description($products_tax_class_id, $use_country_id, $use_zone_id);

                // price incl tax
                if ($_SESSION['customers_status']['customers_status_show_price_tax'] == '1') {
                    if(!isset($this->tax[$products_tax_class_id])){
                        $this->tax[$products_tax_class_id] = array();
                    }
                    if(!isset($this->tax[$products_tax_class_id]['value'])){
                        $this->tax[$products_tax_class_id]['value'] = 0;
                    }
                    if ($_SESSION['customers_status']['customers_status_ot_discount_flag'] == 1) {
                        $this->tax[$products_tax_class_id]['value'] += ((($products_price_tax) / (100 + $products_tax)) * $products_tax)*$qty;
                        $this->tax[$products_tax_class_id]['desc'] = TAX_ADD_TAX."$products_tax_description";
                    } else {
                        if(is_float($products_price)){
                            $this->tax[$products_tax_class_id]['value'] += ((($products_price) / (100 + $products_tax)) * $products_tax)*$qty;
                        }
                        $this->tax[$products_tax_class_id]['desc'] = TAX_ADD_TAX."$products_tax_description";
                    }

                }
                // excl tax + tax at checkout
                if ($_SESSION['customers_status']['customers_status_show_price_tax'] == 0 && $_SESSION['customers_status']['customers_status_add_tax_ot'] == 1) {
                    if ($_SESSION['customers_status']['customers_status_ot_discount_flag'] == 1) {
                        $this->tax[$products_tax_class_id]['value'] += (($products_price_tax) / 100) * ($products_tax)*$qty;
// BOF - Tomcraft - 2009-10-03 - Paypal Express Modul
                        $this->total_discount[$products_tax_class_id]+=(($products_price_tax) / 100) * ($products_tax)*$qty;
// EOF - Tomcraft - 2009-10-03 - Paypal Express Modul
                        $this->tax[$products_tax_class_id]['desc'] = TAX_NO_TAX."$products_tax_description";
                    } else {
                        $this->tax[$products_tax_class_id]['value'] += (floatval($products_price) / 100) * ($products_tax)*$qty;
// BOF - Tomcraft - 2009-10-03 - Paypal Express Modul
                        $this->total_discount[$products_tax_class_id]+=(floatval($products_price) / 100) * ($products_tax)*$qty;
// EOF - Tomcraft - 2009-10-03 - Paypal Express Modul
                         $this->tax[$products_tax_class_id]['desc'] = TAX_NO_TAX."$products_tax_description";
                    }
                }
            }
            // EOF PAYPAL
        } // EOF WHILE
        if ($_SESSION['customers_status']['customers_status_ot_discount_flag'] != 0) {
            $this->total -= $this->total/100*$_SESSION['customers_status']['customers_status_ot_discount'];
        }
    }

    function get_products() {
        global $main;
        if (!is_array($this->contents)){
            return false;
        }
        $products_array = array();
        reset($this->contents);
        
        // EU-OSS 2021/07
        // BUGF_CH_OSS - GESETZTE SESSION BERUECKSICHTIGEN
        $country_id = (isset($_SESSION['default_shipping_countries_id']) and $_SESSION['default_shipping_countries_id'] > 0) ? $_SESSION['default_shipping_countries_id'] : yes_get_store_country_id();
        $zone_id =  (isset($_SESSION['default_shipping_zone_id'])) ? $_SESSION['default_shipping_zone_id'] : 0;
        // WAR VORHER PAAR ZEILEN WEITER UNTEN IN DER WHILE SCHLEIFE
        $xtPrice = new xtcPrice($_SESSION['currency'],$_SESSION['customers_status']['customers_status_id']);
        
        // BOF - WENN BUGF_CH_OSS AKTIV KANN DIESER BLOCK WEG
        /*if(yes_eu_oss_use_country_handling($country_id)){
            $xtPrice->setCountryZone($country_id,$zone_id);
        }*/
        // EOF - WENN BUGF_CH_OSS AKTIV KANN DIESER BLOCK WEG
        
        // BUGF_CH_OSS - IMMER COUNTRY/ZONE SETZEN
        $xtPrice->setCountryZone($country_id,$zone_id);
        
        
        foreach($this->contents as $products_id => $uninteressant) {
            $products_query = yes_query(sprintf(
                "select p.products_id, p.products_date_available,pd.products_name,p.products_image, p.products_model, p.products_price, p.products_discount_allowed, p.products_weight,p.products_shippingtime,pd.slave_title from %s p, %s pd where p.products_id=:products_id and pd.products_id = p.products_id and pd.language_id =:language_id",
                    TABLE_PRODUCTS,TABLE_PRODUCTS_DESCRIPTION
                ),[
                    'products_id'=>xtc_get_prid($products_id),
                    'language_id'=>(int)$_SESSION['languages_id']
                ]
            );
            if(!sizeOf($products_query)){
                continue;
            }
            $products = current($products_query);
            
            $prid = $products_id;
            // dirty workaround
            $qty = ((isset($this->contents[$prid]['qty']))?$this->contents[$prid]['qty']:0);
            
            // EU-OSS 2021/07
            $products_tax_class_id = yes_eu_oss_get_products_tax_class_id(xtc_get_prid($products_id),$country_id,$zone_id);
            $format = false;
            $products_price=$xtPrice->xtcGetPrice(
                xtc_get_prid($products_id),
                $format,
                $qty,
                $products_tax_class_id,
                $products['products_price']
            );
            
            $properties = $this->get_properties_array( $products_id );
            $xy = \YES4Trade\Model\product_properties_xy_prices::get_from_products_id((int)xtc_get_prid($products_id));
            if($xy !== false){
            
                foreach($properties as $pp_item){
                    if($pp_item['products_properties_id'] == $xy->products_properties_id_X){
                        $X = $pp_item['value'];
                    }
                    if($pp_item['products_properties_id'] == $xy->products_properties_id_Y){
                        $Y= $pp_item['value'];
                    }
                }
                $xy_price = $xy->get_price($X, $Y, xtc_get_tax_rate($products_tax_class_id));
                $products_price = $xy_price['PRICE_BRUTTO'];
                if(is_countable($xy_price['ALLOCATED_PROPERTIES_PRICES']) and sizeOf($xy_price['ALLOCATED_PROPERTIES_PRICES'])){
                    $p1 = explode('{',$products_id);
                    $p2 = explode('}',$p1[1]);
                    $p3 = explode(',',$p2[0]);
                    // ALLE UEBERGEBENEN ppvID durchlaufen
                    foreach($p3 as $products_properties_values_id){
                        if(strpos($products_properties_values_id,':')>-1){
                                continue;
                        }
                        $r1 = yes_query(
                            "SELECT ppv.products_properties_id FROM `products_properties_values` ppv WHERE `products_properties_values_id`=:ppv_id",
                            ['ppv_id'=>$products_properties_values_id],
                            true
                        );
                        $products_properties_id = $r1['products_properties_id'];
                        foreach($xy_price['ALLOCATED_PROPERTIES_PRICES'] as $ap){
                                if($ap['products_properties_id'] == $products_properties_id and $ap['products_properties_values_id'] == $products_properties_values_id){
                                        $products_price += $ap['PRICE_BRUTTO'];
                                }
                        }
                    }
                }
                $properties_price_brutto = 0;
            }else{// end is xy
                $properties_price_brutto = $xtPrice->xtcFormat($this->get_product_properties_price_netto($products_id),false,$products_tax_class_id);
            }
            if(is_float($products_price)){
                $products_price += floatval($properties_price_brutto);
            }
            
            $shipping_status_name = $main->getShippingStatusName($products['products_shippingtime']);
            $products_array[] = array(
                'id' => $prid,
                'name' => $products['products_name'],
                'model' => $products['products_model'],
                'image' => $products['products_image'],
                'price' => (is_float($products_price)) ? $products_price : 0,
                'quantity' => $qty,
                'weight' => $products['products_weight'],
                'final_price' => (is_float($products_price)) ? floatval($products_price):0,
                'tax_class_id' => $products_tax_class_id,
                'slave_title'=>  $products['slave_title'],
                'products_shippingtime'=>$shipping_status_name,
                'products_date_available'=>$products['products_date_available'],
                'properties'=>$properties,
            );
        }
        return $products_array;
    }

    function show_tax() {
	global $xtPrice;
        $this->calculate();
        $output = "";
        $val = '';
        $gval = 0;
        foreach ($this->tax as $key => $value) {
            if ($this->tax[$key]['value'] > 0 ) {
                $output .= $this->tax[$key]['desc'].": ".$xtPrice->xtcFormat($this->tax[$key]['value'], true)."<br />";
                $val = $this->tax[$key]['value'];
                $gval+=$this->tax[$key]['value'];
            }
        }
        if (isset($format)) {
            return $output;
        }
        return $gval;
    }
    
    function show_total() {
        $this->calculate();
        return $this->total;
    }

    function show_weight() {
        $this->calculate();
        return $this->weight;
    }

    function generate_cart_id($length = 5) {
        return xtc_create_random_value($length, 'digits');
    }

    function get_content_type() {
        $this->content_type = false;
        if ( (DOWNLOAD_ENABLED == 'true') && ($this->count_contents() > 0) ) {
            reset($this->contents);
            foreach ($this->contents as $products_id=>$egal) {
                switch ($this->content_type) {
                    case 'virtual':
                        $this->content_type = 'mixed';
                        return $this->content_type;
                        break;
                    default:
                        $this->content_type = 'physical';
                        break;
                }
            }
        } else {
            $this->content_type = 'physical';
        }
        return $this->content_type;
    }

    function unserialize($broken) {
        // php8 bugfix
        // for(reset($broken);$kv=each($broken);) {
        foreach($broken as $k=>$v) {
            $kv = [$k, $v];
            $key=$kv['key'];
            if (gettype($this->$key) != "user function"){
                $this->$key=$kv['value'];
            }
        }
    }
    // GV Code Start
   // ------------------------ ICW CREDIT CLASS Gift Voucher Addittion-------------------------------Start
   // amend count_contents to show nil contents for shipping
   // as we don't want to quote for 'virtual' item
   // GLOBAL CONSTANTS if NO_COUNT_ZERO_WEIGHT is true then we don't count any product with a weight
   // which is less than or equal to MINIMUM_WEIGHT
   // otherwise we just don't count gift certificates

    function count_contents_virtual() {  // get total number of items in cart disregard gift vouchers
        $total_items = 0;
        if (is_array($this->contents)) {
            reset($this->contents);
            foreach($this->contents as $products_id => $egal ) {
                $no_count = false;
                $gv_result = yes_query(
                    "select products_model, products_weight from " . TABLE_PRODUCTS . " where products_id =:products_id",
                    ['products_id'=>(int)xtc_get_prid($products_id)],
                    true
                );
                if (preg_match('/^GIFT/', $gv_result['products_model'])) {
                    $no_count=true;
                }
                if (defined('NO_COUNT_ZERO_WEIGHT') and constant('NO_COUNT_ZERO_WEIGHT') == 1) {
                    if ($gv_result['products_weight']<=MINIMUM_WEIGHT) {
                        $no_count=true;
                    }
                }
                if (!$no_count) {
                    $total_items += $this->get_quantity($products_id);
                }
            }
        }
        return $total_items;
    }
  
  // wird nicht mehr verwendet 2024/10
  public function get_product_properties_price_netto($products_id){
	$price_netto = 0;
	$ppvID_parts = explode('{',$products_id);
	if(sizeOf($ppvID_parts) < 2){
		return $price_netto;
	}
	$ppvID_parts = explode(',',substr($ppvID_parts[1],0,strlen($ppvID_parts[1])-1));
	foreach($ppvID_parts as $ppvID){
                if(strpos($ppvID,':')>-1){
                    $ppvid_parts = explode(':',$ppvID);
                    $ppvID = $ppvid_parts[0];
                }
		$ppvID = (int)xtc_db_input($ppvID);
		$ppv = new product_properties_values($ppvID);
                if((int)$ppv->products_properties_id < 1){
                    continue;
                }
                if( \YES4Trade\Model\product_properties_xy_prices::is_products_properties_id_xy_price($ppv->products_properties_id) ){
                    continue;
                }
		$price_netto += $ppv->getPrice();
	}
	return $price_netto;
  }
  
  public function get_properties_array($products_id ){
	$properties = array();
	$ppvID_parts = explode('{',$products_id);
	if(sizeOf($ppvID_parts) < 2){
		return $properties;
	}
	$ppvID_parts = explode(',',substr($ppvID_parts[1],0,strlen($ppvID_parts[1])-1));
	foreach($ppvID_parts as $ppvID){
		$ppvID = xtc_db_input($ppvID);
                // BOF - input_span AENDERUNGEN 2023/06
                $input_span = '';
                if(strpos($ppvID,':')>0){
                    $ppvID_input_span_parts = explode(':',$ppvID);
                    $ppvID = (int)$ppvID_input_span_parts[0];
                    $input_span = (int)$ppvID_input_span_parts[1];
                }
		$ppv = new product_properties_values($ppvID);
		$pp = new product_properties($ppv->getProducts_properties_id());
		$properties[] = array(
                    'products_properties_id'=>$ppv->products_properties_id,
                    'products_properties_values_id'=>$ppv->products_properties_values_id,
                    'value'=>$ppv->getDescription($_SESSION['languages_id'])->getTitle(),
                    'price_netto'=>$ppv->getPrice(),
                    'xy_percent_add'=>$ppv->getXy_percent_add(),
                    'property'=>$pp->getDescription($_SESSION['languages_id'])->getTitle(),
                    'input_span'=>$input_span,
		);
                // EOF - input_span AENDERUNGEN 2023/06
	}
	return $properties;
  }
 
    private function get_tax_proportional_distribution(){
        if(!sizeOf($this->contents)){
            return array(array(
                'tax_class_id'=>1,
                'tax_rate'=>xtc_get_tax_rate(1),
                'title'=>  xtc_get_tax_description(1),
                'percentage'=>100
            ));
        }
        $return = array();
        $tc_values = array();
        $tc_percentage = array();
        $product_sum = 0;
        foreach($this->get_products() as $product){
            if(!isset($tc_values[ $product['tax_class_id']])){
                $tc_values[ $product['tax_class_id']] = 0;
            }
            $tc_values[ $product['tax_class_id']] += $product['final_price'];
            $product_sum += $product['final_price'];
        }
        foreach($tc_values as $tcID=>$sum){
            $sum = (float) $sum;
            if($product_sum>0 and $sum > 0){
                $tc_percentage[ $tcID ] = 100/$product_sum*$sum;
            }else{
                $tc_percentage[ $tcID ] = 0;
            }
        }
        // EU-OSS 2021/07
        $country_id = yes_get_store_country_id();
        // BOF - BUGF_CH_OSS - WENN AKTIV KANN BLOCK WEG
        /*if(yes_eu_oss_use_country_handling($country_id)){
            $zone_id =  (isset($_SESSION['default_shipping_zone_id'])) ? $_SESSION['default_shipping_zone_id'] : 0;
        }else{
            $country_id = STORE_COUNTRY;
            $zone_id = 0;
        }*/
        
        // BUGF_CH_OSS
        $zone_id =  (isset($_SESSION['default_shipping_zone_id'])) ? $_SESSION['default_shipping_zone_id'] : 0;
        
        foreach($this->tax as $tax_class_id=>$tr){
            $trate = xtc_get_tax_rate($tax_class_id,$country_id, $zone_id);
            $tdesc = xtc_get_tax_description($tax_class_id,$country_id, $zone_id);
            $return[] = array(
                'tax_class_id'=>$tax_class_id,
                'tax_rate'=>$trate,
                'title'=> $tdesc,
                'percentage'=>$tc_percentage[ $tax_class_id ]
            );
        }
        return $return;
    }
    
    public function get_tax_rates_for_nebenleistung($value){
        $tpd = $this->get_tax_proportional_distribution();
        $tax_values = array();
        foreach($tpd as $tr){
            $_tax_rate = ($tr['tax_rate']+100)/100;
            $anteil_brutto = ($value/100*$tr['percentage']);
            	// BOF - BUGFIX 2024/09
		$netto_ausgabe = false;
		if($_SESSION['customers_status']['customers_status_show_price'] == 1 && $_SESSION['customers_status']['customers_status_show_price_tax'] == 0){
			if($_SESSION['customers_status']['customers_status_add_tax_ot'] == 1){
				$netto_ausgabe = true;
			}
		}
		if($netto_ausgabe){
            		$tr['amount'] = ($anteil_brutto*$_tax_rate)-$anteil_brutto;
		}else{
            		$tr['amount'] = $anteil_brutto-($anteil_brutto/$_tax_rate);
            	}
            	// EOF - BUGFIX 2024/09
            $tax_values[] = $tr;
        }
        return $tax_values;
    }
  
    public function get_free_shipping($default_shipping_countries_id){
	if (defined('MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING') && (MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING == 'true')) {
                $xtPrice = new xtcPrice($_SESSION['currency'],$_SESSION['customers_status']['customers_status_id']);
                // EU-OSS 2021/07
                // BOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG
                /*if(yes_eu_oss_use_country_handling($default_shipping_countries_id)){
                    $zone_id = 0;
                    $xtPrice->setCountryZone($default_shipping_countries_id, $zone_id);
                }*/
                // EOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG
                
                // BUGF_CH_OSS
                $zone_id = 0;
                $xtPrice->setCountryZone($default_shipping_countries_id, $zone_id);
                
                
		switch (MODULE_ORDER_TOTAL_SHIPPING_DESTINATION) {
                    case 'national' :
                        if ($default_shipping_countries_id == STORE_COUNTRY)
                                $pass = true;
                        break;
                    case 'international' :
                        if ($default_shipping_countries_id != STORE_COUNTRY)
                                $pass = true;
                        break;
                    case 'both' :
                        $pass = true;
                        break;
                    default :
                        $pass = false;
                        break;
		}

		$free_shipping = false;
		if(!isset($_SESSION['shipping'])){
                    $_SESSION['shipping'] = array();
		}
		if(!isset($_SESSION['shipping']['cost'])){
                    $_SESSION['shipping']['cost'] = 0;
		}
		if ((isset($pass) and $pass == true) && ($_SESSION['cart']->total - $_SESSION['shipping']['cost'] >= $xtPrice->xtcFormat(MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER, false, 0, true))) {
                    $free_shipping = true;
                    include (DIR_WS_LANGUAGES.$_SESSION['language'].'/modules/order_total/ot_shipping.php');
		}
	} else {
            $free_shipping = false;
	}
	return $free_shipping;
    }
    /**
     * Ermittelt einen Temporaeren Versandkostenwert
     */
    public function get_temporary_shippingcosts($default_shipping_countries_id){
        if(!class_exists('shipping')){
            require_once(DIR_FS_CATALOG.'includes/classes/shipping.php');
        }
        reset($this->contents);
        $xtPrice = new xtcPrice($_SESSION['currency'],$_SESSION['customers_status']['customers_status_id']);
        
        // EU-OSS 2021/07
        // BOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG
        /*if(yes_eu_oss_use_country_handling($default_shipping_countries_id)){
            $zone_id = 0;
            $xtPrice->setCountryZone($default_shipping_countries_id,$zone_id);
        }*/
        // EOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG
        // BUGF_CH_OSS
        $zone_id = 0;
        $xtPrice->setCountryZone($default_shipping_countries_id,$zone_id);
        
        $shipping_modules = new shipping;
        // get all available shipping quotes
        $quotes = $shipping_modules->quote();
        $customer_zone_id = (isset($_SESSION['customer_zone_id'])) ? $_SESSION['customer_zone_id'] : 0;
        
        $shipping_tax_rate = xtc_get_tax_rate($this->get_nebenleistung_tax_class_id(), $default_shipping_countries_id, $customer_zone_id);

        $invalid_shippingmethods = array(
            'selfpickup'
        );
        $count_valid_shipping_methods = 0;
        $free_shipping = $this->get_free_shipping($default_shipping_countries_id);
        if (xtc_count_shipping_modules() > 0) {
	    if ($free_shipping == true) {
                return array(
                    'FREE_SHIPPING'=>true
                );
	    } else {
		$radio_buttons = 0;
		#loop through installed shipping methods...
                $min_price = 0;
                $lowest = 0;
		for ($i = 0, $n = sizeof($quotes); $i < $n; $i ++) {
		    if (isset ($quotes[$i]['error'])){
			continue;
		    }
                    if(isset($quotes[$i]['methods']) and is_countable($quotes[$i]['methods'])){
                        for ($j = 0, $n2 = sizeof($quotes[$i]['methods']); $j < $n2; $j ++) {
                            if(!in_array($quotes[$i]['id'],$invalid_shippingmethods)){
                                $count_valid_shipping_methods++;
                            }
                            $quotes[$i]['methods'][$j]['radio_buttons'] = $radio_buttons;
                            $checked = ( (isset($_SESSION['shipping']['id']) and $quotes[$i]['id'].'_'.$quotes[$i]['methods'][$j]['id'] == $_SESSION['shipping']['id'] ) ? true : false);
                            if (($checked == true) || ($n == 1 && $n2 == 1)) {
                                $quotes[$i]['methods'][$j]['checked'] = 1;
                            }
                            if (($n > 1) || ($n2 > 1)) {
                                if ($_SESSION['customers_status']['customers_status_show_price_tax'] == 0){
                                    $quotes[$i]['tax'] = 0;
                                    $quotes[$i]['methods'][$j]['price'] = $xtPrice->xtcFormat($quotes[$i]['methods'][$j]['cost'], true, 0, true);
                                    $quotes[$i]['methods'][$j]['price_raw'] = $xtPrice->xtcFormat($quotes[$i]['methods'][$j]['cost'], false, 0, false);
                                }else{
                                    $quotes[$i]['methods'][$j]['price'] = $xtPrice->xtcFormat(xtc_add_tax($quotes[$i]['methods'][$j]['cost'], $shipping_tax_rate), true, 0, true);
                                    $quotes[$i]['methods'][$j]['price_raw'] = $xtPrice->xtcFormat(xtc_add_tax($quotes[$i]['methods'][$j]['cost'], $shipping_tax_rate), false, 0, false);
                                }
                                $quotes[$i]['methods'][$j]['radio_field'] = xtc_draw_radio_field('shipping', $quotes[$i]['id'].'_'.$quotes[$i]['methods'][$j]['id'], $checked);
                            } else {
                                if ($_SESSION['customers_status']['customers_status_show_price_tax'] == 0){
                                        $quotes[$i]['tax'] = 0;
                                        $quotes[$i]['methods'][$j]['price'] = $xtPrice->xtcFormat($quotes[$i]['methods'][$j]['cost'], true, 0, true).xtc_draw_hidden_field('shipping', $quotes[$i]['id'].'_'.$quotes[$i]['methods'][$j]['id']);
                                        $quotes[$i]['methods'][$j]['price_raw'] = $xtPrice->xtcFormat($quotes[$i]['methods'][$j]['cost'], false, 0, false);
                                }else{
                                    $quotes[$i]['methods'][$j]['price'] = $xtPrice->xtcFormat(xtc_add_tax($quotes[$i]['methods'][$j]['cost'], $shipping_tax_rate), true, 0, true).xtc_draw_hidden_field('shipping', $quotes[$i]['id'].'_'.$quotes[$i]['methods'][$j]['id']);
                                    $quotes[$i]['methods'][$j]['price_raw'] = $xtPrice->xtcFormat(xtc_add_tax($quotes[$i]['methods'][$j]['cost'], $shipping_tax_rate), false, 0, false);
                                }
                            }
                            $radio_buttons ++;
                        }
                    }
		    foreach($quotes as $qk=>$quote){
			$qtotal = 0;
			foreach($quote['methods'] as $qm){
			    if(isset($qm['price_raw'])){
				$qtotal += $qm['price_raw'];
			    }
			}
			if($min_price == 0 or $qtotal < $min_price){
			    $min_price = $qtotal;
			    $lowest = $qk;
			}
		    }
		}
                $quotes[ $lowest ]['lowest'] = 1;
		return array(
		    'COUNT_VALID_SHIPPING_METHODS'=>$count_valid_shipping_methods,
		    'QUOTES'=>$quotes
		);
	    }
        }
    }
  
    public function get_coupon_values(){
        $coupon_amount = 0;
        $coupon_code = '';
        $free_shipping = false;
        if(isset($_SESSION['cc_id']) and $_SESSION['cc_id'] > 0){
            $coupon = \YES4Trade\Model\coupons::get_by_coupon_id(intval($_SESSION['cc_id']));
            if($coupon === null or $coupon->coupon_active != 'Y'){
                return array(
                    'coupon_code'=>$coupon_code,
                    'coupon_amount'=>$coupon_amount
                );
            }
            $default_shipping_countries_id = yes_get_store_country_id();
            if($default_shipping_countries_id > 0 and $coupon->coupon_type == 'S'){
                $temporary_shippingcosts = $this->get_temporary_shippingcosts($default_shipping_countries_id);
                foreach($temporary_shippingcosts['QUOTES'] as $tsc){
                    if(!isset($tsc['lowest']) and $temporary_shippingcosts['COUNT_VALID_SHIPPING_METHODS'] > 1){
                        continue;
                    }
                    $temp_costs = $tsc['methods'][0]['cost'];
                    $tax_value = $tsc['tax'];
                    $multiplikator = ($tax_value + 100)/100;
                    if(!empty($coupon->free_shipping_countries)){
                        $countries = explode(',',$coupon->free_shipping_countries);
                        $temp_iso2 = xtc_get_countries_with_iso_codes($default_shipping_countries_id);
                        foreach($countries as $country){
                            $country = trim(xtc_db_input($country));
                            if(strtolower($temp_iso2['countries_iso_code_2']) == strtolower($country)){
                                $coupon_amount = -($temp_costs*$multiplikator);
                                $coupon_code = $coupon->coupon_code;
                                $free_shipping = true;
                            }
                        }
                    }else{
                        $free_shipping = true;
                        if($temporary_shippingcosts > 0){
                            $coupon_amount = -($temp_costs*$multiplikator);
                            $coupon_code = $coupon->coupon_code;
                        }
                    }
                }
            }else{
                $coupon_amount = -$coupon->coupon_amount;
                $coupon_code = $coupon->coupon_code;
            }
        }
        return array(
            'coupon_code'=>$coupon_code,
            'coupon_amount'=>$coupon_amount,
            'free_shipping'=>$free_shipping,
            'type'=>(isset($coupon))?$coupon->coupon_type:null 
        );
    }
  
    public function get_discount_value($total){
        if ($_SESSION['customers_status']['customers_status_ot_discount_flag'] != '1' or $_SESSION['customers_status']['customers_status_ot_discount'] == '0.00') {
            return 0;
        }
        if ($_SESSION['customers_status']['customers_status_show_price_tax'] == 0 && $_SESSION['customers_status']['customers_status_add_tax_ot'] == 1) {
                $price = $total- ($this->show_tax(false));
        } else {
                $price = $total;
        }
        $orig_price = $price/((100-$_SESSION['customers_status']['customers_status_ot_discount'])/100);
        return round($orig_price - $price,2);
    }
  
    public function get_nebenleistung_tax_class_id(){
        $tax_class_id = 0;
        $max_final_price = 0;
        $products = $this->get_products();
        for ($i=0, $n=sizeof($products); $i<$n; $i++) {
            // BOF - VERSANDKOSTENVORSCHAU - TAX CLASS
            if( ($products[$i]['final_price']*$products[$i]['quantity']) > $max_final_price){
                    $max_final_price = ($products[$i]['final_price']*$products[$i]['quantity']);
                    $tax_class_id = $products[$i]['tax_class_id'];
            }
        }
        return $tax_class_id;
    }
}



