<?php

namespace Secuconnect\Client\Model;

use \ArrayAccess;

/**
 * SmartTransactionsPreTransactionModel
 *
 * @category Class
 * @description SmartTransactionsPreTransactionModel
 * @package  Secuconnect\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class SmartTransactionsPreTransactionModel implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'SmartTransactionsPreTransactionModel';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'missing_sum' => 'int',
        'bonus_products' => '\Secuconnect\Client\Model\SmartTransactionsBonusProducts[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerFormats = [
        'missing_sum' => null,
        'bonus_products' => null
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'missing_sum' => 'missing_sum',
        'bonus_products' => 'bonus_products'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'missing_sum' => 'setMissingSum',
        'bonus_products' => 'setBonusProducts'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'missing_sum' => 'getMissingSum',
        'bonus_products' => 'getBonusProducts'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['missing_sum'] = isset($data['missing_sum']) ? $data['missing_sum'] : null;
        $this->container['bonus_products'] = isset($data['bonus_products']) ? $data['bonus_products'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets missing_sum
     * @return int
     */
    public function getMissingSum()
    {
        return $this->container['missing_sum'];
    }

    /**
     * Sets missing_sum
     * @param int $missing_sum Amount to pay after applying the secucard; in the smallest currency unit (e.g. Euro Cent)
     * @return $this
     */
    public function setMissingSum($missing_sum)
    {
        $this->container['missing_sum'] = $missing_sum;

        return $this;
    }

    /**
     * Gets bonus_products
     * @return \Secuconnect\Client\Model\SmartTransactionsBonusProducts[]
     */
    public function getBonusProducts()
    {
        return $this->container['bonus_products'];
    }

    /**
     * Sets bonus_products
     * @param \Secuconnect\Client\Model\SmartTransactionsBonusProducts[] $bonus_products bonus_products
     * @return $this
     */
    public function setBonusProducts($bonus_products)
    {
        $this->container['bonus_products'] = $bonus_products;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     * @param integer $offset Offset
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param integer $offset Offset
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param integer $offset Offset
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\Secuconnect\Client\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\Secuconnect\Client\ObjectSerializer::sanitizeForSerialization($this));
    }
}

