<?php
/* -----------------------------------------------------------------------------------------
   $Id: ot_coupon.php,v 1.10 2019/04/18 09:20:52 cvs Exp $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(ot_coupon.php,v 1.1.2.37.3); www.oscommerce.com

   Released under the GNU General Public License
   -----------------------------------------------------------------------------------------
   Third Party contributions:

   Credit Class/Gift Vouchers/Discount Coupons (Version 5.10)
   http://www.oscommerce.com/community/contributions,282
   Copyright (c) Strider | Strider@oscworks.com
   Copyright (c  Nick Stanko of UkiDev.com, nick@ukidev.com
   Copyright (c) Andre ambidex@gmx.net
   Copyright (c) 2001,2002 Ian C Wilson http://www.phesis.org

   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/


class ot_coupon {
    var $title, $output, $is_shopping_cart, $code, $header, $description, $user_prompt, $enabled, $sort_order,
        $deduction,$include_shipping,$include_tax,$calculate_tax,$tax_class,$credit_class, $Price;

    function __construct($price) {

	$this->code = 'ot_coupon';
	$this->header = MODULE_ORDER_TOTAL_COUPON_HEADER;
	$this->title = MODULE_ORDER_TOTAL_COUPON_TITLE;
	$this->description = MODULE_ORDER_TOTAL_COUPON_DESCRIPTION;
	$this->user_prompt = '';
        
	$this->enabled = (defined('MODULE_ORDER_TOTAL_COUPON_STATUS') and MODULE_ORDER_TOTAL_COUPON_STATUS == 'true') ? 1 : 0;
	$this->sort_order = (defined('MODULE_ORDER_TOTAL_COUPON_SORT_ORDER'))?MODULE_ORDER_TOTAL_COUPON_SORT_ORDER:0;
        if($this->enabled == 1){
            $this->include_shipping = MODULE_ORDER_TOTAL_COUPON_INC_SHIPPING;
            $this->include_tax = MODULE_ORDER_TOTAL_COUPON_INC_TAX;
            $this->calculate_tax = MODULE_ORDER_TOTAL_COUPON_CALC_TAX;
            $this->tax_class = MODULE_ORDER_TOTAL_COUPON_TAX_CLASS;
        }
	$this->credit_class = true;
	$this->output = array();
        $this->Price=$price;
        $filename_chk = defined('FILENAME_SHOPPING_CART') ? FILENAME_SHOPPING_CART :'shopping_cart.php';
        $this->is_shopping_cart = (basename($_SERVER['SCRIPT_NAME']) == $filename_chk);

    }

    function process() {
        global $order, $currencies;
	//$order_total=$this->get_order_total();
        // BUGFIX MARIO - KEINE VERSANDKOSTEN EINBEZIEHEN
        $order_total = $this->get_order_total()-$order->info['shipping_cost'];
	$od_amount = $this->calculate_credit($order_total);
	$tod_amount = 0.0; //Fred
	$this->deduction = $od_amount;
	if ($this->calculate_tax != 'None') { //Fred - changed from 'none' to 'None'!
            $tod_amount = $this->calculate_tax_deduction($order_total, $this->deduction, $this->calculate_tax);
	}

	if ($od_amount > 0) {
            $order->info['total'] = $order->info['total'] - $od_amount;
            // BUGFIX MARIO 09/2024
            $print_od_amount = $od_amount;
            if ($_SESSION['customers_status']['customers_status_show_price_tax'] == 0 and $_SESSION['customers_status']['customers_status_add_tax_ot'] == 1){
            	$order->info['total'] += $tod_amount;
		$print_od_amount -= $tod_amount;             	
            }
            
            
            $this->output[] = array('title' => $this->title . ':' . $this->coupon_code .':',
                'text' => '<b><font color="ff0000">-' . $this->Price->xtcFormat($print_od_amount,true) . '</font></b>', 'value' => $od_amount
            ); //Fred added hyphen
	}
    }

    function selection_test() {
        return false;
    }


    function pre_confirmation_check($order_total) {
	return $this->calculate_credit($order_total);
    }

    function use_credit_amount() {
	    return ''; //$output_string;
    }


    function credit_selection() {
        global $currencies;
        $selection_string = '';
	return $selection_string;
    }


    function collect_posts() {
        global $currencies;
	if (isset($_POST['gv_redeem_code'])) {
            $coupon = \YES4Trade\Model\coupons::get_by_coupon_code($_POST['gv_redeem_code']);
            if($coupon === null or $coupon->coupon_active != 'Y'){
                xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, 'error_message=' . urlencode(ERROR_NO_INVALID_REDEEM_COUPON), 'SSL'));
            }
            if ($coupon->coupon_type != 'G') {
                if(new DateTime($coupon->coupon_start_date) > new DateTime()){
                    xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, 'error_message=' . urlencode(ERROR_INVALID_STARTDATE_COUPON), 'SSL'));
                }
                if(new DateTime($coupon->coupon_expire_date) < new DateTime()){
                    xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, 'error_message=' . urlencode(ERROR_INVALID_FINISDATE_COUPON), 'SSL'));
                }

                $coupon_count = \YES4Trade\Model\coupon_redeem_track::get_by_coupon_id(intval($coupon->coupon_id),[
                    'coupon_id'
                ]);
                $coupon_count_customer = \YES4Trade\Model\coupon_redeem_track::get_by_coupon_id_and_customers_id(
                    intval($coupon->coupon_id),intval($_SESSION['customer_id'])
                );

                if (sizeOf($coupon_count) >= $coupon->uses_per_coupon and $coupon->uses_per_coupon > 0) {
                    xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, 'error_message=' . urlencode(ERROR_INVALID_USES_COUPON . $coupon_result['uses_per_coupon'] . TIMES ), 'SSL'));
                }

                if (sizeOf($coupon_count_customer) >= $coupon->uses_per_user and $coupon->uses_per_user > 0) {
                    xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, 'error_message=' . urlencode(ERROR_INVALID_USES_USER_COUPON . $coupon_result['uses_per_user'] . TIMES ), 'SSL'));
                }
                if ($coupon->coupon_type=='S') {
                    $allowed_countries = array();
                    if($coupon->free_shipping_countries != ''){
                        $allowed_countries = explode(',',$coupon->free_shipping_countries);
                        foreach($allowed_countries as $ak=>$av){
                            $allowed_countries[$ak] = trim(strtoupper($av));
                        }
                    }
                    if( !sizeOf($allowed_countries) or in_array($order->delivery['country']['iso_code_2'],$allowed_countries)){
                        $coupon_amount = $order->info['shipping_cost'];
                    }				
                } else {
                    $coupon_amount = $this->Price->xtcFormat($coupon->coupon_amount,true) . ' ';
                }
                if ($coupon->coupon_type=='P') {
                    $coupon_amount = $coupon->coupon_amount . '% ';
                }
                if ($coupon->coupon_minimum_order>0) {
                    $coupon_amount .= 'on orders greater than ' . $coupon->coupon_minimum_order;
                }
                $_SESSION['cc_id'] = $coupon->coupon_id; //Fred ADDED, set the global and session variable
            }
            if (isset($_POST['submit_redeem_coupon_x']) and !isset($_POST['gv_redeem_code'])){
                xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, 'error_message=' . urlencode(ERROR_NO_REDEEM_CODE), 'SSL'));
            }
        }
    }

    function calculate_credit($amount) {
        global $order;
	$od_amount = 0;
	if (!isset($_SESSION['cc_id']) ) {
            return $od_amount;
        }
        $coupon = \YES4Trade\Model\coupons::get_by_coupon_id(intval($_SESSION['cc_id']));
        if ($coupon === null) {
            return $od_amount;
        }
        $this->coupon_code = $coupon->coupon_code;
        $get_result = $coupon->toArray();
        $c_deduct = $get_result['coupon_amount'];

        // -----------------
        // BOF FREE SHIPPING
        // -----------------
        if ($get_result['coupon_type']=='S'){
            if($get_result['coupon_minimum_order'] >= $amount){
                $allowed_countries = array();
                if($get_result['free_shipping_countries'] != ''){
                    $allowed_countries = explode(',',$get_result['free_shipping_countries']);
                    foreach($allowed_countries as $ak=>$av){
                        $allowed_countries[$ak] = trim(strtoupper($av));
                    }
                }
                if( !sizeOf($allowed_countries) or in_array($order->delivery['country']['iso_code_2'],$allowed_countries)){
                    $c_deduct = $order->info['shipping_cost'];
                    if(!defined('USE_EASYCHECKOUT') or USE_EASYCHECKOUT != 'True'){
                        if ($_SESSION['customers_status']['customers_status_add_tax_ot'] == 1) {
                            $order->info['shipping_cost']=$this->Price->xtcFormat($order->info['shipping_cost'], false);
                            // EU-OSS KEIN MODUL TAX CLASS MEHR
                            //if(defined('YES_EXT_MODUS_TAX_RATE_PERCENT') and YES_EXT_MODUS_TAX_RATE_PERCENT == 'True'){
                                    $tax_class_id = $order->get_shipping_tax_class();
                            //}else{
                            //        $tax_class_id = $GLOBALS[$module]->tax_class;
                            //}
                            // EU-OSS 2017/07
                            if($this->is_shopping_cart){
                                $tax_country_id = (isset($_SESSION['default_shipping_countries_id'])) ? $_SESSION['default_shipping_countries_id'] : STORE_COUNTRY;
                                $tax_zone_id =  (isset($_SESSION['default_shipping_zone_id'])) ? $_SESSION['default_shipping_zone_id'] : 0;
                            }else{
                                $tax_country_id = $order->delivery['country']['id'];
                                $tax_zone_id = $order->delivery['zone_id'];
                            }
                            
                            
                            // BUGF_CH_OSS
                            $shipping_tax = xtc_get_tax_rate($tax_class_id, $tax_country_id, $tax_zone_id);
                            $tax = xtc_add_tax($order->info['shipping_cost'], $shipping_tax)-$order->info['shipping_cost'];
                            $c_deduct = $order->info['shipping_cost']+$tax;
                        }
                    }
                    $od_amount = $c_deduct;
                }				
            }
        // -----------------
        // EOF FREE SHIPPING
        // -----------------
        }else{
            if ($get_result['coupon_minimum_order'] > $this->get_order_total()) {
                return $od_amount;
            }
            if ($get_result['restrict_to_products'] || $get_result['restrict_to_categories']) {
                for ($i=0; $i<sizeof($order->products); $i++) {
                    if ($get_result['restrict_to_products']) {
                        $pr_ids = explode(",", $get_result['restrict_to_products']);
                        for ($ii = 0; $ii < count($pr_ids); $ii++) {
                            if ($pr_ids[$ii] == xtc_get_prid($order->products[$i]['id'])) {
                                if ($get_result['coupon_type'] == 'P') {
                                    $pr_c = $this->product_price($pr_ids[$ii]); //Fred 2003-10-28, fix for the row above, otherwise the discount is calc based on price excl VAT!
                                    $pod_amount = round($pr_c*10)/10*$c_deduct/100;
                                    $od_amount = $od_amount + $pod_amount;
                                } else {
                                    $od_amount = $c_deduct;
                                }
                            }
                        }
                    } else {
                        $cat_ids = explode(",", $get_result['restrict_to_categories']);
                        for ($i=0; $i<sizeof($order->products); $i++) {
                            $my_path = xtc_get_product_path(xtc_get_prid($order->products[$i]['id']));
                            $sub_cat_ids = explode("_", $my_path);
                            for ($iii = 0; $iii < count($sub_cat_ids); $iii++) {
                                for ($ii = 0; $ii < count($cat_ids); $ii++) {
                                    if ($sub_cat_ids[$iii] == $cat_ids[$ii]) {
                                        if ($get_result['coupon_type'] == 'P') {
                                            $pr_c = $this->product_price(xtc_get_prid($order->products[$i]['id'])); //Fred 2003-10-28, fix for the row above, otherwise the discount is calc based on price excl VAT!
                                            $pod_amount = round($pr_c*10)/10*$c_deduct/100;
                                            $od_amount = $od_amount + $pod_amount;
                                        } else {
                                            $od_amount = $c_deduct;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            } else {
                if ($get_result['coupon_type'] !='P') {
                    $od_amount = $c_deduct;
                } else {
                    $od_amount = $amount * $get_result['coupon_amount'] / 100;
                }
            }
            if ($od_amount>$amount) {
                $od_amount = $amount;
            }
        } // END KEIN FREE SHIPPING COUPON
        return $od_amount;
}

    function calculate_tax_deduction($amount, $od_amount, $method) {
        global $order;
        if(!isset($_SESSION['cc_id'])){
            return 0;
        }
        $coupon = \YES4Trade\Model\coupons::get_by_coupon_id(intval($_SESSION['cc_id']));
	    if ($coupon !== null) {
		    $get_result = $coupon->toArray();
//		if ($get_result['coupon_type'] != 'S') {
                // EU-OSS 2017/07
                $tax_class_id = $order->get_shipping_tax_class();
                
                if($this->is_shopping_cart){
                    $tax_country_id = (isset($_SESSION['default_shipping_countries_id'])) ? $_SESSION['default_shipping_countries_id'] : STORE_COUNTRY;
                    $tax_zone_id =  (isset($_SESSION['default_shipping_zone_id'])) ? $_SESSION['default_shipping_zone_id'] : 0;
                }else{
                    $tax_country_id = $order->delivery['country']['id'];
                    $tax_zone_id = $order->delivery['zone_id'];
                }

                // BUGF_CH_OSS
                $tax_rate = xtc_get_tax_rate($tax_class_id, $tax_country_id, $tax_zone_id);
                $tax_description = xtc_get_tax_description($tax_class_id, $tax_country_id, $tax_zone_id);
                
                //RESTRICTION--------------------------------
                if ($get_result['restrict_to_products'] || $get_result['restrict_to_categories']) {
                    // What to do here.
                    // Loop through all products and build a list of all product_ids, price, tax class
                    // at the same time create total net amount.
                    // then
                    // for percentage discounts. simply reduce tax group per product by discount percentage
                    // or
                    // for fixed payment amount
                    // calculate ratio based on total net
                    // for each product reduce tax group per product by ratio amount.
                    $products = $_SESSION['cart']->get_products();
                    $valid_product = false;
                    for ($i=0; $i<sizeof($products); $i++) {
                        $valid_product = false;
                        $t_prid = xtc_get_prid($products[$i]['id']);
                        if ($get_result['restrict_to_products']) {
                            $pr_ids = explode(",", $get_result['restrict_to_products']);
                            for ($p = 0; $p < sizeof($pr_ids); $p++) {
                                if ($pr_ids[$p] == $t_prid) {
                                    $valid_product = true;
                                }
                            }
                        }
                        if ($get_result['restrict_to_categories']) {
                            $cat_ids = explode(",", $get_result['restrict_to_categories']);
                            for ($c = 0; $c < sizeof($cat_ids); $c++) {
                                $cats_exists_array = \YES4Trade\Model\products_to_categories::get_items(
                                        intval($t_prid), intval($cat_ids[$i])
                                );
                                if (sizeOf($cats_exists_array) > 0 ){
                                    $valid_product = true;
                                }
                            }
                        }
                        if ($valid_product) {
                            $price_excl_vat = $products[$i]['final_price'] * $products[$i]['quantity']; //Fred - added
                            $price_incl_vat = $this->product_price($t_prid); //Fred - added
                            $valid_array[] = array(
                                'product_id' => $t_prid, 
                                'products_price' => $price_excl_vat, 
                                'products_tax_class' => $products[$i]['tax_class_id']
                            ); 
                            $total_price += $price_excl_vat; // changed
                        }
                    }
                    if (sizeof($valid_array) > 0) { // if ($valid_product) {
                        if ($get_result['coupon_type'] == 'P') {
                            $ratio = $get_result['coupon_amount']/100;
                        } else {
                            $ratio = $od_amount / $total_price;
                        }
                        if ($get_result['coupon_type'] == 'S') $ratio = 1;
                        if ($method=='Credit Note') {
                            if ($get_result['coupon_type'] == 'P') {
                                $tod_amount = $od_amount / (100 + $tax_rate)* $tax_rate;
                            } else {
                                $tod_amount = $order->info['tax_groups'][$tax_desc] * $od_amount/100;
                            }
                            $order->info['tax_groups'][$tax_description] -= $tod_amount;
                            $order->info['total'] -= $tod_amount; //  need to modify total ...OLD
                            $order->info['tax'] -= $tod_amount; //Fred - added
			} else {
                            for ($p=0; $p<sizeof($valid_array); $p++) {
                                
                                // BUGF_CH_OSS
                                $tax_rate = xtc_get_tax_rate($valid_array[$p]['products_tax_class'], $tax_country_id, $tax_zone_id);
                                $tax_desc = xtc_get_tax_description($valid_array[$p]['products_tax_class'], $tax_country_id, $tax_zone_id);
                                
                                if ($tax_rate > 0) {
                                    //Fred $tod_amount[$tax_desc] += ($valid_array[$p]['products_price'] * $tax_rate)/100 * $ratio; //OLD
                                    $tod_amount = ($valid_array[$p]['products_price'] * $tax_rate)/100 * $ratio; // calc total tax Fred - added
                                    $order->info['tax_groups'][$tax_desc] -= ($valid_array[$p]['products_price'] * $tax_rate)/100 * $ratio;
                                    $order->info['total'] -= ($valid_array[$p]['products_price'] * $tax_rate)/100 * $ratio; // adjust total
                                    $order->info['tax'] -= ($valid_array[$p]['products_price'] * $tax_rate)/100 * $ratio; // adjust tax -- Fred - added
                                }
                            }
			}
                    }
                    //NO RESTRICTION--------------------------------
		} else {
                    if ($get_result['coupon_type'] =='F' or $get_result['coupon_type'] =='S') {
                        $tod_amount = 0;
			if ($method=='Credit Note') {
                            $tod_amount = $od_amount / (100 + $tax_rate)* $tax_rate;
                            $order->info['tax_groups'][$tax_description] -= $tod_amount;
			} else {
//                          $ratio1 = $od_amount/$amount;   // this produces the wrong ratipo on fixed amounts
                            reset($order->info['tax_groups_clean']);
                            // php8 version
                            //while (list($key, $value) = each($order->info['tax_groups_clean'])) {
                            if(floatval($amount) != 0){
		                    foreach($order->info['tax_groups_clean'] as $key => $value) {
		                        //$ratio1 = $od_amount/($amount-$order->info['tax_groups'][$key]); ////debug
		                        // BUGFIX HENDRIK
		                        $ratio1 = $order->info['tax_groups'][$key]/$amount*$od_amount;

		                        // BUGFIX MARIO
		                        $new_key = current(array_reverse(explode(TAX_ADD_TAX,$key)));
		                        $tax_rate = xtc_get_tax_rate_from_desc($new_key);
		                        $net = $tax_rate * $order->info['tax_groups'][$key];
	//echo '<li>tax_rate '.$tax_rate.' / net: '.$net.' / ';
	//echo 'od_amount: '.$od_amount.' / amount: '.$amount.' / orderinfo[tax]: '.$order->info['tax_groups'][$key];
		                        if ($net>0) {
		                            ///$god_amount = $order->info['tax_groups'][$key] * $ratio1;
		                            // BUGFIX HENDRIK
		                            $god_amount = $ratio1;
		                            $tod_amount += $god_amount;
		                            $order->info['tax_groups'][$key] = $order->info['tax_groups'][$key] - $god_amount;
		                            $order->info['tax_groups_clean'][$key] = $order->info['tax_groups'][$key];
					}
		                    }
		              }
			}
// BUGFIX MARIO
//					$order->info['total'] -= $tod_amount; //OLD
			$order->info['tax'] -= $tod_amount; //Fred - added
                    }
                    if ($get_result['coupon_type'] =='P') {
                        $tod_amount=0;
                        if ($method=='Credit Note') {
                            $tod_amount = $order->info['tax_groups'][$tax_description] * $od_amount/100;
                            $order->info['tax_groups'][$tax_description] -= $tod_amount;
                        } else {
                            reset($order->info['tax_groups']);
                            // php8 bugfix
                            //while (list($key, $value) = each($order->info['tax_groups_clean'])) {
                            foreach($order->info['tax_groups_clean'] as $key => $value) {
                                $god_amount=0;
                                // BOF BUGFIX MARIO
                                // BLOEDSINN. WIR HABEN tax_percent IM value ARRAY
                                // $new_key = current(array_reverse(explode(TAX_ADD_TAX,$key)));
                                // $tax_rate = xtc_get_tax_rate_from_desc($new_key);
                                $tax_rate = (100+$value['tax_percent'])/100;
                                // EOF BUGFIX MARIO
                                $net = $tax_rate * $order->info['tax_groups'][$key];
                                if ($net>0) {
                                    $god_amount = $order->info['tax_groups'][$key] * $get_result['coupon_amount']/100;
                                    $tod_amount += $god_amount;
                                    $order->info['tax_groups'][$key] = $order->info['tax_groups'][$key] - $god_amount;
                                    $order->info['tax_groups_clean'][$key] = $order->info['tax_groups'][$key];
				}
                            }
			}
                        // BUGFIX MARIO - WIRD IRGENDWO VORHER RICHTIG BERECHNET
                        //$order->info['total'] -= $tod_amount; // have to modify total also
                        $order->info['tax'] -= $tod_amount;
                    }
// MARIO	}
            }
        }
        return $tod_amount;
    }

    function update_credit_account($i) {
	return false;
    }

    function apply_credit() {
        global $insert_id, $REMOTE_ADDR;
	if ($this->deduction !=0) {
            $new = new \YES4Trade\Model\coupon_redeem_track([
                'coupon_id'=>intval($_SESSION['cc_id']),
                'redeem_date'=>date('Y-m-d H:i:s'), 
                'redeem_ip'=>$REMOTE_ADDR, 
                'customer_id'=>(int)$_SESSION['customer_id'], 
                'order_id'=>intval($insert_id)
            ]);
            $new->create();
	}
	unset($_SESSION['cc_id']);
    }

    function get_order_total() {
        global $order;
	$order_total = $order->info['total'];
        
        // BOF BUGFIX UST Anzeigen = nein - UST verwenden = ja
        $cStatus = $this->Price->cStatus;
        $add_subtotal_tax = false;
        if($cStatus['customers_status_show_price'] == 1 and $cStatus['customers_status_show_price_tax'] == 0 and $cStatus['customers_status_add_tax_ot'] == 1){
            $add_subtotal_tax = true;
        }
        // EOF BUGFIX UST Anzeigen = nein - UST verwenden = ja
        
	// Check if gift voucher is in cart and adjust total
	$products = $_SESSION['cart']->get_products();
        // EU-OSS
        if($this->is_shopping_cart){
            $tax_country_id = (isset($_SESSION['default_shipping_countries_id'])) ? $_SESSION['default_shipping_countries_id'] : STORE_COUNTRY;
            $tax_zone_id =  (isset($_SESSION['default_shipping_zone_id'])) ? $_SESSION['default_shipping_zone_id'] : 0;
        }else{
            $tax_country_id = $order->delivery['country']['id'];
            $tax_zone_id = $order->delivery['zone_id'];
        }
        for ($i=0; $i<sizeof($products); $i++) {
            $t_prid = xtc_get_prid($products[$i]['id']);
            
            $gv_result = yes_query(
                "select products_price, products_model from " . TABLE_PRODUCTS . " where products_id =:products_id",
                ['products_id'=>$t_prid],
                true
            );
            
            $tax_rate = xtc_get_tax_rate($products[$i]['tax_class_id'], $tax_country_id, $tax_zone_id);
            $qty = $_SESSION['cart']->get_quantity($t_prid);
            
            if (substr( addslashes($gv_result['products_model']),0,4 ) == 'GIFT') {
                    if ($this->include_tax =='false') {
                            $gv_amount = $gv_result['products_price'] * $qty;
                    } else {
                            $gv_amount = ($gv_result['products_price'] + xtc_calculate_tax($gv_result['products_price'],$tax_rate)) * $qty;
                    }
                    $order_total=$order_total - $gv_amount;
            // BOF BUGFIX UST Anzeigen = nein - UST verwenden = ja
            }else{
                if($add_subtotal_tax){
                    $order_total += xtc_calculate_tax($gv_result['products_price'],$tax_rate) * $qty;
                }
            }
            // EOF BUGFIX UST Anzeigen = nein - UST verwenden = ja
        }
	if ($this->include_tax == 'false') {
            $order_total=$order_total-$order->info['tax'];
        }
	if ($this->include_shipping == 'false') {
            $order_total=$order_total-$order->info['shipping_cost'];
        }
	// OK thats fine for global coupons but what about restricted coupons
	// where you can only redeem against certain products/categories.
	// and I though this was going to be easy !!!
    	if(!isset($_SESSION['cc_id'])){
        	return $order_total;
	}
	$coupon = \YES4Trade\Model\coupons::get_by_coupon_id(intval($_SESSION['cc_id']));
	if ($coupon !== null) {
            $get_result = $coupon->toArray();
            $in_cat = true;
            if ($get_result['restrict_to_categories']) {
                $cat_ids = explode(",", $get_result['restrict_to_categories']);
                $in_cat=false;
                for ($i = 0; $i < sizeOf($cat_ids); $i++) {
                    if (is_array($this->contents)) {
                        reset($this->contents);
                        // php8 bugfix
                        //while (list($products_id, ) = each($this->contents)) {
                        foreach($this->contents as $products_id => $egal ) {
                            $cats_exists_array = \YES4Trade\Model\products_to_categories::get_items(
                                    intval($products_id), intval($cat_ids[$i])
                            );
                            if (sizeOf($cats_exists_array) > 0 ) {
                                $in_cat = true;
                                $total_price += $this->get_product_price($products_id);
                            }
                        }
                    }
                }
            }
            $in_cart = true;
            if ($get_result['restrict_to_products']) {
		$pr_ids = explode(",", $get_result['restrict_to_products']);
                $in_cart=false;
                $products_array = $_SESSION['cart']->get_products();
                for ($i = 0; $i < sizeof($pr_ids); $i++) {
                    for ($ii = 1; $ii<=sizeof($products_array); $ii++) {
                        if (xtc_get_prid($products_array[$ii-1]['id']) == $pr_ids[$i]) {
                            $in_cart=true;
                            $total_price += $this->get_product_price($products_array[$ii-1]['id']);
                        }
                    }
                }
                $order_total = $total_price;
            }
	}
	return $order_total;
}

function get_product_price($product_id) {
        global $order;
	$products_id = xtc_get_prid($product_id);
	// products price
	$qty = $_SESSION['cart']->contents[$product_id]['qty'];
        // EU-OSS
        if($this->is_shopping_cart){
            $tax_country_id = (isset($_SESSION['default_shipping_countries_id'])) ? $_SESSION['default_shipping_countries_id'] : STORE_COUNTRY;
            $tax_zone_id =  (isset($_SESSION['default_shipping_zone_id'])) ? $_SESSION['default_shipping_zone_id'] : 0;
        }else{
            $tax_country_id = $order->delivery['country']['id'];
            $tax_zone_id = $order->delivery['zone_id'];
        }
        $tax_class_id = yes_eu_oss_get_products_tax_class_id($products_id, $tax_country_id, $tax_zone_id);
	$product_query = yes_query(
            "select products_id, products_price, products_weight from " . TABLE_PRODUCTS . " where products_id=:products_id",
            ['products_id'=>$product_id]
        );
	if (is_countable($product_query) and sizeOf($product_query)) {
            $product = current($product_query);
            $prid = (int)$product['products_id'];
            
            // BOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
            /*if(yes_eu_oss_use_country_handling($tax_country_id)){
                $products_tax = xtc_get_tax_rate($tax_class_id, $tax_country_id, $tax_zone_id);
            }else{
                $products_tax = xtc_get_tax_rate($tax_class_id, STORE_COUNTRY,0);
            }*/
            // EOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
            
            // BUGF_CH_OSS
            $products_tax = xtc_get_tax_rate($tax_class_id, $tax_country_id, $tax_zone_id);
            
            $products_price = $product['products_price'];
            $specials_query = xtc_db_query("select specials_new_products_price from " . TABLE_SPECIALS . " where products_id = '" . $prid . "' and status = '1'");
            if (xtc_db_num_rows ($specials_query)) {
                $specials = xtc_db_fetch_array($specials_query);
                $products_price = $specials['specials_new_products_price'];
            }
            if ($this->include_tax == 'true') {
                $total_price += ($products_price + xtc_calculate_tax($products_price, $products_tax)) * $qty;
//                  echo("total price = " . $total_price . " products_price = " . $products_price . " products_tax = " . $products_tax . "<br>");

            } else {
                $total_price += $products_price * $qty;
            }

	}
	if ($this->include_shipping == 'true') {
            $total_price += $order->info['shipping_cost'];
	}
	return $total_price;
}

//Added by Fred -- BOF -----------------------------------------------------
function product_price($product_id) {
	$total_price = $this->get_product_price($product_id);
	if ($this->include_shipping == 'true') $total_price -= $order->info['shipping_cost'];
	return $total_price;
}
//Added by Fred -- EOF -----------------------------------------------------

function check() {
	if (!isset($this->check)) {
		$check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_ORDER_TOTAL_COUPON_STATUS'");
		$this->check = xtc_db_num_rows($check_query);
	}

	return $this->check;
}

function keys() {
	return array('MODULE_ORDER_TOTAL_COUPON_STATUS', 'MODULE_ORDER_TOTAL_COUPON_SORT_ORDER', 'MODULE_ORDER_TOTAL_COUPON_INC_SHIPPING', 'MODULE_ORDER_TOTAL_COUPON_INC_TAX', 'MODULE_ORDER_TOTAL_COUPON_CALC_TAX', 'MODULE_ORDER_TOTAL_COUPON_TAX_CLASS');
}

function install() {
	xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_id, configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('', 'MODULE_ORDER_TOTAL_COUPON_STATUS', 'true', '6', '1','xtc_cfg_select_option(array(\'true\', \'false\'), ', now())");
	xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_id, configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('', 'MODULE_ORDER_TOTAL_COUPON_SORT_ORDER', '70', '6', '2', now())");
	xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_id, configuration_key, configuration_value, configuration_group_id, sort_order, set_function ,date_added) values ('', 'MODULE_ORDER_TOTAL_COUPON_INC_SHIPPING', 'true', '6', '5', 'xtc_cfg_select_option(array(\'true\', \'false\'), ', now())");
	xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_id, configuration_key, configuration_value, configuration_group_id, sort_order, set_function ,date_added) values ('', 'MODULE_ORDER_TOTAL_COUPON_INC_TAX', 'true', '6', '6','xtc_cfg_select_option(array(\'true\', \'false\'), ', now())");
	xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_id, configuration_key, configuration_value, configuration_group_id, sort_order, set_function ,date_added) values ('', 'MODULE_ORDER_TOTAL_COUPON_CALC_TAX', 'None', '6', '7','xtc_cfg_select_option(array(\'None\', \'Standard\', \'Credit Note\'), ', now())");
	xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_id, configuration_key, configuration_value, configuration_group_id, sort_order, use_function, set_function, date_added) values ('', 'MODULE_ORDER_TOTAL_COUPON_TAX_CLASS', '0', '6', '0', 'xtc_get_tax_class_title', 'xtc_cfg_pull_down_tax_classes(', now())");
}

function remove() {
	$keys = '';
	$keys_array = $this->keys();
	for ($i=0; $i<sizeof($keys_array); $i++) {
		$keys .= "'" . $keys_array[$i] . "',";
	}
	$keys = substr($keys, 0, -1);

	xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in (" . $keys . ")");
	}
}
