<?php
/* -----------------------------------------------------------------------------------------
   $Id:

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommercebased on original files from OSCommerce CVS 2.2 2002/08/28 02:14:35 www.oscommerce.com
   (c) 2003	 nextcommerce (xsell_products.php,v 1.5 2003/08/13); www.nextcommerce.org

   Released under the GNU General Public License
   -----------------------------------------------------------------------------------------
   Third Party contribution:
   Cross-Sell (X-Sell) Admin 1				Autor: Joshua Dechant (dreamscape)

   Released under the GNU General Public License
   -----------------------------------------------------------------------------------------
   Also converted for XT-Commerce Witalij Olejnik(xaoc,xaoc2) xaoc@o2.pl
   ---------------------------------------------------------------------------------------*/
require_once(DIR_WS_CLASSES . 'product.php');
$module_smarty= new yesSmarty;
$module_smarty->assign('tpl_path','templates/'.CURRENT_TEMPLATE.'/');

if (isset($_GET['products_id'])) {
    //fsk18 lock
    $fsk_lock='';
    if ($_SESSION['customers_status']['customers_fsk18_display']=='0') {
        $fsk_lock=' and p.products_fsk18!=1';
    }
    $xsell_query_raw = sprintf("select p.products_fsk18,
        p.products_id,
        p.products_image,
        p.products_price,
        xp.sort_order,xp.reverse_cross_selling  
         from %s xp, %s p
         where (
                (xp.reverse_cross_selling=0 and xp.xsell_id =:products_id and p.products_id=xp.products_id) or
                (xp.products_id=:products_id and p.products_id=xp.xsell_id)
         )
         and p.products_status = '1' %s GROUP BY p.products_id 
         order by xp.sort_order asc",
        TABLE_PRODUCTS_XSELL,
        TABLE_PRODUCTS,
        $fsk_lock
    );
    $xsell_query = yes_query($xsell_query_raw,[
        'products_id'=>intval($_GET['products_id']),
    ]);
    $num_products_xsell = sizeOf($xsell_query);

    if ($num_products_xsell >= MIN_DISPLAY_ALSO_PURCHASED) {
        $row = 0;
        $module_content = array();
        $currency = $_SESSION['currency'];
        $customers_status_id=$_SESSION['customers_status']['customers_status_id'];
        $xtPrice = new xtcPrice($currency,$customers_status_id);
        foreach($xsell_query as $xsell) {
            $xsell_product = new product($xsell['products_id']);
            $xsell_product_info = $xsell_product->data;
            $info_array = $xsell_product->buildDataArray($xsell_product_info);

            $xsell['products_name'] = xtc_get_products_name($xsell['products_id']);
            //##### buy button ###
            if(($xsell['products_fsk18']=='1') AND ($_SESSION['customers_status']['customers_fsk18']=='1')){
                $xsell_buy_now = '<img src = templates/' . CURRENT_TEMPLATE . '/' . 'img/fsk18.gif>';
            }else{
                $xsell_buy_now = '<a href="' . xtc_href_link(basename($PHP_SELF), xtc_get_all_get_params(array('action','BUYproducts_id')) . 'action=buy_now&BUYproducts_id=' . $xsell['products_id'], 'NONSSL') . '">' . xtc_image_button('button_buy_now.gif', TEXT_BUY . $xsell['products_name'] . TEXT_NOW);
            }

            if($xsell['products_image'] != ''){
                $xsell_image = DIR_WS_THUMBNAIL_IMAGES . $xsell['products_image'];
            }

            $tax_id=$info_array['PRODUCTS_TAX_CLASS_ID'];
            $products_price=$xtPrice->xtcGetPrice($xsell['products_id'],
                $format=true,
                1,
                $tax_id,
                $xsell['products_price']
            );
		
            $module_content[]=array(
                'XSELL_NAME' => $xsell['products_name'],
                'XSELL_INFO' => xtc_href_link(FILENAME_PRODUCT_INFO, 'products_id=' . $xsell['products_id']),
                'XSELL_IMAGE' => $xsell_image,
                'XSELL_LINK' => xtc_href_link(FILENAME_PRODUCT_INFO, 'products_id=' . $xsell['products_id']),
                'XSELL_PRICE' => $products_price,
                'XSELL_BUY_NOW' => $xsell_buy_now,
                'XSELL_FSK18' => $xsell['products_fsk18'],
                'XSELL_CUSTOMERS_FSK18' => $_SESSION['customers_status']['customers_fsk18'],
                'XSELL_CUSTOMERS_SHOW_PRICE' => $_SESSION['customers_status']['customers_status_show_price'],
                'INFO'=>$info_array,
                'MANUFACTURER_INFO'=>$xsell_product->getManufacturersData()
            );
            $row ++;
	}
	$module_smarty->assign('language', $_SESSION['language']);
        $module_smarty->assign('module_content',$module_content);
        // set cache ID
        if (USE_CACHE=='false') {
            $module_smarty->caching = 0;
            $module= $module_smarty->fetch(CURRENT_TEMPLATE.'/module/xsell.html');
        } else {
            $module_smarty->caching = 1;
            $module_smarty->cache_lifetime=CACHE_LIFETIME;
            $module_smarty->cache_modified_check=CACHE_CHECK;
            $cache_id = $_SESSION['language'].((int)xtc_db_input($_GET['products_id'])).$_SESSION['customers_status']['customers_status_name'];
            $module= $module_smarty->fetch(CURRENT_TEMPLATE.'/module/xsell.html',$cache_id);
        }
        $info_smarty->assign('MODULE_xsell',$module);
    }
}
