<?php
require_once dirname(__DIR__) . '/yes/klarna/vendor/autoload.php';
require_once('includes/application_top.php');
require_once(DIR_FS_CATALOG.'includes/modules/payment/klarna_yes_pay_later.php');
require_once(DIR_FS_CATALOG.'lang/german//modules/payment/klarna_yes_pay_later.php');


 
//Make sure that it is a POST request.
if(strcasecmp($_SERVER['REQUEST_METHOD'], 'POST') != 0){
    throw new Exception('Request method must be POST!');
}
 
//Make sure that the content type of the POST request has been set to application/json
$contentType = isset($_SERVER["CONTENT_TYPE"]) ? trim($_SERVER["CONTENT_TYPE"]) : '';
if(strcasecmp($contentType, 'application/json') != 0){
    throw new Exception('Content type must be: application/json');
}
 
//Receive the RAW post data.
$content = trim(file_get_contents("php://input"));
 
//Attempt to decode the incoming RAW post data from JSON.
$decoded = json_decode($content, true);
 
//If json_decode failed, the JSON is invalid.
if(!is_array($decoded)){
    throw new Exception('Received content contained invalid JSON!');
}
$orderId = $decoded['klarna_order_id'];
$merchantId = $decoded['klarna_merchant_id'];
$sharedSecret = $decoded['klarna_secret'];

$klarna = new klarna_yes_pay_later();
if(isset($decoded['call'])){
    switch($decoded['call']){
        case 'capture':
            $capture_data = [
                'captured_amount'=>$decoded['captured_amount'],
                'description'=>$decoded['description']
            ];
            try {
                $response = $klarna->call('/ordermanagement/v1/orders/'.$orderId.'/captures', $capture_data);
                die($response);
            } catch (Exception $e) {
                die(json_encode(
                    array('error'=>'Caught exception: ' . $e->getMessage() . "\n")
                ));
            }
            break;
    }
    exit;
}
try {
    $response = $klarna->call('/ordermanagement/v1/orders/'.$orderId);
    die($response);
} catch (Exception $e) {
    die(json_encode(
        array('error'=>'Caught exception: ' . $e->getMessage() . "\n")
    ));
}

