<?php
include( 'includes/application_top.php');
$smarty = new yesSmarty;

require_once(DIR_WS_CLASSES.'yesCaptcha.php');
$captcha_lang = (isset($_SESSION['language']) and $_SESSION['language'] == 'english') ? 'english' : 'german';
$captcha = new yesTextCaptcha($captcha_lang);

if(defined('MODULE_OTHER_TURNSTILE_STATUS') and constant('MODULE_OTHER_TURNSTILE_STATUS') == 'True'){
    require_once(DIR_WS_MODULES.'other/turnstile.php');
    require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/modules/other/turnstile.php');
    $turnstile = true;
    $turnstile_class = new \turnstile();
}



$mail_smarty= new yesSmarty;
// include boxes
$YesBoxes->load( $smarty, basename(__FILE__) );
// include needed functions
require_once(DIR_FS_INC . 'xtc_draw_textarea_field.inc.php');
require_once(DIR_FS_INC . 'xtc_image_button.inc.php');
require_once(DIR_FS_INC . 'xtc_validate_email.inc.php');
require_once(DIR_WS_CLASSES.'class.phpmailer.php');
require_once(DIR_FS_INC . 'xtc_php_mail.inc.php');
require_once(DIR_FS_INC . 'xtc_render_vvcode.inc.php');
require_once(DIR_FS_INC . 'xtc_random_charcode.inc.php');

if (isset($_SESSION['customer_id'])) {
    $account = xtc_db_query("select customers_firstname, customers_lastname, customers_email_address from " . TABLE_CUSTOMERS . " where customers_id = '" . (int)$_SESSION['customer_id'] . "'");
    $account_values = xtc_db_fetch_array($account);
} elseif (defined('ALLOW_GUEST_TO_TELL_A_FRIEND') and constant('ALLOW_GUEST_TO_TELL_A_FRIEND') == 'false') {
    xtc_redirect(xtc_href_link(FILENAME_LOGIN, '', 'SSL'));
}
$valid_product = false;
if (isset($_GET['products_id'])) {
    $product_info_query = yes_query(sprintf(
        "select pd.products_name from %s p, %s pd where p.products_status = '1' and p.products_id =:products_id and p.products_id = pd.products_id and pd.language_id =:language_id",
            TABLE_PRODUCTS, TABLE_PRODUCTS_DESCRIPTION
        ),[
            'products_id'=>(int)$_GET['products_id'], 
            'language_id'=> (int)$_SESSION['languages_id'] 
        ]
    );
    $valid_product = (sizeOf($product_info_query) > 0);
}

$breadcrumb->add(NAVBAR_TITLE_TELL_A_FRIEND, xtc_href_link(FILENAME_TELL_A_FRIEND, 'send_to=' . $_GET['send_to'] . '&products_id=' . $_GET['products_id']));
require(DIR_WS_INCLUDES . 'header.php');
if ($valid_product == false) {
    xtc_redirect(FILENAME_DEFAULT);
    exit;
}
$product_info = current($product_info_query);
$smarty->assign('heading_tell_a_friend',sprintf(HEADING_TITLE_TELL_A_FRIEND, $product_info['products_name']));

$error = false;

if (isset($_GET['action']) && ($_GET['action'] == 'process') && !xtc_validate_email(trim($_POST['friendemail']))) {
    $friendemail_error = true;
    $error = true;
} else {
    $friendemail_error = false;
}

if(isset($_GET['action']) && $_GET['action'] == 'process'){
    if(!$turnstile){
        $msg = $captcha->check(false); // false = _POST
        if(isset($_POST['captcha_result'])){
            $captcha_success = ($msg == $captcha->lng['captcha_incorrect']) ? false : true;
        }else{
            if(!isset($_SESSION['vvcode']) or empty($_SESSION['vvcode'])){
            $captcha_success = false;    		
            }else{
                $captcha_success = $_POST['vvcode'] == $_SESSION['vvcode'];
            }
        }
    }else{
        $captcha_success = false;
        if($turnstile_class->verify()){
            $captcha_success = true;
        }
    }
    
    if(!$captcha_success){
    	// error report hier einbauen
	    $messageStack->add('tell_a_friend',($turnstile)?TEXT_CAPTCHA_FAILED : ERROR_CAPTCHA,'error');
	    $error = true;
    }
}

if (isset($_GET['action']) && ($_GET['action'] == 'process') && empty($_POST['friendname'])) {
    $friendname_error = true;
    $error = true;
} else {
    $friendname_error = false;
}

if (isset($_SESSION['customer_id'])) {
    $from_name = $account_values['customers_firstname'] . ' ' . $account_values['customers_lastname'];
    $from_email_address = $account_values['customers_email_address'];
} else {
    $from_name = $_POST['yourname'];
    $from_email_address = $_POST['from'];
}

if (!isset($_SESSION['customer_id'])) {
    if (isset($_GET['action']) && ($_GET['action'] == 'process') && !xtc_validate_email(trim($from_email_address))) {
	$fromemail_error = true;
	$error = true;
    } else {
	$fromemail_error = false;
    }
}

if (isset($_GET['action']) && ($_GET['action'] == 'process') && empty($from_name)) {
    $fromname_error = true;
    $error = true;
} else {
    $fromname_error = false;
}

if (isset($_GET['action']) && ($_GET['action'] == 'process') && ($error == false)) {
    $mail_smarty->assign('message',$_POST['yourmessage']);
    $mail_smarty->assign('language', $_SESSION['language']);

    $mail_smarty->assign('STORE_NAME_ADDRESS',STORE_NAME_ADDRESS);

    $mail_smarty->assign('tpl_path','templates/'.CURRENT_TEMPLATE.'/');
    $mail_smarty->assign('logo_path',HTTP_SERVER.DIR_WS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/img/');
    $mail_smarty->assign('PRODUCTS_LINK',xtc_href_link(FILENAME_PRODUCT_INFO, 'products_id=' . $_GET['products_id']));
    $mail_smarty->caching = 0;
    $html_mail = $mail_smarty->fetch(CURRENT_TEMPLATE . '/mail/'.$_SESSION['language'].'/tell_friend_mail.html');
    $mail_smarty->caching = 0;
    $txt_mail = $mail_smarty->fetch(CURRENT_TEMPLATE . '/mail/'.$_SESSION['language'].'/tell_friend_mail.txt');

    $smarty->assign('action','send');
    $smarty->assign('message',sprintf(TEXT_EMAIL_SUCCESSFUL_SENT, stripslashes($_POST['products_name']), $_POST['friendemail']));
    $smarty->assign('BUTTON_CONTINUE','<a href="' . xtc_href_link(FILENAME_PRODUCT_INFO, 'products_id=' . $_GET['products_id']) . '">' . xtc_image_button('button_continue.gif', IMAGE_BUTTON_CONTINUE) . '</a>');
    if(!main::isDev(true)){
        xtc_php_mail($from_email_address, $from_name,$_POST['friendemail'],$_POST['friendname'],'', $from_email_address, $from_name, '', '', CONTACT_US_EMAIL_SUBJECT, $html_mail , $txt_mail );
    }
} else {
    if (isset($_SESSION['customer_id'])) {
	$your_name_prompt = $account_values['customers_firstname'] . ' ' . $account_values['customers_lastname'];
	$your_email_address_prompt = $account_values['customers_email_address'];
    } else {
	$your_name_prompt = xtc_draw_input_field('yourname', (($fromname_error == true) ? $_POST['yourname'] : $_GET['yourname']));
	if ($fromname_error == true) $your_name_prompt .= '&nbsp;' . sprintf('<span class="errorText">%s</span>',TEXT_REQUIRED);
	$your_email_address_prompt = xtc_draw_input_field('from', (($fromemail_error == true) ? $_POST['from'] : $_GET['from']));
	if ($fromemail_error == true) $your_email_address_prompt .= ENTRY_EMAIL_ADDRESS_CHECK_ERROR;
    }

    $input_friendname= xtc_draw_input_field('friendname', $_POST['friendname']??'');
    if ($friendname_error == true) $input_friendname.= '&nbsp;' . sprintf('<span class="errorText">%s</span>',TEXT_REQUIRED);
    $input_friendemail= xtc_draw_input_field('friendemail', $_POST['friendemail']??'');
    if ($friendemail_error == true) $input_friendemail.= ENTRY_EMAIL_ADDRESS_CHECK_ERROR;
    
    $smarty->assign(array(
        'YES_CAPTCHA'=>($turnstile)?$turnstile_class->create():$captcha->create(),
        'FORM_ACTION'=>xtc_draw_form('email_friend', xtc_href_link(FILENAME_TELL_A_FRIEND, 'action=process&products_id=' . $_GET['products_id'])) . xtc_draw_hidden_field('products_name', $product_info['products_name']),
        'INPUT_NAME'=>$your_name_prompt,
        'INPUT_EMAIL'=>$your_email_address_prompt,
        'INPUT_MESSAGE'=>xtc_draw_textarea_field('yourmessage', 'soft', 40, 8,$_POST['yourmessage']??''),
        'INPUT_FRIENDNAME'=>$input_friendname,
        'INPUT_FRIENDEMAIL'=>$input_friendemail,
        'VVIMG'=>(!$turnstile)?'<img src="' . main::get_url_with_random_params(FILENAME_DISPLAY_VVCODES) . '" />':'',
        'INPUT_VVCODE'=>(!$turnstile)?xtc_draw_input_field('vvcode','','size="6" maxlenght="6"',false,'',false):'',
        'BUTTON_BACK'=>'<a href="' . xtc_href_link(FILENAME_PRODUCT_INFO, 'products_id=' . $_GET['products_id']) . '">' . xtc_image_button('button_back.gif', IMAGE_BUTTON_BACK) . '</a>',
        'BUTTON_SUBMIT'=>xtc_image_submit('button_continue.gif', IMAGE_BUTTON_CONTINUE)
    ));
} // EOF if process

if ($messageStack->size('tell_a_friend') > 0) {
	$smarty->assign('error',$messageStack->output('tell_a_friend'));
}

$smarty->assign('language', $_SESSION['language']);


	     // set cache ID
$smarty->caching = 0;
$main_content= $smarty->fetch(CURRENT_TEMPLATE.'/module/tell_a_friend.html');

$smarty->assign('language', $_SESSION['language']);
$smarty->assign('main_content',$main_content);
$smarty->caching = 0;
if (!defined('RM')) {
    $smarty->load_filter('output', 'note');
}
$smarty->display(CURRENT_TEMPLATE . '/index.html');
include ('includes/application_bottom.php');
