<?php
/**
 * ItemSalesRanksByMarketplace
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Catalog Items
 *
 * The Selling Partner API for Catalog Items provides programmatic access to information about items in the Amazon catalog. For more information, refer to the [Catalog Items API Use Case Guide](https://developer-docs.amazon.com/sp-api/docs/catalog-items-api-v2022-04-01-use-case-guide).
 *
 * The version of the OpenAPI document: 2022-04-01
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\CatalogItemsV20220401;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;

/**
 * ItemSalesRanksByMarketplace Class Doc Comment
 *
 * @category Class
 * @description Sales ranks of an Amazon catalog item for the indicated Amazon marketplace.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class ItemSalesRanksByMarketplace extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ItemSalesRanksByMarketplace';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'marketplace_id' => 'string',
        'classification_ranks' => '\SellingPartnerApi\Model\CatalogItemsV20220401\ItemClassificationSalesRank[]',
        'display_group_ranks' => '\SellingPartnerApi\Model\CatalogItemsV20220401\ItemDisplayGroupSalesRank[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'marketplace_id' => null,
        'classification_ranks' => null,
        'display_group_ranks' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'marketplace_id' => 'marketplaceId',
        'classification_ranks' => 'classificationRanks',
        'display_group_ranks' => 'displayGroupRanks'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'marketplace_id' => 'setMarketplaceId',
        'classification_ranks' => 'setClassificationRanks',
        'display_group_ranks' => 'setDisplayGroupRanks'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'marketplace_id' => 'getMarketplaceId',
        'classification_ranks' => 'getClassificationRanks',
        'display_group_ranks' => 'getDisplayGroupRanks'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['marketplace_id'] = $data['marketplace_id'] ?? null;
        $this->container['classification_ranks'] = $data['classification_ranks'] ?? null;
        $this->container['display_group_ranks'] = $data['display_group_ranks'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        if ($this->container['marketplace_id'] === null) {
            $invalidProperties[] = "'marketplace_id' can't be null";
        }
        return $invalidProperties;
    }


    /**
     * Gets marketplace_id
     *
     * @return string
     */
    public function getMarketplaceId()
    {
        return $this->container['marketplace_id'];
    }

    /**
     * Sets marketplace_id
     *
     * @param string $marketplace_id Amazon marketplace identifier.
     *
     * @return self
     */
    public function setMarketplaceId($marketplace_id)
    {
        $this->container['marketplace_id'] = $marketplace_id;

        return $this;
    }
    /**
     * Gets classification_ranks
     *
     * @return \SellingPartnerApi\Model\CatalogItemsV20220401\ItemClassificationSalesRank[]|null
     */
    public function getClassificationRanks()
    {
        return $this->container['classification_ranks'];
    }

    /**
     * Sets classification_ranks
     *
     * @param \SellingPartnerApi\Model\CatalogItemsV20220401\ItemClassificationSalesRank[]|null $classification_ranks Sales ranks of an Amazon catalog item for an Amazon marketplace by classification.
     *
     * @return self
     */
    public function setClassificationRanks($classification_ranks)
    {
        $this->container['classification_ranks'] = $classification_ranks;

        return $this;
    }
    /**
     * Gets display_group_ranks
     *
     * @return \SellingPartnerApi\Model\CatalogItemsV20220401\ItemDisplayGroupSalesRank[]|null
     */
    public function getDisplayGroupRanks()
    {
        return $this->container['display_group_ranks'];
    }

    /**
     * Sets display_group_ranks
     *
     * @param \SellingPartnerApi\Model\CatalogItemsV20220401\ItemDisplayGroupSalesRank[]|null $display_group_ranks Sales ranks of an Amazon catalog item for an Amazon marketplace by website display group.
     *
     * @return self
     */
    public function setDisplayGroupRanks($display_group_ranks)
    {
        $this->container['display_group_ranks'] = $display_group_ranks;

        return $this;
    }
}


