<?php
/**
 * ItemVendorDetailsByMarketplace
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Catalog Items
 *
 * The Selling Partner API for Catalog Items provides programmatic access to information about items in the Amazon catalog. For more information, refer to the [Catalog Items API Use Case Guide](https://developer-docs.amazon.com/sp-api/docs/catalog-items-api-v2022-04-01-use-case-guide).
 *
 * The version of the OpenAPI document: 2022-04-01
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\CatalogItemsV20220401;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;

/**
 * ItemVendorDetailsByMarketplace Class Doc Comment
 *
 * @category Class
 * @description Vendor details associated with an Amazon catalog item for the indicated Amazon marketplace.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class ItemVendorDetailsByMarketplace extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ItemVendorDetailsByMarketplace';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'marketplace_id' => 'string',
        'brand_code' => 'string',
        'manufacturer_code' => 'string',
        'manufacturer_code_parent' => 'string',
        'product_category' => '\SellingPartnerApi\Model\CatalogItemsV20220401\ItemVendorDetailsCategory',
        'product_group' => 'string',
        'product_subcategory' => '\SellingPartnerApi\Model\CatalogItemsV20220401\ItemVendorDetailsCategory',
        'replenishment_category' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'marketplace_id' => null,
        'brand_code' => null,
        'manufacturer_code' => null,
        'manufacturer_code_parent' => null,
        'product_category' => null,
        'product_group' => null,
        'product_subcategory' => null,
        'replenishment_category' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'marketplace_id' => 'marketplaceId',
        'brand_code' => 'brandCode',
        'manufacturer_code' => 'manufacturerCode',
        'manufacturer_code_parent' => 'manufacturerCodeParent',
        'product_category' => 'productCategory',
        'product_group' => 'productGroup',
        'product_subcategory' => 'productSubcategory',
        'replenishment_category' => 'replenishmentCategory'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'marketplace_id' => 'setMarketplaceId',
        'brand_code' => 'setBrandCode',
        'manufacturer_code' => 'setManufacturerCode',
        'manufacturer_code_parent' => 'setManufacturerCodeParent',
        'product_category' => 'setProductCategory',
        'product_group' => 'setProductGroup',
        'product_subcategory' => 'setProductSubcategory',
        'replenishment_category' => 'setReplenishmentCategory'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'marketplace_id' => 'getMarketplaceId',
        'brand_code' => 'getBrandCode',
        'manufacturer_code' => 'getManufacturerCode',
        'manufacturer_code_parent' => 'getManufacturerCodeParent',
        'product_category' => 'getProductCategory',
        'product_group' => 'getProductGroup',
        'product_subcategory' => 'getProductSubcategory',
        'replenishment_category' => 'getReplenishmentCategory'
    ];



    const REPLENISHMENT_CATEGORY_ALLOCATED = 'ALLOCATED';
    const REPLENISHMENT_CATEGORY_BASIC_REPLENISHMENT = 'BASIC_REPLENISHMENT';
    const REPLENISHMENT_CATEGORY_IN_SEASON = 'IN_SEASON';
    const REPLENISHMENT_CATEGORY_LIMITED_REPLENISHMENT = 'LIMITED_REPLENISHMENT';
    const REPLENISHMENT_CATEGORY_MANUFACTURER_OUT_OF_STOCK = 'MANUFACTURER_OUT_OF_STOCK';
    const REPLENISHMENT_CATEGORY_NEW_PRODUCT = 'NEW_PRODUCT';
    const REPLENISHMENT_CATEGORY_NON_REPLENISHABLE = 'NON_REPLENISHABLE';
    const REPLENISHMENT_CATEGORY_NON_STOCKUPABLE = 'NON_STOCKUPABLE';
    const REPLENISHMENT_CATEGORY_OBSOLETE = 'OBSOLETE';
    const REPLENISHMENT_CATEGORY_PLANNED_REPLENISHMENT = 'PLANNED_REPLENISHMENT';
    
    

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getReplenishmentCategoryAllowableValues()
    {
        $baseVals = [
            self::REPLENISHMENT_CATEGORY_ALLOCATED,
            self::REPLENISHMENT_CATEGORY_BASIC_REPLENISHMENT,
            self::REPLENISHMENT_CATEGORY_IN_SEASON,
            self::REPLENISHMENT_CATEGORY_LIMITED_REPLENISHMENT,
            self::REPLENISHMENT_CATEGORY_MANUFACTURER_OUT_OF_STOCK,
            self::REPLENISHMENT_CATEGORY_NEW_PRODUCT,
            self::REPLENISHMENT_CATEGORY_NON_REPLENISHABLE,
            self::REPLENISHMENT_CATEGORY_NON_STOCKUPABLE,
            self::REPLENISHMENT_CATEGORY_OBSOLETE,
            self::REPLENISHMENT_CATEGORY_PLANNED_REPLENISHMENT,
        ];

        // This is necessary because Amazon does not consistently capitalize their
        // enum values, so we do case-insensitive enum value validation in ObjectSerializer
        return array_map(function ($val) { return strtoupper($val); }, $baseVals);
    }
    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['marketplace_id'] = $data['marketplace_id'] ?? null;
        $this->container['brand_code'] = $data['brand_code'] ?? null;
        $this->container['manufacturer_code'] = $data['manufacturer_code'] ?? null;
        $this->container['manufacturer_code_parent'] = $data['manufacturer_code_parent'] ?? null;
        $this->container['product_category'] = $data['product_category'] ?? null;
        $this->container['product_group'] = $data['product_group'] ?? null;
        $this->container['product_subcategory'] = $data['product_subcategory'] ?? null;
        $this->container['replenishment_category'] = $data['replenishment_category'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        if ($this->container['marketplace_id'] === null) {
            $invalidProperties[] = "'marketplace_id' can't be null";
        }
        $allowedValues = $this->getReplenishmentCategoryAllowableValues();
        if (
            !is_null($this->container['replenishment_category']) &&
            !in_array(strtoupper($this->container['replenishment_category']), $allowedValues, true)
        ) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'replenishment_category', must be one of '%s'",
                $this->container['replenishment_category'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }


    /**
     * Gets marketplace_id
     *
     * @return string
     */
    public function getMarketplaceId()
    {
        return $this->container['marketplace_id'];
    }

    /**
     * Sets marketplace_id
     *
     * @param string $marketplace_id Amazon marketplace identifier.
     *
     * @return self
     */
    public function setMarketplaceId($marketplace_id)
    {
        $this->container['marketplace_id'] = $marketplace_id;

        return $this;
    }
    /**
     * Gets brand_code
     *
     * @return string|null
     */
    public function getBrandCode()
    {
        return $this->container['brand_code'];
    }

    /**
     * Sets brand_code
     *
     * @param string|null $brand_code Brand code associated with an Amazon catalog item.
     *
     * @return self
     */
    public function setBrandCode($brand_code)
    {
        $this->container['brand_code'] = $brand_code;

        return $this;
    }
    /**
     * Gets manufacturer_code
     *
     * @return string|null
     */
    public function getManufacturerCode()
    {
        return $this->container['manufacturer_code'];
    }

    /**
     * Sets manufacturer_code
     *
     * @param string|null $manufacturer_code Manufacturer code associated with an Amazon catalog item.
     *
     * @return self
     */
    public function setManufacturerCode($manufacturer_code)
    {
        $this->container['manufacturer_code'] = $manufacturer_code;

        return $this;
    }
    /**
     * Gets manufacturer_code_parent
     *
     * @return string|null
     */
    public function getManufacturerCodeParent()
    {
        return $this->container['manufacturer_code_parent'];
    }

    /**
     * Sets manufacturer_code_parent
     *
     * @param string|null $manufacturer_code_parent Parent vendor code of the manufacturer code.
     *
     * @return self
     */
    public function setManufacturerCodeParent($manufacturer_code_parent)
    {
        $this->container['manufacturer_code_parent'] = $manufacturer_code_parent;

        return $this;
    }
    /**
     * Gets product_category
     *
     * @return \SellingPartnerApi\Model\CatalogItemsV20220401\ItemVendorDetailsCategory|null
     */
    public function getProductCategory()
    {
        return $this->container['product_category'];
    }

    /**
     * Sets product_category
     *
     * @param \SellingPartnerApi\Model\CatalogItemsV20220401\ItemVendorDetailsCategory|null $product_category product_category
     *
     * @return self
     */
    public function setProductCategory($product_category)
    {
        $this->container['product_category'] = $product_category;

        return $this;
    }
    /**
     * Gets product_group
     *
     * @return string|null
     */
    public function getProductGroup()
    {
        return $this->container['product_group'];
    }

    /**
     * Sets product_group
     *
     * @param string|null $product_group Product group associated with an Amazon catalog item.
     *
     * @return self
     */
    public function setProductGroup($product_group)
    {
        $this->container['product_group'] = $product_group;

        return $this;
    }
    /**
     * Gets product_subcategory
     *
     * @return \SellingPartnerApi\Model\CatalogItemsV20220401\ItemVendorDetailsCategory|null
     */
    public function getProductSubcategory()
    {
        return $this->container['product_subcategory'];
    }

    /**
     * Sets product_subcategory
     *
     * @param \SellingPartnerApi\Model\CatalogItemsV20220401\ItemVendorDetailsCategory|null $product_subcategory product_subcategory
     *
     * @return self
     */
    public function setProductSubcategory($product_subcategory)
    {
        $this->container['product_subcategory'] = $product_subcategory;

        return $this;
    }
    /**
     * Gets replenishment_category
     *
     * @return string|null
     */
    public function getReplenishmentCategory()
    {
        return $this->container['replenishment_category'];
    }

    /**
     * Sets replenishment_category
     *
     * @param string|null $replenishment_category Replenishment category associated with an Amazon catalog item.
     *
     * @return self
     */
    public function setReplenishmentCategory($replenishment_category)
    {
        $allowedValues = $this->getReplenishmentCategoryAllowableValues();
        if (!is_null($replenishment_category) &&!in_array(strtoupper($replenishment_category), $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'replenishment_category', must be one of '%s'",
                    $replenishment_category,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['replenishment_category'] = $replenishment_category;

        return $this;
    }
}


